<?php

class LetsSyncroLLC_Oct8ne_Block_Accountconfig extends Mage_Core_Block_Template {

    private $_html = '';
    private $message = '';

    protected function _toHtml() {
        $submitLetsSyncroCredentials = $this->getRequest()->getParam('submitLetsSyncroCredentials');

        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $letssyncrooptions = $letssyncromodel->getData();

        if (isset($submitLetsSyncroCredentials)) {
            $letssyncro_useremail = $this->getRequest()->getParam('letssyncro_useremail');
            $letssyncro_password = $this->getRequest()->getParam('letssyncro_password');

            if (empty($letssyncro_useremail)) {
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $this->__('The field (Email) cannot be empty.') . '</div></li></ul></li></ul><br></div>';
            } elseif (empty($letssyncro_password)) {
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $this->__('The field (Password) cannot be empty.') . '</div></li></ul></li></ul><br></div>';
            } elseif (!$this->updateLetsSyncroUserPassword($letssyncrooptions, $letssyncromodel, $letssyncro_useremail, $letssyncro_password)) {
                $msg = $this->message;
                if (!$msg)  {
                    $msg = $this->__('There was an error in your credentials and we could not get OCT8NE integration data.');
                }
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $msg . '</div></li></ul></li></ul><br></div>';
            } elseif (!$this->updateLetsSyncroEnabled('1', $letssyncrooptions, $letssyncromodel)) {
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $this->__('There was an error activating OCT8NE integration.') . '</div></li></ul></li></ul><br></div>';
            } else {
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="success-msg"><ul><li><div id="themessage">' . $this->__('OCT8NE integration data obtained successfully!') . '</div></li></ul></li></ul><br></div>';
            }

            $letssyncromodel->save();
        }

        if ($this->getParam('deactivate')!==NULL && !isset($submitLetsSyncroCredentials)) {
			Mage::log('Deactivate');
            if (!$this->updateLetsSyncroEnabled('0', $letssyncrooptions, $letssyncromodel))
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $this->__('There was an error deactivating OCT8NE integration.') . '</div></li></ul></li></ul><br></div>';
            else
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="success-msg"><ul><li><div id="themessage">' . $this->__('OCT8NE integration deactivated successfully!') . '</div></li></ul></li></ul><br></div>';

            $letssyncromodel->save();
        }

        if ($this->getParam('activate')!==NULL && !isset($submitLetsSyncroCredentials)) {
			Mage::log('Activate');
            if (!$this->updateLetsSyncroEnabled('1', $letssyncrooptions, $letssyncromodel))
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="error-msg"><ul><li><div id="themessage">' . $this->__('There was an error activating OCT8NE integration.') . '</div></li></ul></li></ul><br></div>';
            else
                $this->_html .= '<div id="messagesbox"><ul class="messages"><li class="success-msg"><ul><li><div id="themessage">' . $this->__('OCT8NE integration activated successfully!') . '</div></li></ul></li></ul><br></div>';

            $letssyncromodel->save();
        }

        $this->_html .= '
        <script type="text/javascript">
           function submitAccountSetup() {
              var passw = document.getElementById(\'letssyncro_password\').value;
              document.getElementById(\'submitLetsSyncroCredentials\').style.display = "none";
              document.getElementById(\'executing\').style.display = "block";
              document.getElementById(\'letssyncro_password\').value = Base64.encode(passw);
              document.getElementById(\'generalsettings\').submit();
           }
        </script>
        <div class="content-header">
           <p><img src="' . $this->getSkinUrl('images/LetsSyncro_Logo.png') . '" alt="Oct8ne" title="Oct8ne" /></p>
        </div>
        <div class="entry-edit">
           <div class="entry-edit-head collapseable">
              <div class="section-config active">
                 <div class="entry-edit-head collapseable">
                    <a id="letssyncro_setup-head" class="open" onclick="Fieldset.toggleCollapse(\'letssyncro_setup\', \'\'); return false;" href="#">' . $this->__('Account Setup') . '</a>
                 </div>
                 <input type="hidden" value="1" name="config_state[letssyncro_setup]" id="letssyncro_setup-state">
              </div>
           </div>
        </div>
        ';

        $letssyncrooptions = $letssyncromodel->getData();
        $currentUrl_idx = strrpos($this->helper('core/url')->getCurrentUrl(), '/', -1);
        $currentUrl_ex = strlen(substr($this->helper('core/url')->getCurrentUrl(), $currentUrl_idx));
        $currentUrl = substr($this->helper('core/url')->getCurrentUrl(), 0, strlen($this->helper('core/url')->getCurrentUrl()) - $currentUrl_ex);

       // $oct8neSignupUrl = Mage::helper('oct8ne/url')->getOct8neSignupUrl();

        $linked_literal_deact = '<p class="LetsSyncro">' . $this->__('Status:') . ' <img src="' . $this->getSkinUrl('images/fam_bullet_success.gif') . '" alt="' . $this->__('Enabled') . '" title="' . $this->__('Enabled') . '" />
                     <a href="' . str_replace('/?activate', '', $currentUrl) . '/?deactivate">' . $this->__('(Deactivate)') . '</a></p>
                     <p class="LetsSyncro">' . $this->__('Linked account:') . ' <strong>' . $letssyncrooptions['email'] . '</strong></p><br />';
        $linked_literal_act = '<p class="LetsSyncro">' . $this->__('Status:') . ' <img src="' . $this->getSkinUrl('images/error_msg_icon.gif') . '" alt="' . $this->__('Disabled') . '" title="' . $this->__('Disabled') . '" />
                     <a href="' . str_replace('/?deactivate', '', $currentUrl) . '/?activate">' . $this->__('(Activate)') . '</a></p>
                     <p class="LetsSyncro">' . $this->__('Linked account:') . ' <strong>' . $letssyncrooptions['email'] . '</strong></p><br />';

        $this->_html .= '
         <form method="get" action="' . $currentUrl . '/" id="generalsettings" name="generalsettings" style="display:' . ((!$this->getParam('letssyncro_account') && !$this->getParam('letssyncro_syncro')) || ($this->getParam('letssyncro_account')) ? 'block;' : 'none;') . '" >
         <fieldset class="config collapseable" id="letssyncro_setup">';
        if ($letssyncrooptions['licenseid'] != '' && $letssyncrooptions['enabled'] == '0')
            $this->_html .= str_replace('&amp;activate', '', $linked_literal_act);
        elseif ($letssyncrooptions['licenseid'] != '' && $letssyncrooptions['enabled'] == '1')
            $this->_html .= str_replace('&amp;deactivate', '', $linked_literal_deact);

        $this->_html .= '
            <legend>' . $this->__('Account Setup') . '</legend>
            <table cellspacing="0" class="form-list">
               <colgroup class="label"></colgroup>
               <colgroup class="value"></colgroup>
               <colgroup class=""></colgroup>
               <tbody>
                  <tr id="row_letssyncro_setup_email">
                     <td class="label">
                        <label for="letssyncro_useremail">' . $this->__('Email:') . '</label>
                     </td>
                     <td class="value">
                        <input type="text" class="validate-email input-text required-entry" name="letssyncro_useremail" id="letssyncro_useremail" value="' . (($this->error AND $this->getParam('letssyncro_useremail')) ? $this->getParam('letssyncro_useremail') : $letssyncrooptions['email']) . '" />
                        <p class="note"><span>' . $this->__('Oct8ne email') . '</span></p>
                        <div id="advice-validate-email-letssyncro_useremail" class="validation-advice" style="display:none;">' . $this->__('Please, write a valid email address. For example jdoe@domain.com') . '</div>
                     </td>
                     <td class=""></td>
                  </tr>
                  <tr id="row_letssyncro_setup_password">
                     <td class="label">
                        <label for="letssyncro_password">' . $this->__('Password:') . '</label>
                     </td>
                     <td class="value">
                        <input type="password" class="input-text required-entry" name="letssyncro_password" id="letssyncro_password" value="' . (($this->error AND $this->getParam('letssyncro_password')) ? $this->getParam('letssyncro_password') : $this->urlsafe_b64decode($letssyncrooptions['password'])) . '" />
                        <p class="note"><span>' . $this->__('Oct8ne password') . '</span></p>
                     </td>
                     <td class=""></td>
                  </tr>
                  <tr id="row_letssyncro_setup_linkup">
                     <td class="label"></td>
                     <td class="value" style="height:21px;">
                        <div id="executing" style="display:none;padding-top:2px;font-weight: bold">' . $this->__('Executing, please wait...') . '</div>
                        <button type="button" id="submitLetsSyncroCredentials" onClick="submitAccountSetup();" class="scalable save" ><span>' . $this->__('Link Up') . '</span></button>
                        <input type="hidden" name="submitLetsSyncroCredentials" id="submitLetsSyncroCredentials" value="ok" />
                     </td>
                     <td class=""></td>
                  </tr>
               </tbody>
            </table>
               <br />
               <p class="LetsSyncro">' . $this->__('Don\'t have an oct8ne account? Email us: support@oct8ne.com') . '</p>
         </fieldset>
         </form><br />';
        return $this->_html;
    }

    public function updateLetsSyncroEnabled($letssyncro_enabled, $letssyncrooptions, $letssyncromodel) {
        $letssyncromodel->save();
        $letssyncrooptions = $letssyncromodel->getData();
        $letssyncro_licenseid = $letssyncrooptions['licenseid'];
        $letssyncro_apitoken = $letssyncrooptions['apitoken'];
        
        $letssyncro_server = $letssyncrooptions['server'];
        $letssyncro_urlStatic = $letssyncrooptions['url_static'];


        if ($this->getParam('letssyncro_enabled'))
            $letssyncro_enabled = $this->getParam('letssyncro_enabled');

        if ($letssyncro_enabled == '1' && ($letssyncro_licenseid == '' || strlen($letssyncro_licenseid) != 32))
            return false;

		try {
            //peticion
            $url = Mage::helper('oct8ne/url')->getOct8neLinkupServiceUrl();
            
            
            $data = array('email' => $letssyncrooptions['email'],
                'pass' =>  $this->urlsafe_b64decode($letssyncrooptions['password']),
                'platform' => 'MAGENTO',
                'urlDomain' => Mage::getBaseUrl(),
                'statusPlatform' => $letssyncro_enabled ? 1 : 0);

            $options = array(
                'http' => array(
                    'header' => "Content-Type: application/json;charset=UTF-8\r\n",
                    'method' => 'POST',
                    'content' => json_encode($data)
                )
            );
            $context = stream_context_create($options);
            $result = self::OctFileGetContents($url, false, $context);
            $result = json_decode($result);

            if (isset($result)) {
                //si se devuelve una licencia y token correctos se devuelve
                $license = $result->LicenseId;
                $token = $result->ApiToken;
                $server = $result->Server;			
                $urlStatic = $result->UrlStatic;
                
                $config = new Mage_Core_Model_Config();
                $config->saveConfig(trim('oct8neSite/siteUrls/oct8neServerUrl'), trim($server), 'default', 0);
                $config->saveConfig(trim('oct8neSite/siteUrls/oct8neStaticUrl'), trim($urlStatic), 'default', 0);
                //$msg = $result->Message;
                
                // Mage::app()->cleanCache();
                Mage::getConfig()->reinit();

                if ($license != null && $token != null) {
					Mage::log('Ha entrat al if de updateLetsSyncroEnabled');					
                    return $letssyncromodel->setEnabled($letssyncro_enabled);
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (Exception $ex) {
            return false;
        }
        /*$xmlData = $this->createXML_Logon($letssyncro_useremail, $letssyncro_password, $letssyncro_enabled ? 1 : 0);
        $linkup = Mage::helper('oct8ne/url')->getOct8neLinkupServiceUrl();
        $this->sendRequest($xmlData, 'logon', $linkup);*/

        return $letssyncromodel->setEnabled($letssyncro_enabled);		
    }
	
    public function updateLetsSyncroUserPassword($letssyncrooptions, $letssyncromodel, $letssyncro_useremail, $letssyncro_password) {
        if (!$letssyncromodel->setEmail($letssyncro_useremail) || !$letssyncromodel->setPassword($letssyncro_password))
            return false;

        $letssyncromodel->setApitoken('');
        $letssyncromodel->setLicenseid('');

		try {
            //peticion			
            $url = Mage::helper('oct8ne/url')->getOct8neLinkupServiceUrl();
            $data = array('email' => $letssyncro_useremail,
                'pass' =>  $this->urlsafe_b64decode($letssyncro_password),
                'platform' => 'MAGENTO',
                'urlDomain' => Mage::getBaseUrl());

            $options = array(
                'http' => array(
                    'header' => "Content-Type: application/json;charset=UTF-8\r\n",
                    'method' => 'POST',
                    'content' => json_encode($data)
                )
            );
            $context = stream_context_create($options);
            $result = self::OctFileGetContents($url, false, $context);
            $result = json_decode($result);

            if (isset($result)) {
                //si se devuelve una licencia y token correctos se devuelve
                $license = $result->LicenseId;
                $token = $result->ApiToken;
                $server = $result->Server;			
                $urlStatic = $result->UrlStatic;	
                
                $config = new Mage_Core_Model_Config();
                $config->saveConfig(trim('oct8neSite/siteUrls/oct8neServerUrl'), trim($server), 'default', 0);
                $config->saveConfig(trim('oct8neSite/siteUrls/oct8neStaticUrl'), trim($urlStatic), 'default', 0);
                Mage::getConfig()->reinit();
                //$msg = $result->Message;

                if ($license != null && $token != null) {
					Mage::log('Ha entrat al if de updateLetsSyncroUserPassword');
					if ($letssyncromodel->setApitoken($result->ApiToken) &&
						$letssyncromodel->setLicenseid($result->LicenseId) &&
						$letssyncromodel->setEmail($letssyncro_useremail) &&
						$letssyncromodel->setPassword($letssyncro_password)&&
						$letssyncromodel->setServer($result->Server) &&
						$letssyncromodel->setUrlStatic($result->UrlStatic)) {
						return true;
					}
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (Exception $ex) {
            return false;
        }		
    }
	
	private static function jsonResult($data) {
		$options = array(
			'http' => array(
				'header' => "Content-Type: application/json;charset=UTF-8\r\n",
				'method' => 'POST',
				'content' => json_encode($data)
			)
		);
		return $options;
	}
	
	private static function octFileGetContents($url, $use_include_path = false, $stream_context = null, $curl_timeout = 5)
    {
        if ($stream_context == null && preg_match('/^https?:\/\//', $url)) {
            $stream_context = @stream_context_create(array('http' => array('timeout' => $curl_timeout)));
        }
        if (in_array(ini_get('allow_url_fopen'), array('On', 'on', '1')) || !preg_match('/^https?:\/\//', $url)) {
            $meth = 'file_get_contents';
            return @$meth($url, $use_include_path, $stream_context);
        } elseif (function_exists('curl_init')) {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($curl, CURLOPT_TIMEOUT, $curl_timeout);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json;charset=UTF-8\r\n'));
            if ($stream_context != null) {
                $opts = stream_context_get_options($stream_context);
                if (isset($opts['http']['method']) && Tools::strtolower($opts['http']['method']) == 'post') {
                    curl_setopt($curl, CURLOPT_POST, true);
                    if (isset($opts['http']['content'])) {
                        curl_setopt($curl, CURLOPT_POSTFIELDS, $opts['http']['content']);
                    }
                }
            }
            $content = curl_exec($curl);
            curl_close($curl);
            return $content;
        } else {
            return false;
        }
    }

    public function sendRequest($xmlData, $method = '', $letssyncro_url, $letssyncro_apitoken = '') {
        $urlWithoutHttps = str_replace("https://", "http://", $letssyncro_url);
        
        if ($method == 'logon')
            $letssyncro_url = $letssyncro_url . '/' . $method;
        else
            $letssyncro_url = $letssyncro_url . '/updateNodes?userid=' . $letssyncro_apitoken;

       
        if (function_exists('curl_init') == 1) {
            $ch = curl_init($letssyncro_url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xmlData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $response = curl_exec($ch);
            $error = curl_error($ch);
            curl_close($ch);          

            if ($error && strpos(strtolower($error), 'ssl') !== false) {
               if($urlWithoutHttps != $letssyncro_url) {
                   return $this->sendRequest($xmlData, $method, $urlWithoutHttps, $letssyncro_apitoken);
               }
            }
        } else {
            $opts = array('http' =>
                array(
                    'method' => 'POST',
                    'header' => 'Content-type: text/xml',
                    'content' => $xmlData
                )
            );
            $context = stream_context_create($opts);

            $response = file_get_contents($letssyncro_url, false, $context);
        }

        return $response;
    }

    public function createXML_Logon($letssyncro_useremail, $letssyncro_password, $status_platform = null) {
        $DOM = new DOMDocument('1.0', 'UTF-8');
        $XML = $DOM->createElement('User');
        $XML->setAttribute('xmlns', 'http://schemas.datacontract.org/2004/07/Syncro.WebService');
        $XML->setAttribute('xmlns:i', 'http://www.w3.org/2001/XMLSchema-instance');
        $DOM->appendChild($XML);

        $Email = $DOM->createElement('Email', $letssyncro_useremail);
        $Pass = $DOM->createElement('Pass', $this->urlsafe_b64decode($letssyncro_password));
        $baseurl = $DOM->createElement('BaseUrl', Mage::getBaseUrl());
        $checkouturl = $DOM->createElement('CheckoutUrl', Mage::helper('checkout/url')->getCheckoutUrl());
        $loginurl = $DOM->createElement('LoginUrl', Mage::helper('customer')->getLoginUrl());
        // $currency = $DOM->createElement('CheckoutUrl', Mage::helper('checkout/url')->getCheckoutUrl());
        $platform = $DOM->createElement('Platform', 'MAGENTO');
        $domain = $DOM->createElement('UrlDomain', str_replace("index.php/", "", Mage::getBaseUrl()));

        if (!is_null($status_platform))
            $StatusPlatform = $DOM->createElement('StatusPlatform', $status_platform);

        $XML->appendChild($baseurl);
        $XML->appendChild($checkouturl);
        // $XML->appendChild($currency); <-- habrá mas de 1 currency, preguntar que hacer
        $XML->appendChild($Email);
        $XML->appendChild($loginurl);
        $XML->appendChild($Pass);
        $XML->appendChild($platform);

        if (!is_null($status_platform))
            $XML->appendChild($StatusPlatform);


        $XML->appendChild($domain);

        return $DOM->saveXML($DOM->documentElement);
    }

    function urlsafe_b64encode($string) {
        $data = base64_encode($string);
        $data = str_replace(array('+', '/', '='), array('-', '_', '.'), $data);
        return $data;
    }

    function urlsafe_b64decode($string) {
        $data = str_replace(array('-', '_', '.'), array('+', '/', '='), $string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    function getParam($name) {
        $value = $this->getRequest()->getParam($name);
        return $value;
    }

}
