<?php

/*
  Añadimos la posibilidad de meter javascript inline
 */

class LetsSyncroLLC_Oct8ne_Block_Html_Head extends Mage_Page_Block_Html_Head {

    /**
     * Classify HTML head item and queue it into "lines" array
     *
     * @see self::getCssJsHtml()
     * @param array &$lines
     * @param string $itemIf
     * @param string $itemType
     * @param string $itemParams
     * @param string $itemName
     * @param array $itemThe
     */
    protected function _separateOtherHtmlHeadElements(&$lines, $itemIf, $itemType, $itemParams, $itemName, $itemThe) {
        parent::_separateOtherHtmlHeadElements($lines, $itemIf, $itemType, $itemParams, $itemName, $itemThe);
        $line = $lines[$itemIf];
        if (key_exists('other', $line)) {
            $tmp = count($line['other']);
            if ($tmp == count($lines[$itemIf]['other'])) {
                $params = $itemParams ? ' ' . $itemParams : '';
                $href = $itemName;
                switch ($itemType) {
                    case 'script':
                        $lines[$itemIf]['other'][] = sprintf('<script type="text/javascript">%s</script>', $params);
                        break;
                }
            }
        }
    }

}
