<?php

class LetsSyncroLLC_Oct8ne_Helper_CustomerData extends Mage_Core_Helper_Abstract {
    
    public function getLoginData() {
        if (!Mage::getSingleton('customer/session')->isLoggedIn()) {
            return null;
        } else {
            $customer = Mage::getSingleton('customer/session')->getCustomer();
            return array(
                'id' => $customer->getId(),
                'first_name' => $customer->getFirstname(),
                'last_name' => $customer->getLastname(),
                'email' => $customer->getEmail()
            );
        }
    }

    public function getCartData() {
        $dataHelper = Mage::helper("oct8ne"); /* @var $dataHelper LetsSyncroLLC_Oct8ne_Helper_Data */

        $quote = Mage::getSingleton('checkout/session')->getQuote();
        $items = $quote->getAllVisibleItems();
        $result = array();
        foreach ($items as $item) {
            $result[] = $dataHelper->createProductSummaryFromProduct($item->product, $item->getQty());
        }
        return $result;
    }

    public function getWishlistData() {
        return Mage::helper("oct8ne/wishlist")->getWishList();
    }

}
