<?php

class LetsSyncroLLC_Oct8ne_Helper_Debug extends Mage_Core_Helper_Abstract {

    private static $LOG_ENABLED = FALSE;
    private static $PROFILER_ENABLED = FALSE;

    public static function log($message) {
        if (self::$LOG_ENABLED) {
            Mage::log($message, null, "oct8ne.log", TRUE);
        }
    }

    public static function startProfile($msg = NULL) {
        if(!self::$PROFILER_ENABLED) {
            return;
        }
        if (!is_null($msg)) {
            self::log($msg);
        }
        return microtime(true);
    }

    public static function endProfile($start, $action) {
        if(!self::$PROFILER_ENABLED) {
            return;
        }        
        $now = microtime(true);
        self::log($action . ': ' . number_format($now - $start, 4) . ' secs');
    }

}
