<?php

class LetsSyncroLLC_Oct8ne_Helper_Image_Default extends Mage_Core_Helper_Url {

    private static $profiler = NULL;

    public function getProductImagesUrl($product) {

        $profiler = $this->getProfiler(); /* @var $profiler LetsSyncroLLC_Oct8ne_Helper_Debug */
        $gallery_data = $product->getData('media_gallery');
        $start = $profiler->startProfile();
        if (!$gallery_data) {
            $attributes = $product->getTypeInstance(true)->getSetAttributes($product);
            $media_gallery = $attributes['media_gallery'];
            $backend = $media_gallery->getBackend();
            $backend->afterLoad($product);
            $gallery_data = $product->getMediaGalleryImages();
            $gallery_info = $gallery_data;
            // $product->load('media_gallery');
            // $gallery_data = $product->getData('media_gallery');
        } else {
            $gallery_info = $gallery_data['images'];
            if (array_key_exists('configurable_images', $gallery_data)) {
                $gallery_info = $gallery_data['configurable_images'];
            }
        }
        $profiler->endProfile($start, '[Data]     - Load medias from database');

        $start = $profiler->startProfile();

        $images = $this->getValidImages($gallery_info, $product);

        $v = array();
        foreach ($images as $image) {
            $v[] = array(
                'url' => $image
            );
        }
        $profiler->endProfile($start, '[Data]     - Compose array of image urls');
        return $v;
    }

    public function getProductThumbnail($product, $width = null) {
        $result = $this->getThumbnail($product, $width, 'thumbnail', $product->getThumbnail());
        if (!$result) {
            $result = $this->getThumbnail($product, $width, 'small_image', $product->getSmallImage());
            if (!$result) {
                $result = $this->getThumbnail($product, $width, 'image', $product->getImage());
                if (!$result) {
                    $result = $this->getFirstGalleryImage($product, $width);
                    if (!$result) {
                        return $this->getParentThumbnail($product, $width);
                    }
                }
            }
        }
        return $result;
    }

    public function resizeImg($fileName, $width, $height = null) {

        // If not filename specified, return the small placeholder
        if (!$fileName) {
            return $this->getPlaceholder($width, $height);
        }

        $originalImageUrl = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $this->getProductDir($fileName);
        $originalImagePhysicalPath = $this->getImagePhysicalPath($fileName);
        $resizedImagePhysicalPath = Mage::getBaseDir(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $this->getCachedProductDir($fileName, $width);
        $resizedImageUrl = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $this->getCachedProductDir($fileName, $width);

        // If the original image doesn`t exist, return the small placeholder
        if (!is_file($originalImagePhysicalPath)) {
            return $this->getPlaceholder($width, $height);
        }

        // If width is not specified, the image is returned "as is"
        if (!$width) {
            return $this->sanitizeUrl($this->removeHttp($originalImageUrl));
        }

        // If the cached image already exists, return it
        if (file_exists($resizedImagePhysicalPath)) {
            return $this->sanitizeUrl($this->removeHttp($resizedImageUrl));
        }

        // If the cached image if smaller than the width requested, return it

        $imageObj = new Varien_Image($originalImagePhysicalPath);
        if ($imageObj->getOriginalWidth() <= $width) {
            return $this->sanitizeUrl($this->removeHttp($originalImageUrl));
        }

        // If we got this so far, resize and return the new image
        $imageObj->constrainOnly(TRUE);
        $imageObj->keepAspectRatio(FALSE);
        $imageObj->keepFrame(FALSE);
        $imageObj->keepTransparency(TRUE);
        $imageObj->resize($width, $height);
        $imageObj->save($resizedImagePhysicalPath);
        return $this->sanitizeUrl($this->removeHttp($resizedImageUrl));
    }

    public function getImagePhysicalPath($fileName) {
        return Mage::getBaseDir(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $this->getProductDir($fileName);
    }

    protected function getPlaceholder($width, $height) {
        $width = $width ? $width : 120;
        $height = $height ? $height : $width;
        return $this->removeHttp(Mage::getModel('catalog/product')->getSmallImageUrl($width, $height));
    }

    protected function getFirstGalleryImage($product, $width) {

        $product->getResource()->getAttribute('media_gallery')
                ->getBackend()->afterLoad($product);

        $gallery = $product->getMediaGalleryImages();
        $imageUrl = NULL;
        $file = NULL;
        foreach ($gallery as $image) {
            $file = $image['file'];
            break;
        }
        if (!is_null($width) && $file) {
            $imageUrl = $this->resizeImg($file, $width);
        }
        return $imageUrl;
    }

    protected function sanitizeUrl($url) {
        $url = str_replace("\\", "/", $url);
        $prefix = "";

        if (substr($url, 0, 7) == "http://") {
            $prefix = "http:";
        } else if (substr($url, 0, 8) == "https://") {
            $prefix = "https://";
        } else if (substr($url, 0, 2) == "//") {
            $prefix = "//";
        }
        $path = $prefix == "" ? $url : substr($url, strlen($prefix));
        while (strpos($path, "//") !== false) {
            $path = str_replace("//", '/', $path);
        }
        $result = $prefix . $path;
        return $result;
    }

    protected function getProductDir($file) {
        return "catalog" . DS . "product" . DS . $file;
    }

    protected function getCachedProductDir($file, $width) {
        return "catalog" . DS . "product" . DS . "cache" . DS . "resized" . DS . $width . DS . $file;
    }

    protected function removeHttp($str) {
        return preg_replace('#^https?:#', '', $str);
    }

    protected function getProfiler() {
        if (is_null(self::$profiler)) {
            self::$profiler = Mage::helper('oct8ne/debug');
        }
        return self::$profiler;
    }

    protected function getThumbnail($product, $width, $imageType, $url) {
        if ($url == 'no_selection') {
            return NULL;
        }
        $thumb = Mage::helper('catalog/image')->init($product, $imageType);
        if (!is_null($width)) {
            $thumb->resize($width);
        }
        $file = (string) $thumb;
        return $file;
    }

    protected function getParentThumbnail($product, $width) {
        if ($product->getTypeId() == "simple") {
            $parentIds = Mage::getModel('catalog/product_type_grouped')->getParentIdsByChild($product->getId());
            if (!$parentIds) {
                $parentIds = Mage::getModel('catalog/product_type_configurable')->getParentIdsByChild($product->getId());
            }
            if (isset($parentIds[0])) {
                $parent = Mage::getModel('catalog/product')->load($parentIds[0]);
                return $this->getProductThumbnail($parent, $width);
            }
        }
        $imageUrl = $this->getPlaceholder($width, $width);
        return $imageUrl;
    }

    protected function getAbsoluteImageUrl($file, $width) {

        if ($width) {
            return $this->resizeImg($file, $width);
        }

        $file = ltrim($file, "/");
        $file = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . $this->getProductDir($file);
        $file = str_replace(DS, '/', $file);
        return $this->removeHttp($file);
    }

    // Returns valid gallery images for a product.
    // If no image could be found:
    //     - Try to return Image, Small_Image or Thumbnail (in that order)
    //     - If still no images found, return the placeholder

    protected function getValidImages($gallery, $product) {
        $mustIgnoreExcludedImages = Mage::getStoreConfig('oct8neData/productData/ignoreExcludedImages');
        $useProductActualImages = Mage::getStoreConfig('oct8neData/productData/returnActualProductImageUrl');
        $actualProductImageWidth = Mage::getStoreConfig('oct8neData/productData/actualProductImageWidth');
        $url = Mage::getUrl('oct8ne/frame/image');
        $join = (strstr($url, "?") === FALSE) ? '?' : '&';
        $result = array();
        foreach ($gallery as $image) {
            $isImageExcluded = $image['disabled'] == '1' || $image['disabled_default'] == '1';
            if (!$isImageExcluded || !$mustIgnoreExcludedImages) {
                $file = $image['file'];
                if ($useProductActualImages) {
                    $result[] = $this->getAbsoluteImageUrl($file, $actualProductImageWidth);
                } else {
                    if (strpos($file, '/') !== 0) {
                        $file = "/$file";
                    }
                    $result[] = $this->removeHttp($url) . $join . 'file=' . $file;
                }
            }
        }
        if (empty($result)) {
            if ($product->getImage() != 'no_selection') {
                $result[] = $product->getImageUrl();
            } else {
                if ($product->getSmallImage() != 'no_selection') {
                    $result[] = $product->getSmallImageUrl();
                } else {
                    if ($product->getThumbnail() != 'no_selection') {
                        $result[] = $product->getThumbnailUrl();
                    } else {
                        // Return the standard placeholder
                        $result[] = $this->removeHttp(Mage::getModel('catalog/product')->getImageUrl(400, 400));
                    }
                }
            }
        }
        return $result;
    }

}
