<?php

class LetsSyncroLLC_Oct8ne_Helper_Image_Schuler extends LetsSyncroLLC_Oct8ne_Helper_Image_Default {

    public function getProductThumbnail($product, $width = null) {

        $result = $this->getSchulerThumbnail($product);
        return $result;
    }

    public function getProductImagesUrl($product) {
        if (!$product->isConfigurable()) {
            return parent::getProductImagesUrl($product);
        }
        // Process configurable products
        $childProducts = Mage::getModel('catalog/product_type_configurable')->getUsedProducts(null, $product);
        $images = array();
        foreach ($childProducts as $simpleProduct) {
            if ($simpleProduct->isSaleable()) {
                $simpleProductImages = parent::getProductImagesUrl($simpleProduct);
                foreach($simpleProductImages as $productImage) {
                    $images[] = $productImage["url"];
                }
            }
        }
        
        // If no simple product images available, just return configurable product's images        
        if (count($images) == 0) {
            return parent::getProductImagesUrl($product); 
        }
        
        $images = array_unique($images); // Remove duplicates
        $result = array();
        foreach ($images as $img) {
            $result[] = array(
                'url' => $img
            );
        }
        return $result;
    }

    public function getSchulerThumbnail($product) {
        $profiler = $this->getProfiler(); /* @var $profiler LetsSyncroLLC_Oct8ne_Helper_Debug */
        $gallery_data = $product->getData('media_gallery');
        $start = $profiler->startProfile();
        if (!$gallery_data) {
            $attributes = $product->getTypeInstance(true)->getSetAttributes($product);
            $media_gallery = $attributes['media_gallery'];
            $backend = $media_gallery->getBackend();
            $backend->afterLoad($product);
            $gallery_data = $product->getMediaGalleryImages();
            $gallery_info = $gallery_data;
        } else {
            $gallery_info = $gallery_data['images'];
            if (array_key_exists('configurable_images', $gallery_data)) {
                $gallery_info = $gallery_data['configurable_images'];
            }
        }

        $mustIgnoreExcludedImages = Mage::getStoreConfig('oct8neData/productData/ignoreExcludedImages');
        foreach ($gallery_info as $image) {
            $fileName = $image['file'];
            $isImageExcluded = $image['disabled'] == '1' || $image['disabled_default'] == '1';
            if (!$isImageExcluded || !$mustIgnoreExcludedImages) {
                $physicalPath = Mage::getBaseDir(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $this->getProductDir($fileName);
                if (is_file($physicalPath)) {
                    $file = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . $this->getProductDir($fileName);
                    return $file;
                }
            }
        }
        return $this->getPlaceholder(200, 200);
    }

}
