<?php

class LetsSyncroLLC_Oct8ne_Helper_Reports extends Mage_Core_Helper_Abstract {
    
    public function getSales($from, $to, $storeId = NULL) {
        $orderCollection = Mage::getModel('oct8ne/order')->getCollection();
        
        if (!empty($from)) {            
            $from = date('Y-m-d', strtotime($from)) . ' 00:00:00';
            $orderCollection->getSelect()->where("utc_last_modified >= CAST(? AS DATETIME)", $from);
        }
        if (!empty($to)) {
            $to = date('Y-m-d', strtotime($to)) . ' 23:59:59';
            $orderCollection->getSelect()->where("CAST(? AS DATETIME) >= utc_last_modified", $to);
        }
        
        if(!empty($storeId)) {
            $orderCollection->getSelect()->where("store_id = ?", storeId);            
        }
        $orderCollection->setOrder('utc_last_modified', 'ASC');
        
        $result = array();
        foreach ($orderCollection as $item) {
            $result[] = array(                
                'quoteId' => $item['quote_id'],
                'orderId' => $item['order_id'],
                // 'storeId' => $item['store_id'], // Not needed for now
                'sessionId' => $item['session_id'],
                'customerId' => $item['customer_id'],
                'price' => $item['price'],
                'finalPrice' => $item['final_price'],
                'currency' => $item['currency'],
                'productsCount' => $item['products_count'],
                'itemsCount' => $item['items_count'],
                'lastAction' => $item['last_action'],
                'utcCreated' => $item['utc_created'],
                'utcLastUpdated' => $item['utc_last_modified']
            );
        }
        return $result;
    }

}
