<?php

abstract class LetsSyncroLLC_Oct8ne_Helper_Search_Base extends Mage_Core_Helper_Abstract {

    private $params = array();

    public abstract function getEngineName();

    public abstract function search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, &$totalSearchResults, &$attrs_applied, &$attrs_available);

    public abstract function getRelatedProductIds($product, $page, $pageSize);

    public abstract function isValidSearchCriteria($searchTerm);

    public function __construct() {

        // $configurationString example:
        // key1=value1;key2=value2
        $configurationString = Mage::getStoreConfig('oct8neSearch/searchEngine/params');
        $currentLocaleCode = strtolower(Mage::app()->getLocale()->getLocaleCode());
        if(strlen($currentLocaleCode) > 2) {
            $currentLocaleCode = substr($currentLocaleCode, 0, 2);
        }
        $currentStoreId = Mage::app()->getStore()->getStoreId();
        
        if (!is_null($configurationString) && strlen($configurationString) > 0) {
            $lines = explode(';', $configurationString);
            foreach ($lines as $line) {
                $keyValue = explode('=', $line);
                if (count($keyValue) == 2) {
                    $key = trim($keyValue[0]);
                    $value = str_replace('$lang', $currentLocaleCode, $keyValue[1]);
                    $value = str_replace('$storeId', $currentStoreId, $keyValue[1]);
                    $this->params[$key] = trim($value);
                }
            }
        }
    }

    protected function getEngineParam($param) {
        if (isset($this->params[$param])) {
            return trim($this->params[$param]);
        }
        return NULL;
    }

    public function getRequest() {
        return Mage::app()->getRequest();
    }

    /**
     * Creates a filter option structure
     * @param string $label Text to show
     * @param string $value Value to apply when the option is selected
     * @param number $count Number of products found
     * @return A FilterOption object
     */
    protected function createFilterOption($label, $value, $count) {

        return array(
            "valueLabel" => $label,
            "value" => $value,
            "count" => $count
        );
    }

    /**
     * Creates a filter info structure
     * @param string $param Parameter name sent to the search action
     * @param string $paramLabel Parameter text description
     * @param array $options Array of filterOptions
     * @param string $currentValueLabel Current filter label 
     * @param string $currentValue Current filter value
     * @return A filter info object
     */
    protected function createFilterInfo($param, $paramLabel, $options, $currentValueLabel = null, $currentValue = null) {
        $result = array(
            'param' => $param,
            'paramLabel' => $paramLabel,
            'options' => $options
        );
        if (!is_null($currentValue)) {
            $result['valueLabel'] = $currentValueLabel;
            $result['value'] = $currentValue;
        }
        return $result;
    }

    /**
     * Creates am AppliedFilter structure
     * @param string $param Parameter name
     * @param string $param Parameter display name
     * @param number $value Parameter value
     * @param number $valueLabel Parameter value display text
     * @return An AppliedFilter object
     */
    protected function createAppliedFilter($param, $paramLabel, $value, $valueLabel) {

        return array(
            "param" => $param,
            "paramLabel" => $paramLabel,
            "value" => $value,
            "valueLabel" => $valueLabel
        );
    }

    /*
     * Gets the filters from the query string parameters
     * @return Dictionary of filter query string parameters
     */
    protected function getAppliedFilters() {
        $request = $this->getRequest();

        $queryStringParams = $request->getParams();
        $facets = array();
        foreach ($queryStringParams as $param) {
            // Ignore standard query standard params
            if (substr($param, 0, 1) == '_' || $param=='currency' || $param=='locale' || $param == 'callback' || $param == 'search' || $param == 'store' || $param == 'orderby' || $param == 'dir' || $param == 'page' || $param == 'pageSize') {
                continue;
            }

            // If we get here, the param is a facet
            $value = $request->getParam($param);
            if (!is_null($value) && trim($value)!="") {
                $facets[$param] = $value;
            }
        }
        return $facets;
    }

    /* Return the available filters that have not been applied
     * @param $attrs_applied Array of applied filters
     * @param $attrs_available Array of all available filters
     * @return Available filters without appliend filters
     */
    protected function getAvailableButNotAppliedFilters($attrs_applied, $attrs_available) {
        $result = array();
        $applied = array();
        foreach ($attrs_applied as $attr) {
            $applied[$attr["param"]] = 1;
        }
        foreach ($attrs_available as $attr) {
            if (!isset($applied[$attr["param"]])) {
                $result[] = $attr;
            }
        }
        return $result;
    }

    protected function log($message) {
        $debug = Mage::helper('oct8ne/debug'); /* @var $debug LetsSyncroLLC_Oct8ne_Helper_Debug */
        $engineName = $this->getEngineName();
        $debug->log("[Search-{$engineName}] " . $message);
    }

}
