<?php 
include("SearchInformation.php");
include("QwiserSearchResults.php");
include("QwiserProducts.php");
include("QwiserProduct.php");
include("SortingOptions.php");
include("QwiserQuestions.php");
include("QwiserQuestion.php");
include("QwiserAnswers.php");
include("QwiserAnswer.php");
include("QwiserSearchPath.php");
include("QwiserSearchPathEntry.php");
include("QwiserSpellerInformation.php");
include("QwiserConcepts.php");
include("QwiserConcept.php");
include("QwiserProductAnswers.php");
include("QwiserProductAnswer.php");
include("QwiserProductFields.php");
include("QwiserProductField.php");
// include("domxml-php4-to-php5.php");


class QwiserSearchAPI
{
	var $CommunicationPort;	//The name of the comm port to use for access to the search server. 
	var $HostName;	//The name of the search server to connect to.
	var $SiteKey;	//the api site key.
	var $LastOperationErrorMessage; //the last operation error message.
	var $LastOperationSucceeded; //return true if the last operation ended successfully.	
	var $WebService;	//Search WebService full uri.
	var $Context ;
	
	/**
	* Constructor
	**/
	public function __construct($SiteKey,$HostName,$CommunicationPort)
	{
		$this->HostName = $HostName;
		$this->CommunicationPort = $CommunicationPort;
		$this->SiteKey = $SiteKey;
		$this->WebService ="http://".$this->HostName.":".$this->CommunicationPort."/";
        $this->LastOperationSucceeded = true;

        $opts = array(
            'http'=>array(
                'method'=>"GET",
                'header'=>"Accept-Language: en-US,en;q=0.8rn" .
                    "Accept-Encoding: gzip, deflate" .
                    "Accept-Charset: UTF-8,*;q=0.5rn" .
                    "User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:19.0) Gecko/20100101 Firefox/19.0 FirePHP/0.4rn"
            )
        );

		$Context = stream_context_create($opts);

	}


	//Activate serach Profile
	Function ActivateProfile($SearchHandle,$SearchProfile)
	{
		$SearchProfile = urlencode($SearchProfile);
		$RequestUrl = "ActivateProfile?SearchHandle=".$SearchHandle."&SearchProfile=".$SearchProfile."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Answer Question
	Function AnswerQuestion($SearchHandle,$AnswerId,$EffectOnSearchPath)
	{
		$RequestUrl = "AnswerQuestion?SearchHandle=".$SearchHandle."&answerId=".$AnswerId."&EffectOnSearchPath=".$EffectOnSearchPath."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Answer Question
	Function AnswerQuestions($SearchHandle,$AnswerIds,$EffectOnSearchPath)
	{
		$RequestUrl = "AnswerQuestions?SearchHandle=".$SearchHandle."&answerIds=".$AnswerIds."&EffectOnSearchPath=".$EffectOnSearchPath."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Change Number of Products in Page
	Function ChangePageSize($SearchHandle,$PageSize)
	{
		$RequestUrl = "ChangePageSize?SearchHandle=".$SearchHandle."&pageSize=".$PageSize."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Change the search default price 
	Function ChangePriceColumn($SearchHandle,$PriceColumn)
	{
		$RequestUrl = "ChangePriceColumn?SearchHandle=".$SearchHandle."&PriceColumn=".$PriceColumn."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");	
	}
	
	//Deactivate Search Profile
	Function DeactivateProfile($SearchHandle)
	{
		$RequestUrl = "DeactivateProfile?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Moves to the first page of the results
	Function FirstPage($SearchHandle)
	{
		$RequestUrl = "FirstPage?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Forces the BQF to allow the specified question to appear first
	Function ForceQuestionAsFirst($SearchHandle,$QuestionId)
	{
		$RequestUrl = "ForceQuestionAsFirst?SearchHandle=".$SearchHandle."&QuestionId=".$QuestionId."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");	
	}

	//Gets the results for the specified search handle
	Function GetCustomResults($SearchHandle,$bNewSearch,$PreviousSearchHandle)
	{
		$RequestUrl = "GetCustomResults?SearchHandle=".$SearchHandle."&NewSearch=".$bNewSearch."&PreviousSearchHandle=".$PreviousSearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");	
	}
	
	//Return the LastPage.
	Function LastPage($SearchHandle)
	{
		$RequestUrl = "LastPage?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Moves to the specified page of the results
	Function MoveToPage($SearchHandle,$Page)
	{
		$RequestUrl = "MoveToPage?SearchHandle=".$SearchHandle."&Page=".$Page."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Moves to the previous page of the results 
	Function PreviousPage($SearchHandle)
	{
		$RequestUrl = "PreviousPage?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Moves to the next page of the results 
	Function NextPage($SearchHandle)
	{
		$RequestUrl = "NextPage?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Removes the specified answer from the list of answered answers in this session. 
	Function RemoveAnswer($SearchHandle,$AnswerId)
	{
		$RequestUrl = "RemoveAnswer?SearchHandle=".$SearchHandle."&AnswerId=".$AnswerId."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Removes the specified answers from the list of answered answers in this session. 
	Function RemoveAnswerAt($SearchHandle,$AnswerIndex)
	{
		$RequestUrl = "RemoveAnswerAt?SearchHandle=".$SearchHandle."&AnswerIndex=".$AnswerIndex."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}

	//Removes the specified answers from the list of answered answers in this session. 
	Function RemoveAnswers($SearchHandle,$AnswerIds)
	{
		$RequestUrl = "RemoveAnswers?SearchHandle=".$SearchHandle."&AnswerIds=".$AnswerIds."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Remove the all the answer from the search information form the given index
	Function RemoveAnswersFrom($SearchHandle,$StartIndex)
	{
		$RequestUrl = "RemoveAnswersFrom?SearchHandle=".$SearchHandle."&StartIndex=".$StartIndex."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	
	//Gets the results for the specified search term.
	Function Search($Query)
	{
        $Query = urlencode($Query);
        $RequestUrl = "search?Query=".$Query."&sitekey=".$this->SiteKey;
        return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Gets the results for the specified search term under the specified search profile and the answer which Id was specified. 
	Function SearchAdvance($Query,$SearchProfile,$AnswerId,$EffectOnSearchPath,$PriceColumn,$PageSize,$Sortingfield,$bNumericsort,$bAscending)
	{
		$Query = urlencode($Query);
		$SearchProfile = urlencode($SearchProfile);
		$Sortingfield = urlencode($Sortingfield);
		$PriceColumn = urlencode($PriceColumn);
		$RequestUrl = "SearchAdvance?Query=".$Query."&SearchProfile=".$SearchProfile."&AnswerId=".$AnswerId."&EffectOnSearchPath=".$EffectOnSearchPath."&PriceColumn=".$PriceColumn."&PageSize=".$PageSize."&Sortingfield=".$Sortingfield."&Numericsort=".$bNumericsort."&Ascending=".$bAscending."&sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//set the general params of the api
	Function SetQwiserSearchAPI($siteKey ,$serverName ,$port )
	{
		$this->SiteKey = $siteKey;
		$this->HostName = $serverName;
		$this->CommunicationPort = $port;	
	}
	
	//Changes the sorting of the results to display products by the value of the specified field, and whether to perform a numeric sort on that field, in the specified sorting direction. 
	Function SortByField($SearchHandle,$FieldName,$bNumericSort,$bAscending)
	{
		$FieldName = urlencode($FieldName);
		$RequestUrl = "SortByField?SearchHandle=".$SearchHandle."&FieldName=".$FieldName."&NumericSort=".$bNumericSort."&Ascending=".$bAscending."&sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Changes the sorting of the results to display products by their price in the specified sorting direction 
	Function SortByPrice($SearchHandle,$bAscending)
	{
		$RequestUrl = "SortByPrice?SearchHandle=".$SearchHandle."&Ascending=".$bAscending."&sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}
	
	//Changes the sorting of the results to display products by relevancy in descending order.
	Function SortByRelevancy($SearchHandle)
	{
		$RequestUrl = "SortByRelevancy?SearchHandle=".$SearchHandle."&Sitekey=".$this->SiteKey;
		return $this->GetResult($RequestUrl,"QwiserSearchResults");
	}

    //Marks a product as out of stock.
    Function RemoveProductFromStock($Sku)
    {
        $Sku = urlencode($Sku);
        $RequestUrl = "RemoveProductFromStock?Sku=".$Sku."&Sitekey=".$this->SiteKey;
        return $this->GetResult($RequestUrl,"String");
    }

    //Marks a product as in stock.
    Function RestoreProductToStock($Sku)
    {
        $Sku = urlencode($Sku);
        $RequestUrl = "RestoreProductToStock?Sku=".$Sku."&Sitekey=".$this->SiteKey;
        return $this->GetResult($RequestUrl,"String");
    }

    Function UpdateProductPrice($Sku, $Price, $FieldName, $SearchProfile)
    {
        $RequestUrl = "UpdateProductPrice?Sitekey=".$this->SiteKey."&Sku=".$Sku."&Price=".$Price."&Fieldname=".$FieldName."&Profilename=".$SearchProfile;
        $this->GetResult($RequestUrl, "");
    }

    Function GetProductsMetaData()
    {
        $RequestUrl = "GetProductsMetaData?Sitekey=".$this->SiteKey	;
        return $this->GetResult($RequestUrl,"QwiserProductsMetaData");
    }
		
	Function getUrl($url)
	{
		$content = file_get_contents($url , false, $this->Context); 
		
		if($content == FALSE)
		{
			return FALSE ;
		}

		//If http response header mentions that content is gzipped, then uncompress it
		foreach($http_response_header as $c => $h)
		{
			if(stristr($h, 'content-encoding') and stristr($h, 'gzip'))
			{
				//Now lets uncompress the compressed data
				$content = gzinflate( substr($content,10,-8) );
			}
		}
     
		return $content;
	}
	
	//Gets the xml file, parse it and chack for Errors.  
	Function GetResult($RequestUrl,$ReturnValue)
	{		
		$xml_file = $this->getUrl($this->WebService.$RequestUrl) ;
		
		//file_get_contents return value should be true.
		if($xml_file === FALSE)
		{			
            $this->LastOperationSucceeded = false;
			$this->LastOperationErrorMessage = "Error : could not GET XML input, there might be a problem with the connection";
			return;
		}
		
		//Parse the xml file with php4 Dom parser.
		$xml_doc=domxml_open_mem($xml_file);
		
		//domxml_open_mem should Return object.
		if ((!is_object($xml_doc)) && !$xml_doc)
		{			
			$this->LastOperationSucceeded = false;
			$this->LastOperationErrorMessage = "Error : could not parse XML input, there might be a problem with the connection";
			return ;
		}
		
		//Get the Root Element.
		$xml_root=$xml_doc->document_element();
		
		//Check the ErrorOccured node in the xml file 
		
		if(!$this->CheckForAPIErrors($xml_root))
		{			
			return ;
		}		
		
		return $this->GetReturnValue($xml_root,$ReturnValue);   	
	}
	
	//return value by xml type
	function GetReturnValue($xml_root,$ReturnValue)
	{		
		switch ($ReturnValue)
		{
			case "QwiserSearchResults":
				return (new QwiserSearchResults($xml_root));
			break;
			case "String":
				return $this->SimpleStringParser($xml_root);
			break;
			case "QwiserQuestions":
				return (new QwiserQuestions(current($xml_root->get_elements_by_tagname("Questions"))));
			break;
			case "QwiserProductAnswers":
				return (new QwiserProductAnswers(current($xml_root->get_elements_by_tagname("ProductAnswers"))));
			break;
			case "QwiserProductFields":				
				print_r($xml_root) ;
				return (new QwiserProductFields(current($xml_root->get_elements_by_tagname("ProductFields"))));
			break;
			case "QwiserSearchPath":
				return (new QwiserSearchPath(current($xml_root->get_elements_by_tagname("SearchPath"))));
			break;
			case "QwiserAnswers":
				return (new QwiserAnswers(current($xml_root->get_elements_by_tagname("Answers"))));
			break;
			case "QwiserSimpleStringCollection":
				return GetQwiserSimpleStringCollection(current($xml_root->get_elements_by_tagname("QwiserSimpleStringCollection")));			
			break;
			case "QwiserSimpleStringCollection":
				return new QwiserProductsMetaData(current($xml_root->get_elements_by_tagname("Products")));			
			break;
		}
	}
	
	//Checks the error node
	function CheckForAPIErrors($xml_root)
	{
	
		$ErrorNode = current($xml_root->get_elements_by_tagname("QwiserError"));
		if(is_object($ErrorNode))
		{
			$MethodName = $ErrorNode->get_attribute("MethodName");
			if($MethodName=="")
			{
				return true; 
			}
			$ErrorMessage = $ErrorNode->get_attribute("ErrorMessage");
			$this->LastOperationErrorMessage = "Error: MethodName=".$MethodName." ErrorMessage=".$ErrorMessage;
			
			$this->LastOperationSucceeded = false;	
	
		}
		else 
		{
			$this->LastOperationErrorMessage = "Error: ".$xml_root->get_content();				
		}			
		return false;			
	}
	
	//returns the "ReturnValue" node as string
	function SimpleStringParser($xml_root)
	{
		$StringValue = current($xml_root->get_elements_by_tagname("ReturnValue"));
		return $StringValue->get_content();	
	}	
}

//Global function: Returns Array of strings from Array of nodes contents. 
function GetQwiserSimpleStringCollection ($xml_node)
{
	$xml_nodes = $xml_node->child_nodes();
	$xml_nodes = getDomElements($xml_nodes);
	$arr = array();
	foreach($xml_nodes as $node)
	{
		$arr[] = $node->get_content();
	}
	return $arr;
}

//Global function: Returns hash of value .
function GetQwiserSimpleStringDictionary($xml_node)
{
	$xml_nodes = $xml_node->child_nodes();
	$xml_nodes = getDomElements($xml_nodes);
	$arr = array();
	foreach($xml_nodes as $node)
	{
		$arr[$node->get_attribute("name")] = $node->get_attribute("value");
	}
	return $arr;
}

//Global function: Returns Array of only DomElments
function getDomElements($element)
{
	$p=0;
	$new_element = array();
	foreach ($element as $value)
	{
		if($value->node_type()==1)
		{
			$new_element[$p]=$value;
			$p++;
		}
	}
	return $new_element;
}