<?php 
class QwiserSearchResults
{
	var $xml_root;
	var $QwiserSearchResults;
	var $SearchInformation;
	var $Questions;
	var $SearchPath;
	var $Products;
	var $QueryConcepts;
	var $SpellerInformation ;
	var $RelatedSearches;
	var $SpecialCasesDetectedInThisSearch;
	
	public function __construct($root)
	{
		$this->xml_root = $root;
		$this->QwiserSearchResults = current($this->xml_root->get_elements_by_tagname("QwiserSearchResults"));
		
		$this->SearchInformation = NEW SearchInformation(current($this->xml_root->get_elements_by_tagname("SearchInformation")));
		$this->Questions =	NEW QwiserQuestions(current($this->xml_root->get_elements_by_tagname("Questions")));
		$this->SearchPath = NEW QwiserSearchPath(current($this->xml_root->get_elements_by_tagname("SearchPath")));
		$this->Products = NEW QwiserProducts(current($this->xml_root->get_elements_by_tagname("Products")));
		$this->QueryConcepts = NEW QwiserConcepts(current($this->xml_root->get_elements_by_tagname("QueryConcepts")));
		$this->SpellerInformation = NEW QwiserSpellerInformation(current($this->xml_root->get_elements_by_tagname("SpellerInformation")));
		$this->RelatedSearches  = GetQwiserSimpleStringCollection(current($this->xml_root->get_elements_by_tagname("RelatedSearches")));
		$this->SpecialCasesDetectedInThisSearch  = current($this->xml_root->get_elements_by_tagname("SpecialCasesDetectedInThisSearch"));
	}
	
	Function GetExactMatchFound()
	{
		return $this->QwiserSearchResults->get_attribute("ExactMatchFound");
	}
	
	Function GetLogHandle()
	{
		return $this->QwiserSearchResults->get_attribute("LogHandle");
	}
	
	Function GetSearchHandle()
	{
		return $this->QwiserSearchResults->get_attribute("SearchHandle");
	}
	
	Function GetMaxMatchClassFound()
	{
			return $this->QwiserSearchResults->get_attribute("MaxMatchClassFound");
	}
	
	Function GetMinMatchClassFound()
	{
			return $this->QwiserSearchResults->get_attribute("MinMatchClassFound");
	}	
	
	Function GetRecommendedMessage()
	{
			return $this->QwiserSearchResults->get_attribute("RecommendedMessage");
	}
	
	Function GetRedirectionUrl()
	{
			return $this->QwiserSearchResults->get_attribute("RedirectionUrl");
	}
	
	Function GetRelevantProductsCount()
	{
			return $this->QwiserSearchResults->get_attribute("RelevantProductsCount");
	}
	
	Function GetSearchDataVersion()
	{
			return $this->QwiserSearchResults->get_attribute("SearchDataVersion");
	}
	
	Function GetSearchEngineTimeDuration()
	{
			return $this->QwiserSearchResults->get_attribute("SearchEngineTimeDuration");
	}
	
	Function GetSearchTimeDuration()
	{
			return $this->QwiserSearchResults->get_attribute("SearchTimeDuration");
	}
	
	Function GetSearchStatus()
	{
		return $this->QwiserSearchResults->get_attribute("SearchStatus");
	}
	
	Function GetSpecialCasesDetectedInThisSearch()
	{
		return $this->SpecialCasesDetectedInThisSearch->get_elements_by_tagname("Value");
	}
		
}