<?php

/* Doofinder Search engine adapter 
 */

class LetsSyncroLLC_Oct8ne_Helper_Search_Doofinder extends LetsSyncroLLC_Oct8ne_Helper_Search_Base {
    public function getEngineName() {
        return "doofinder";
    }
    
    const FilterRangeSeparator = ":::";

    public function isValidSearchCriteria($searchTerm) {
        if (is_null($searchTerm) || strlen($searchTerm) == 0) {
            return false;
        }
        return true;
    }

    public function search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, &$totalSearchResults, &$attrs_applied, &$attrs_available) {
        $this->log("Searching " . $searchTerm);
        $result = $this->executeDoofinderSearchQuery($searchTerm, NULL, $searchOrder, $searchDir, $page, $pageSize);
        if (is_null($result)) {
            return array();
        }
        $totalSearchResults = $result["total"];
        $productIds = $this->getProductIds($result);

        //$allAvailableFilters = $this->getAvailableFilters($result);
        $attrs_applied = $this->getResponseAppliedFilter($allAvailableFilters);
        $attrs_available = $this->getAvailableButNotAppliedFilters($attrs_applied, $allAvailableFilters);
        
//        if (!empty($productIds)) {
//            // Uncomment for local testing
//            $productIds = array('906', '875', '874', '554', '553', '552', '551', '549', '399', '398');
//        }
        return $productIds;
    }

    public function getRelatedProductIds($product, $page, $pageSize) {
        $name = $product->getName();        
        if (!empty($name)) {
            $result = $this->executeDoofinderSearchQuery($name, NULL, 'relevance', 'asc', $page, $pageSize, FALSE);
        }        
        $productIds = $this->getProductIds($result);        
//        if (!empty($productIds)) {
//            // Uncomment for local testing
//            $productIds = array('906', '875', '874', '554', '553', '552', '551', '549', '399', '398');
//        }
        return $productIds;
    }

    private function executeDoofinderSearchQuery($searchTerm, $searchCategories, $searchOrder, $searchDir, $page, $pageSize, $includeFacets = TRUE, $method = NULL) {
        if (!function_exists('curl_init')) {
            return NULL;
        }
        $url = $this->getDoofinderProtocol()."://##zone##-search.doofinder.com/5/search";
        $zone = $this->getEngineParam("zone");
        $host = str_replace("##zone##", $zone, $url);
        $query_name = $this->getEngineParam("queryname");
                
        if(is_null($query_name)){
            $query_name = "match_and";
        }
                
        $sortLaber = $this->getDoofinderSort($searchOrder);     
        if($sortLaber != "_score" || ($sortLaber == "_score" && $searchDir != "desc")){
            $queryParams = array(
                'hashid' => $this->getEngineParam("hashid"),
                'rpp' => $pageSize,//response results will be formatted as native JSON objects
                'page' => $page,         
                'query' => $searchTerm,        
                'query_name' => $query_name,
                'sort['.$sortLaber.']' => $searchDir,
                //'filter[categories][0]' => 'New Arrivals'
            ); 
        }else{
            $queryParams = array(
                'hashid' => $this->getEngineParam("hashid"),
                'rpp' => $pageSize,//response results will be formatted as native JSON objects
                'page' => $page,         
                'query' => $searchTerm,        
                'query_name' => $query_name                
            ); 
        }
        
        if ($includeFacets) {
//            $queryParams = $this->getFacets($queryParams);
        }

        $query = $host . '?' . http_build_query($queryParams);
        $this->log("Executing query: {$query}");
        $request = curl_init($query);
        
        curl_setopt($request, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($request, CURLOPT_POST, 1);
        curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);
        
        $headers = array(
            'Authorization: Token ' . $this->getEngineParam("token"),
            'Content-Type: application/json',
            'Expect:', // Fixes the HTTP/1.1 417 Expectation Failed error
        );  
        
        curl_setopt($request, CURLOPT_HTTPHEADER, $headers);
        
        $response = curl_exec($request);
        $err = curl_error($request);
        if (is_null($err) || $err == "") {
            $result = json_decode($response, true);
            if (is_null($result)) {
                $contentType = curl_getinfo($request, CURLINFO_CONTENT_TYPE);
                $msg = "Doofinder search is not returning valid JSON data, or result is empty. Content-type returned: " . $contentType;
                Mage::log("[Oct8ne] " . $msg);
                $this->log($msg);
            } else {
                $this->log("Query result received");
            }
        } else {
            $this->log("Search error: " . $err);
            $result = NULL;
        }
        curl_close($request);
        return $result;
    }

    private function getProductIds($result) {
        $productIds = array();
        foreach ($result["results"] as $product) {
            $productIds[] = $product["id"];
        }
        return $productIds;
    }
    
    private function getAvailableFilters($result) {
        $filters = array();
        foreach ($result["facets"] as $key => $facet) {
            if (key_exists("parent_id", $facet)) {
                continue; // Ignore sub-facets
            }

            $options = array();  
            foreach ($facet["terms"]["buckets"] as $value) {
//                if(isset($value["low"]) && isset($value["high"])){                    
//                    $options[] = $this->createFilterOption($value["label"], urlencode( $value["low"].self::FilterRangeSeparator.$value["high"]) , $value["count"]);
//                }else{
                //'filter[categories][0]' => 'New Arrivals'
                    $options[] = $this->createFilterOption($value["key"],$value["key"], $value["doc_count"]);
//                }
            }
            $filters[] = $this->createFilterInfo($key,$key, $options);
        }
        return $filters;
    }
    
    private function getResponseAppliedFilter($availableFilters) {
        $filters = array();
        $request = $this->getRequest();
        $pos=0;
        foreach ($availableFilters as $availableFilter) {
            $filterParameterValue = $request->getParam($availableFilter["param"]);
            if (!is_null($filterParameterValue)) {
                $options = $availableFilter["options"];
                $currentLabelPre = $this->getCurrentOptionLabel($filterParameterValue, $options);
                $currentLabel = str_replace("##pos##", $pos, $currentLabelPre);

                $filters[] = $this->createFilterInfo(
                        $availableFilter["param"], urldecode($availableFilter["paramLabel"]), $options, $currentLabel, $filterParameterValue
                );
                $pos = $pos + 1;
            }
        }
        return $filters;
    }
    
    private function getDoofinderSort($searchOrder) {
        $result = "";
        if (!$searchOrder) {
            $searchOrder = "_score";
        }
        switch ($searchOrder) {
            case "score":
                $result = "_score";
                break;
            case "relevance":
                $result = "_score"; // By default, the order is "relevance"
                break;
            case "price":
                $result = "price";
                break;
            case "name":
                $result = "title";
        }
        return $result;
    }
    
    function getDoofinderProtocol() {
        $protocol = $this->getEngineParam("protocol");
        if(is_null($protocol)){
            $protocol = "https";            
        }
        return $protocol;
    }
    
    private function getFacets($queryParams) {

        $appliedFilters = $this->getAppliedFilters();
        if ($appliedFilters) {
            $facet = "";
            foreach ($appliedFilters as $param => $value) {
                if (!is_null($value) && trim($value) != '') {
                    $value = urldecode($value);
                    if(strpos($value,self::FilterRangeSeparator) === false){
                        $queryParams["filter.".$param] = $value;
                    }else{
                        $params = explode(self::FilterRangeSeparator, $value);
                        if(count($params)>1){
                            $queryParams["filter.".$param.".low"] = $params[0];
                            $queryParams["filter.".$param.".high"] = $params[1];
                        }else if(count($params)>0){
                            $queryParams["filter.".$param.".low"] = $params[0];
                        }     
                    }
                }
            }
        }
        return $queryParams;
    }
    
    private function getCurrentOptionLabel($value, $options) {
        foreach ($options as $option) {            
            if ($option['value'] == $value) {
                return $option["valueLabel"];
            }
        }
        return $value;
    }
}
