<?php
/* Klevu Search engine adapter
 * Example:
    host=http://eucs8.ksearchnet.com/;
    ticket=klevu-15336339967378345;
    sv=1218;
    related_method=name;
    category=KLEVU_PRODUCT;
    resultForZero=1;
 */
class LetsSyncroLLC_Oct8ne_Helper_Search_Klevu extends LetsSyncroLLC_Oct8ne_Helper_Search_Base {

    const PRICE_PARAM_NAME = "price-param";

    public function getEngineName() {
        return "klevu";
    }

    public function isValidSearchCriteria($searchTerm) {
        if (is_null($searchTerm) || strlen($searchTerm) == 0) {
            return false;
        }
        return true;
    }

    public function search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, &$totalSearchResults, &$attrs_applied, &$attrs_available) {
        if (!$this->checkEngineParams()) {
            Mage::log("[Oct8ne] Invalid Klevu engine params");
            return array();
        }

        $this->log("Searching " . $searchTerm);
        $result = $this->executeKlevuSearchQuery($searchTerm, NULL, $searchOrder, $searchDir, $page, $pageSize, TRUE /* addFacets */);
        if (is_null($result)) {
            return array();
        }
        $totalSearchResults = $result["meta"]["totalResultsFound"];

        $productIds = $this->getProductIds($result);
        $this->log("Total {$totalSearchResults}, ids of this page: [" . implode(",", $productIds) . "]");
        //$productIds = array('906', '875', '874', '554', '553', '552', '551', '549', '399', '398');
        return $productIds;
    }

    public function getRelatedProductIds($product, $page, $pageSize) {
        if (!$this->checkEngineParams()) {
            Mage::log("[Oct8ne] Invalid Solr engine params");
            return array();
        }

        $pageSize = 30;
        $relatedMethod = strtolower($this->getEngineParam("related_method"));
        if (!$relatedMethod) {
            $relatedMethod = "name";
        }
        
        if ($relatedMethod == "self") {
            $result = array($product->getId());
            return $result;
        }
        
        $result = NULL;
        
        if ($relatedMethod == "name") {
            $name = $product->getName();
            $result = $this->executeKlevuSearchQuery($name, NULL, 'score', 'desc', $page, $pageSize, FALSE /* addFacets */);
        }

        if (is_null($result) || !$result || count($result) == 0) {
            $result = array($product->getId());
        }

        $productIds = $this->getProductIds($result);

        return $productIds;
    }

    private function executeKlevuSearchQuery($searchTerm, $searchCategories, $searchOrder, $searchDir, $page, $pageSize, $addFacets) {
        if (!function_exists('curl_init')) {
            return NULL;
        }
        $host = $this->normalizeHost($this->getEngineParam("host"));
        if ($page < 1) {
            $page = 1;
        }
        $queryParams = array(
            'ticket' => $this->getEngineParam("ticket"),
            'sv' => $this->getEngineParam("sv"),
            'paginationStartsFrom' => ($page - 1),
            'noOfResults' => $pageSize ,
            'responseType' => 'json',
            'klevuSort'=> 'rel',
            'category'=> $this->getEngineParam("category"),
            'resultForZero'=>$this->getEngineParam("resultForZero")
        );

        
        
        $selectMethod = "/cloud-search/n-search/idsearch";

        $query = $host.$selectMethod.'?' . http_build_query($queryParams);

        // Set up query expression
        
        $searchTerm = trim($searchTerm);
        if ($searchTerm) {
            $q .= $searchTerm;
        }
        $q = str_replace(" ", "%20", $q);
        $query .= "&term=" . $q;

        // Set up facets
        
        
        $this->log("Executing query: {$query}");

        /* Uncomment to debug
            if($searchCriteria) {
                echo "<b>Search criteria:</b><br>" . $searchCriteria . "<br>";
            }
            echo "<b>Complete criteria:</b><br>" . $q . "<br>";
            echo "<b>Query:</b><br>" . $query . "<br>";
            return;
        */

        $request = curl_init($query);
        
        
            curl_setopt($request, CURLOPT_GET, 1);
        
        curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);

        
        
        $response = curl_exec($request);       
        $err = curl_error($request);        
        if (is_null($err) || $err == "") {
            $result = json_decode($response, true);
            if (is_null($result)) {
                $contentType = curl_getinfo($request, CURLINFO_CONTENT_TYPE);
                $msg = "Solr search is not returning valid JSON data, or result is empty. Content-type returned: " . $contentType;
                Mage::log("[Oct8ne] " . $msg);
                $this->log($msg);
            } else {
                $this->log("Query result received");
            }
        } else {
            $this->log("Search error: " . $err);
            $result = NULL;
        }
        curl_close($request);
        return $result;
    }
    
    
    
    private function getProductIds($result) {
        $productIds = array();
        $idField = "itemGroupId";
        if (!$result || !isset($result['result']))
            return $productIds;

        foreach ($result['result'] as $product) {
            if (!$product["itemGroupId"]){
                $productIds[] = $product["id"];
            }
            else{
                $productIds[] = $product["itemGroupId"];
            }
        }

        // Uncomment for local testing
        // $productIds = array('906', '875', '874', '554', '553', '552', '551', '549', '399', '398');

        return $productIds;
    }

    private function normalizeHost($host) {
        $host = rtrim($host, '/');
        if (!$this->startsWith($host, 'http://') && !$this->startsWith($host, 'https://')) {
            $host = 'http://' . $host;
        }
        return $host;
    }

    private function startsWith($str, $subStr) {
        $length = strlen($subStr);
        return (substr($str, 0, $length) === $subStr);
    }

    
    private function checkEngineParams() {
        $valid = $this->check("host");
        $valid = $valid && $this->check("ticket");
        $valid = $valid && $this->check("sv");
        return $valid;
    }

    private function check($paramName) {
        if (!$this->getEngineParam($paramName)) {
            $this->log("Error: param $paramName is not defined");
            return FALSE;
        }
        return TRUE;
    }

     private function getKlevuSort($searchOrder, $searchDir) {
        $result = "";
        switch ($searchOrder) {
            case "score":
                $result .= "rel";
                break;
            case "relevance":                
                $result .= "rel";         
                break;
            case "price":
                if($searchDir == "desc"){
                    $result .= "lth";
                }else{
                    $result .= "htl";
                }
                break;
            case "name":
                $result .= "rel"; 
                break;
        }
        
        return $result;
    }
    
    

}
