<?php

class LetsSyncroLLC_Oct8ne_Helper_Search_Magento extends LetsSyncroLLC_Oct8ne_Helper_Search_Base {

    public function getEngineName() {
        return "magento";
    }

    public function isValidSearchCriteria($searchTerm) {
        $this->getRequest()->setParam('q', $searchTerm);
        if (is_null($searchTerm) || strlen($searchTerm) == 0) {
            return false;
        }
        $helper = Mage::helper("catalogsearch"); /* @var $helper Mage_CatalogSearch_Helper_Data */
        $len = strlen($searchTerm);
        if ($len < $helper->getMinQueryLength() || $len > $helper->getMaxQueryLength()) {
            return false;
        }
        return true;
    }

    public function search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, &$totalSearchResults, &$attrs_applied, &$attrs_available) {
        parent::log("Searching " . $searchTerm);
        $this->getRequest()->setParam('q', $searchTerm);
        $products = $this->getFilteredProducts($storeId, $attrs_applied, $attrs_available);
        $totalSearchResults = $products->getSize();

        $products->setOrder($searchOrder, $searchDir);
        $products->setPageSize($pageSize)
                ->setCurPage($page);

        $result = array();
        foreach ($products as $product) {
            $result[] = $product->getId();
        }

        return $result;
    }

    private function getFilteredProducts($storeId, &$attrs_applied, &$attrs_available) {
        $request = $this->getRequest();
        $query = Mage::helper('catalogsearch')->getQuery();
        $query->setStoreId($storeId);
        if ($query->getId()) {
            $query->setPopularity($query->getPopularity() + 1);
        } else {
            $query->setPopularity(1);
        }
        $query->prepare();
        Mage::helper('catalogsearch')->checkNotes();

        $query = Mage::getModel('catalogsearch/layer');

        $filterableAttributes = $query->getFilterableAttributes();
        $attrs = array();

        if (!empty($filterableAttributes)) {
            $tmp = new Mage_Catalog_Model_Resource_Eav_Attribute();
            $tmp->SetAttributeCode('category');
            $tmp->setFrontendLabel('Category');
            if (is_array($filterableAttributes)) {
                $filterableAttributes[] = $tmp;
            } elseif (is_object($filterableAttributes) && method_exists($filterableAttributes, 'addItem')) {
                $filterableAttributes->addItem($tmp);
            }
        }

        foreach ($filterableAttributes as $attribute) {
            $code = $attribute->getAttributeCode();
            $name = $attribute->getFrontendLabel();

            // INIT
            $items = array();
            switch ($code) {
                case 'price':
                    $_filterModelName = "catalog/layer_filter_price";
                    break;
                case 'decimal':
                    $_filterModelName = "catalog/layer_filter_decimal";
                    break;
                case 'category':
                    $_filterModelName = "catalog/layer_filter_category";
                    break;
                default:
                    $_filterModelName = "catalog/layer_filter_attribute";
                    break;
            }

            $filter = Mage::getModel($_filterModelName)
                    ->setLayer($query)
                    ->setAttributeModel($attribute);
            $filter->apply($request, $this);
            $items = $filter->getItems();

            // En los filtros aplicados no nos viene el nombre, solo el id, lo obtenemos aqui
            $optionId = $request->getParam($filter->getRequestVar());
            $featurename = "";
            if (!is_null($optionId)) {
                switch ($code) {
                    case 'price':
                        $featurename = $request->get($code);
                        break;
                    case 'decimal':
                        $featurename = $request->get($code);
                        break;
                    case 'category':
                        $featurename = $filter->getCategory()->getName();
                        break;
                    default:
                        $featurename = $filter->getAttributeModel()->getFrontend()->getOption($optionId);
                        break;
                }
            }

            $options = array();
            foreach ($items as $item) {
                if ($item->getCount() > 0) {
                    $options[] = $this->createFilterOption($item->getLabel(), $item->getValue(), $item->getCount());
                }
            }
            $value = $request->getParam($code);
            $attrs[] = $this->createFilterInfo($code, $name, $options, $featurename, $value);
        }

        foreach ($attrs as $attr) {
            if (!is_null($request->getParam($attr['param']))) {
                $attrs_applied[] = $attr;
            } else {
                $attrs_available[] = $attr;
            }
        }

        $result_collection = $query->getProductCollection();
        return $result_collection;
    }

    public function getRelatedProductIds($product, $page, $pageSize) {

        $productId = $product->getId();
        $categoryIds = $product->getCategoryIds();
        if (empty($categoryIds)) {
            return array();
        }

        $collection = mage::getModel('catalog/product')->getCollection()
                ->addAttributeToSelect('id')
                ->addAttributeToFilter('visibility', 4)
                ->addAttributeToFilter('status', array('eq' => Mage_Catalog_Model_Product_Status::STATUS_ENABLED))
                ->addAttributeToFilter('entity_id', array('neq' => $productId))
                ->addAttributeToSort('price', 'asc');

        Mage::getSingleton('catalog/product_status')->addSaleableFilterToCollection($collection);

        $collection->joinField('category_id', 'catalog/category_product', 'category_id', 'product_id=entity_id', null, 'left')
                ->addAttributeToFilter('category_id', array('in' => $categoryIds));

        $collection->getSelect()->group('e.entity_id');
        $collection->setPageSize($pageSize)
                ->setCurPage($page);

        $relatedProductIds = array();
        foreach ($collection as $relatedProduct) {
            $relatedProductIds[] = $relatedProduct->getId();
        }
        return $relatedProductIds;
    }

}
