<?php

class LetsSyncroLLC_Oct8ne_Helper_Url extends Mage_Core_Helper_Url {

    public function getOct8neStaticUrl() {
        $hostName = Mage::registry('oct8neStaticUrl');
        if (!$hostName) {
            $hostName = "static.oct8ne.com";
        }
        return $hostName;
    }

    public function getOct8neHostName() {
        $hostName = Mage::registry('oct8neHostName');
        return $hostName; // NULL defaults to 'backoffice.oct8ne.com'
    }

    public function getOct8neSignupUrl() {
        $signupUrl = Mage::registry('oct8neSignupUrl');
        if (!$signupUrl) {
            $signupUrl = "http://www.oct8ne.com";
        }
        return $signupUrl;
    }

    public function getOct8neLinkupServiceUrl() {
        $linkupUrl = Mage::registry('oct8neLinkupServiceUrl');
        if (!$linkupUrl) {
            $linkupUrl = "https://backoffice.oct8ne.com/platformConnection/linkup";
        }
        return $linkupUrl;
    }

    public function getAdd2CartUrl($product, $additional = array()) {

        // .: Checkout/Helper/Cart.php::getAddUrl :. \\
        $route_params = array(
            'product' => $product->getEntityId()
        );

        if (!empty($additional))
            $route_params = array_merge($route_params, $additional);

        if ($product->hasUrlDataObject()) {
            $route_params['_store'] = $product->getUrlDataObject()->getStoreId();
            $route_params['_store_to_url'] = true;
        }


        return $this->_remove_http(
                        $this->_getUrl('oct8ne/frame/add2cart', $route_params)
        );
    }

    protected function _remove_http($str) {
        return preg_replace('#^https?:#', '', $str);
    }

}
