<?php

class LetsSyncroLLC_Oct8ne_Helper_wishlist extends Mage_Core_Helper_Abstract {

    public function addToWishlist($productId) {
        $wishList = $this->getCurrentCustomerWishlist();
        if ($wishList == null) {
            return false;
        }

        $buyRequest = new Varien_Object(array(
            'storeId' => Mage::app()->getStore()->getId()
        ));
        $product = Mage::getModel('catalog/product')->load($productId);

        $wishList->addNewItem($product, $buyRequest);
        $wishList->save();
        return true;
    }

    public function getWishlist() {
        $wishList = $this->getCurrentCustomerWishlist();
        if ($wishList == null) {
            return array();
        }
        $result = array();
        $wishListItemCollection = $wishList->getItemCollection();
        $dataHelper = Mage::helper("oct8ne"); /* @var $dataHelper LetsSyncroLLC_Oct8ne_Helper_Data */
        $productsNotLoaded = false;

        // First, try to use the preloaded products
        foreach ($wishListItemCollection as $item) {
            if (!$item->product) {
                $productsNotLoaded = true; // If the products are not loaded, let's try another approach
                break;
            }
            $result[] = $dataHelper->createProductSummaryFromProduct($item->product);
        }
        
        if ($productsNotLoaded) {  // The wishlist was returned without product details, so we must load them manually
            $productIds = array();
            foreach ($wishListItemCollection as $item) {
                $productIds[] = $item->getProductId();
            }
            $result = $dataHelper->getProductsSummaryByIds($productIds);
        }

        return $result;
    }

    public function removeFromWishlist($productId) {
        $wishList = $this->getCurrentCustomerWishlist();
        if ($wishList == null) {
            return false;
        }

        $found = false;
        $wishListItemCollection = $wishList->getItemCollection();

        foreach ($wishListItemCollection as $item) {
            if ($item->getProductId() == $productId) {
                $item->delete();
                $found = true;
                break;
            }
        }
        if ($found) {
            $wishList->save();
        }
        return $found;
    }

    private function getCurrentCustomerWishlist() {
        if (!Mage::getSingleton('customer/session')->isLoggedIn()) {
            return null;
        }
        $customer = Mage::getSingleton('customer/session')->getCustomer();
        $wishList = Mage::getSingleton('wishlist/wishlist')->loadByCustomer($customer, true /* create if needed */);
        return $wishList;
    }

}
