<?php

class LetsSyncroLLC_Oct8ne_Model_Observer {

    public function interceptMethod($observer) {
        $request = $observer->getEvent()->getData('front')->getRequest();

        if (isset($request->oct8ne)) {
            $theme = Mage::getStoreConfig('design/oct8nedesign/theme');

            if ($request->oct8ne != 'defaultpackage') {
                $package = Mage::getStoreConfig('design/oct8nedesign/package');
                if (empty($package)) {
                    $package = "default";
                }
            } else {
                Mage::register('oct8ne_defaultpackage', 1);
            }

            if (empty($theme)) {
                $theme = "oct8ne";
            }

            Mage::getDesign()->setPackageName($package);
            Mage::getDesign()->setTheme($theme);
            Mage::register('oct8ne', 1);
        }

        if (strpos($request->getPathInfo(), '/oct8ne/frame') !== FALSE) {
            Mage::register('oct8ne_rewrite', 1); // lo usamos para deshabilitar el redirect
        }
    }

    // Observer for event "sales_quote_save_after"
    public function cartUpdated($observer) {

        // Return if oct8ne is not involved in this cart or if we have just placed an order
        $sessionId = Mage::getModel('core/cookie')->get('oct8ne-session');
        if (is_null($sessionId) || !$sessionId || trim($sessionId) == '' || Mage::registry("oct8ne_sale") == '1') {
            return;
        }
        // Return if no quote is present
        $currentQuote = $observer->getEvent()->getQuote();
        if (is_null($currentQuote)) {
            return;
        }

        // Create or update an oct8ne order record 
        $this->updateOrderModel($sessionId, $currentQuote);
    }

    // Observer for event "sales_order_place_after"
    public function orderSaved($observer) {

        // Return if oct8ne was not involved in this sale
        $sessionId = Mage::getModel('core/cookie')->get('oct8ne-session');
        if (is_null($sessionId) || !$sessionId || trim($sessionId) == '') {
            return;
        }
        // Return if no order or quote is present        
        $currentOrder = $observer->getEvent()->getOrder();
        if (is_null($currentOrder)) {
            return;
        }
        $currentQuote = $currentOrder->quote;
        if (is_null($currentQuote)) {
            return;
        }

        // Create or update an oct8ne order record 
        $this->updateOrderModel($sessionId, $currentQuote, $currentOrder);

        // Next, Magento will call cartUpdated() function,
        // so we setup a sentinel to avoid the cart to be saved again
        
        if(!Mage::registry("oct8ne_sale") ){
            Mage::register("oct8ne_sale", "1");
        }

    }

    private function updateOrderModel($sessionId, $currentQuote, $currentOrder = NULL) {

        $quoteId = $currentQuote->getId();
        $oct8neOrder = Mage::getModel('oct8ne/order')->load($quoteId);

        if (!$oct8neOrder->getQuoteId()) {
            $oct8neOrder = Mage::getModel('oct8ne/order');
            $oct8neOrder->setQuoteId($quoteId);            
            $storeId = $currentQuote->getStoreId();
            $oct8neOrder->setStoreId($storeId);
            $oct8neOrder->setUtcCreated(gmdate('Y-m-d H:i:s'));
            $oct8neOrder->setLastAction('C');
        } else {
            $oct8neOrder->setLastAction('U');
        }

        // Set only updated fields
        if (!$currentOrder && $oct8neOrder->getOrderId()) {
            $oct8neOrder->setOrderId(NULL); // The checkout failed, so we should clear the orderId
        }

        if ($currentOrder && $oct8neOrder->getOrderId() != $currentOrder->getId()) {
            $oct8neOrder->setOrderId($currentOrder->getId()); // The checkout succeed
        }

        if ($oct8neOrder->getCustomerId() != $currentQuote->getCustomerId()) {
            $oct8neOrder->setCustomerId($currentQuote->getCustomerId());
        }

        if ($oct8neOrder->getItemsCount() != $currentQuote->getItemsQty()) {
            $oct8neOrder->setItemsCount($currentQuote->getItemsQty());
        }

        if ($oct8neOrder->getProductsCount() != $currentQuote->getItemsCount()) {
            $oct8neOrder->setProductsCount($currentQuote->getItemsCount());
        }
        if ($oct8neOrder->getPrice() != $currentQuote->getSubtotal()) {
            $oct8neOrder->setPrice($currentQuote->getSubtotal());
        }

        if ($oct8neOrder->getFinalPrice() != $currentQuote->getGrandTotal()) {
            $oct8neOrder->setFinalPrice($currentQuote->getGrandTotal());
        }

        if ($oct8neOrder->getCurrency() != $currentQuote->getQuoteCurrencyCode()) {
            $oct8neOrder->setCurrency($currentQuote->getQuoteCurrencyCode());
        }
        
        if ($oct8neOrder->getSessionId() != $sessionId) {
            $oct8neOrder->setSessionId($sessionId);
        }

        // Finally, if some fields have changed, save the record
        if ($oct8neOrder->hasDataChanges()) {
            $oct8neOrder->setUtcLastModified(gmdate('Y-m-d H:i:s'));
            $oct8neOrder->save();
        }
    }

    // Invoked when an anonymous customer has added some products to the cart, and 
    // then log in as user of the platform. If he had products stored in the cart,
    // both carts are merged.
    public function cartMerged($observer) {

        // Return if oct8ne is not involved in this session
        $sessionId = Mage::getModel('core/cookie')->get('oct8ne-session');
        if (is_null($sessionId) || !$sessionId || trim($sessionId) == '') {
            return;
        }

        $session = Mage::getSingleton('checkout/session');
        $quoteId = $session->getQuoteId();
        if (!$quoteId) {
            return;
        }

        $model = Mage::getModel('oct8ne/order');
        $quote = $model->load($quoteId);
        try {
            // We must mark the old quote as deleted because 
            // it was created by the anonymous user and we don't need it anymore
            if ($quote->getQuoteId()) {
                $quote->setLastAction('D');
                $quote->setUtcLastModified(gmdate('Y-m-d H:i:s'));
                $quote->save();
            }
            
            // And then save the new quote (merged)
            $event = $observer->getEvent();
            $prevQuote = $event->getQuote();
            $this->updateOrderModel($sessionId, $prevQuote);
            
        } catch (Exception $e) {
            // Nothing to do
        }
    }

    public function checkDomainPolicyHeader($observer) {
        if (Mage::registry('oct8ne') === 1 || Mage::registry('oct8ne_rewrite') === 1) {
            $action = $observer->getControllerAction();

            $response = $action->getResponse();
            $response->setHeader('X-Frame-Options', null, true);
        }
        return $this;
    }

    public function updatedCartOct($observer) {
        $cookieName = "oct8ne-visitor";
        if (!isset($_COOKIE[$cookieName])) {
            return;
        }

        $oct8neHostName = Mage::helper("oct8ne/url")->getOct8neHostName();
        $oct8ne_url = $oct8neHostName . "/PlatformConnection/update";
        $visitor = $_COOKIE[$cookieName];

        if ($visitor != null) {
            if (function_exists('curl_init') == 1) {
                $ch = curl_init($oct8ne_url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, 'what=cart&visitor=' . $visitor);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($ch);
                curl_close($ch);
            }
        }
    }

    /**
     * Get checkout session model instance
     *
     * @return Mage_Checkout_Model_Session
     */
    protected function _getSession() {
        return Mage::getSingleton('checkout/session');
    }

}
