<?php
require_once(Mage::getModuleDir('controllers','Mage_Customer').DS.'AccountController.php');
class LetsSyncroLLC_Oct8ne_AccountController extends Mage_Customer_AccountController
{
    /**
     * Define target URL and redirect customer after logging in
     */
    protected function _loginPostRedirect()
    {
        if(!is_null(Mage::registry('oct8ne')))
        {
            if(Mage::getSingleton('customer/session')->isLoggedIn())
            {
?>                
                <h2 class="add2cart-msg">Logged in</h2>

                <script type="text/javascript">
                    parent.postMessage("loginOK", "*");
                </script>
<?php
                return;
            } else {
?>                
                <h2 class="add2cart-msg">Login failed</h2>

                <script type="text/javascript">
                    parent.postMessage("loginFAIL", "*");
                </script>
<?php
                return;
            }
            
            $this->loadLayout();
            $this->renderLayout();
        }
        else
        {
            if(Mage::getSingleton('customer/session')->isLoggedIn()) {
                
                $session = Mage::getSingleton('core/session');
                $customerData = Mage::getSingleton('customer/session')->getCustomer();
                $url = $session->getBeforeAuthUrl();
                $session->setData("notify_oct8ne",  $customerData->getId());
             }
            parent::_loginPostRedirect();
        }
    }
	
	/**
     * Add welcome message and send new account email.
     * Returns success URL
     *
     * @param Mage_Customer_Model_Customer $customer
     * @param bool $isJustConfirmed
     * @return string
     */
    protected function _welcomeCustomer(Mage_Customer_Model_Customer $customer, $isJustConfirmed = false)
    {
        if(!is_null(Mage::registry('oct8ne')))
        {
            /*
            // die("login!!!");
            
            */
            if(Mage::getSingleton('customer/session')->isLoggedIn())
            {
?>                
<h2 class="add2cart-msg">Logged in</h2>

<script type="text/javascript">
    parent.postMessage("loginOK", "*");
</script>
<?php
            return;
            }
            
        }
        else
        {
            if(Mage::getSingleton('customer/session')->isLoggedIn()) {
                
                $session = Mage::getSingleton('core/session');
                $customerData = Mage::getSingleton('customer/session')->getCustomer();
                $url = $session->getBeforeAuthUrl();
                    $session->setData("notify_oct8ne",  $customerData->getId());
             }
        }
        
        return parent::_welcomeCustomer($customer, $isJustConfirmed); 
    }
    
    /**
     * Logout success page
     */
    public function logoutSuccessAction()
    {
        $session = Mage::getSingleton('core/session');
        $session->setData("notify_oct8ne_logout",  TRUE);
        parent::logoutSuccessAction();
    }
}
