<?php

// Uncomment these lines to show error 500 descriptions
// Mage::setIsDeveloperMode(true);
// ini_set('display_errors', 1);

class LetsSyncroLLC_Oct8ne_FrameController extends Mage_Core_Controller_Front_Action {

    public function getOrderDetailsAction()
    {
        // Obtener parámetros
        $reference = $this->getRequest()->getParam('reference');
        $token = $this->getRequest()->getParam('apiToken');
        $locale = $this->getRequest()->getParam('locale', Mage::app()->getLocale()->getLocaleCode());
        $currencyCode = $this->getRequest()->getParam('currency', Mage::app()->getStore()->getCurrentCurrencyCode());

        // Token esperado desde configuración
        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $expectedToken = $letssyncromodel->getApitoken();    
        if ($token !== $expectedToken) {
            return $this->returnJson(null);
        }

        // Cargar pedido por referencia (increment ID)
        $order = Mage::getModel('sales/order')->loadByIncrementId($reference);
        if (!$order || !$order->getId()) {
            return $this->returnJson(null);
        }

        // Obtener productos
        $products = [];
        foreach ($order->getAllVisibleItems() as $item) {
            $products[] = [
                'quantity' => (int)$item->getQtyOrdered(),
                'name' => $item->getName()
            ];
        }

        // Obtener comentarios del pedido
        $comments = [];
        $history = $order->getStatusHistoryCollection();
        foreach ($history as $comment) {
            if (!$comment->getComment()) continue;
            $comments[] = [
                'message' => $comment->getComment(),
                'customer' => (bool)$comment->getIsCustomerNotified()
            ];
        }

        // Preparar respuesta
        $response = [
            'date' => $order->getCreatedAt(),
            'reference' => $order->getIncrementId(),
            'total' => Mage::helper('core')->currency($order->getGrandTotal(), true, false),
            'currency' => $currencyCode,
            'labelState' => Mage::helper('sales')->__($order->getStatusLabel()),
            'deliveryDate' => '', // No disponible por defecto
            'carrier' => $order->getShippingDescription(),
            'trackingNumber' => '',
            'trackingUrl' => '',
            'products' => $products,
            'comments' => $comments
        ];

        // Intentar obtener tracking info
        $tracks = $order->getTracksCollection();
        foreach ($tracks as $track) {
            $response['trackingNumber'] = $track->getTrackNumber();
            $response['trackingUrl'] = $track->getUrl() ?: '';
            break; // solo el primero
        }

        return $this->returnJson($response);
    }

    public function getOrdersAction()
    {
        // Obtener parámetros
        $email = $this->getRequest()->getParam('customerEmail');
        $token = $this->getRequest()->getParam('apiToken');
        $page = (int) $this->getRequest()->getParam('page', 1);
        $pageSize = (int) $this->getRequest()->getParam('pageSize', 10);
        $locale = $this->getRequest()->getParam('locale', Mage::app()->getLocale()->getLocaleCode());
        $currencyCode = $this->getRequest()->getParam('currency', Mage::app()->getStore()->getCurrentCurrencyCode());

        // Token esperado desde la configuración
        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $expectedToken = $letssyncromodel->getApitoken();   
        if ($token !== $expectedToken) {
            return $this->returnJson([]);
        }

        // Buscar cliente por email
        $customer = Mage::getModel('customer/customer')
            ->setWebsiteId(Mage::app()->getWebsite()->getId())
            ->loadByEmail($email);


        if (!$customer || !$customer->getId()) {
            return $this->returnJson([]);
        }

        // Obtener pedidos del cliente
        $orders = Mage::getModel('sales/order')->getCollection()
            ->addFieldToFilter('customer_id', $customer->getId())
            ->setPageSize($pageSize)
            ->setCurPage($page)
            ->setOrder('created_at', 'desc');

        $response = [];
        foreach ($orders as $order) {
            $response[] = [
                'date' => $order->getCreatedAt(),
                'reference' => $order->getIncrementId(),
                'total' => Mage::helper('core')->currency($order->getGrandTotal(), true, false),
                'currency' => $currencyCode,
                'labelState' => Mage::helper('sales')->__($order->getStatusLabel()),
                'deliveryDate' => '' // No disponible por defecto
            ];
        }

        return $this->returnJson($response);
    }

    public function customerDataAction() {
        $this->setEnvironment();
        $customerDataHelper = Mage::helper('oct8ne/customerData');
        $login_data = $customerDataHelper->getLoginData();
        $wishlist_data = $customerDataHelper->getWishlistData();
        $cart = $customerDataHelper->getCartData();

        $results = array(
            'id' => $login_data['id'],
            'firstName' => $login_data['first_name'],
            'lastName' => $login_data['last_name'],
            'email' => $login_data['email'],
            'wishlist' => $wishlist_data,
            'cart' => $cart
        );
        $this->returnJson($results);
    }

    public function getAdapterInfoAction() {
        $this->setEnvironment();
        $model = Mage::getModel('oct8ne/letssyncro')->load(1);
        $enabled = $model ? $model->getEnabled() : FALSE;

        $versionHelper = Mage::helper("oct8ne/version");
        $apiVersion = $versionHelper->getApiVersion();
        $adapterVersion = $versionHelper->getAdapterVersion();

        $results = array(
            "platform" => "Magento",
            "adapterName" => "Oct8ne official adapter for Magento",
            "adapterVersion" => $adapterVersion,
            "developedBy" => "Oct8ne Inc",
            "supportUrl" => "http://www.oct8ne.com/support/magento",
            "apiVersion" => $apiVersion,
            "enabled" => $enabled ? 'true' : 'false'
        );

        $this->returnJson($results);
    }

    public function searchAction() {
        $this->setEnvironment();

        $profiler = Mage::helper('oct8ne/debug'); /* @var $profiler LetsSyncroLLC_Oct8ne_Helper_Debug */
        $actionStart = $profiler->startProfile("[FrameController] Starting search action");

        $storeId = $this->getRequest()->getParam('store', null);
        $currency = $this->getRequest()->getParam('currency', null);
        $searchTerm = $this->getRequest()->getParam('search', null);
        $searchOrder = $this->getRequest()->getParam('orderby', 'relevance');
        $searchDir = $this->getRequest()->getParam('dir', 'asc');
        $page = $this->getRequest()->getParam("page", 1);
        if ($page < 1) {
            $page = 1;
        }
        $pageSize = $this->getRequest()->getParam('pageSize', 10);

        if (is_null($storeId)) {
            $storeId = Mage::app()->getStore()->getId();
            $initialEnvironmentInfo = null;
        } else {
            $appEmulation = Mage::getSingleton('core/app_emulation');
            // Start environment emulation of the specified store
            $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);
        }

        $currentCurrency = Mage::app()->getStore()->getCurrentCurrencyCode();
        if (!is_null($currency)) {
            Mage::app()->getStore()->setCurrentCurrencyCode($currency);
        }

        $searchEngineName = strtolower(Mage::getStoreConfig('oct8neSearch/searchEngine/engine'));
        if ($searchEngineName == '') {
            $searchEngineName = 'Magento';
        }
        $searchEngine = Mage::Helper('oct8ne/search_' . $searchEngineName); /* @var $searchEngine LetsSyncroLLC_Oct8ne_Helper_Search_Base */

        if (!$searchEngine->isValidSearchCriteria($searchTerm)) {
            Mage::app()->getStore()->setCurrentCurrencyCode($currentCurrency);
            $results = array(
                'total' => 0,
                'results' => array(),
                'filters' => array(
                    'applied' => array(),
                    'available' => array()
                )
            );
            $this->returnJson($results);
            return;
        }

        $total_search_results = 0;
        $attrs_applied = array();
        $attrs_available = array();

        $productIds = $searchEngine->search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, $total_search_results, $attrs_applied, $attrs_available);


        $productInfos = Mage::helper('oct8ne')->getProductsSummaryByIds($productIds);

        $results = array(
            'total' => $total_search_results,
            'results' => $productInfos,
            'filters' => array(
                'applied' => $attrs_applied,
                'available' => $attrs_available
            )
        );

        if (!is_null($initialEnvironmentInfo)) {
            //Stop environment emulation and restore original store
            $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        }

        Mage::app()->getStore()->setCurrentCurrencyCode($currentCurrency);

        $profiler->endProfile($actionStart, "[FrameController] Ending search action");
        $this->returnJson($results);
    }

    public function getCartAction() {
        // $this->setEnvironment();
        $helper = Mage::helper('oct8ne'); /* @var $helper LetsSyncroLLC_Oct8ne_Helper_Data */
        $result = $helper->getCart();
        $this->returnJson($result);
    }

    public function addToWishlistAction() {
        $this->setEnvironment();
        $productIds = $this->getRequest()->getParam('productIds', null);
        $result = false;
        if ($productIds) {
            $helper = Mage::helper('oct8ne/wishlist');
            $result = $helper->addToWishlist($productIds);
        }
        $results = array(
            'result' => $result
        );
        $this->returnJson($results);
    }

    public function removeFromWishlistAction() {
        $this->setEnvironment();
        $helper = Mage::helper('oct8ne/wishlist');
        $productId = $this->getRequest()->getParam('productId', null);
        $results = array(
            'result' => $productId ? $helper->removeFromWishlist($productId) : false
        );
        $this->returnJson($results);
    }

    public function getWishlistAction() {
        $this->setEnvironment();
        $result_collection = Mage::helper('oct8ne/wishlist')->getWishlist();
        $results = array(
            'total' => count($result_collection),
            'results' => $result_collection
        );
        $this->returnJson($results);
    }

    public function productInfoAction() {
        $this->setEnvironment();
        $profiler = Mage::helper('oct8ne/debug'); /* @var $profiler LetsSyncroLLC_Oct8ne_Helper_Debug */
        $actionStart = $profiler->startProfile("[FrameController] Starting ProductInfoAction");

        $products = $this->getRequest()->getParam('productIds', null);
        $product_Ids = explode(',', $products);
        if (count($product_Ids) > 0) {
            $helper = Mage::helper('oct8ne');
            $result = $helper->getProductsInfoByIds($product_Ids);
        } else {
            $result = array();
        }
        $profiler->endProfile($actionStart, "[FrameController] Ending ProductInfoAction");
        $this->returnJson($result);
    }

    public function productSummaryAction() {
        $this->setEnvironment();
        $profiler = Mage::helper('oct8ne/debug'); /* @var $profiler LetsSyncroLLC_Oct8ne_Helper_Debug */
        $actionStart = $profiler->startProfile("[FrameController] Starting ProductSummaryAction");
        $products = $this->getRequest()->getParam('productIds', null);
        $product_Ids = explode(',', $products);
        if (count($product_Ids) > 0) {
            $helper = Mage::helper('oct8ne'); /* @var $helper LetsSyncroLLC_Oct8ne_Helper_Data */
            $result = $helper->getProductsSummaryByIds($product_Ids);
        } else {
            $result = array();
        }
        $profiler->endProfile($actionStart, "[FrameController] Ending ProductSummaryAction");
        $this->returnJson($result);
    }

    public function productRelatedAction() {
        $this->setEnvironment();
        $product_id = $this->getRequest()->getParam('productId', null);
        $page = $this->getRequest()->getParam('page', 1);
        $pageSize = $this->getRequest()->getParam('pageSize', 10);
        $results = Mage::helper('oct8ne')->getRelatedProducts($product_id, $page, $pageSize);
        $this->returnJson($results);
    }

    public function imageAction() {
        $this->setEnvironment();
        $file = $this->getRequest()->getParam('file', null);
        if ($file == null) {
            $this->returnNoContent();
            return;
        }

        $imageHelper = self::getImageHelper(); /* @var $imageHelper LetsSyncroLLC_Oct8ne_Helper_Image_Default */
        $width = $this->getRequest()->getParam('width', null);
        if ($width == null) {
            $newFilePhysicalPath = $imageHelper->getImagePhysicalPath($file);
        } else {
            $resizedUrl = ltrim($imageHelper->resizeImg($file, $width), '/');
            $resizedUrl = substr($resizedUrl, strpos($resizedUrl, 'media') + 6);
            $path = Mage::getBaseDir(Mage_Core_Model_Store::URL_TYPE_MEDIA) . DS . $resizedUrl;
            $newFilePhysicalPath = $path;
        }
        $this->returnImage($newFilePhysicalPath);
    }

    public function getSalesReportAction() {
        $this->setEnvironment();
        if (!$this->checkApiToken()) {
            $this->returnNotAuthorized();
            return false;
        }
        $from = $this->getRequest()->getParam('from', null);
        $to = $this->getRequest()->getParam('to', null);
        if (!$from || !$to) {
            $this->returnBadRequest();
        }
        $helper = Mage::helper('oct8ne/reports'); /* @var $helper LetsSyncroLLC_Oct8ne_Helper_Reports */
        $result = $helper->getSales($from, $to);
        $this->returnJson($result);
    }

    // Deprecated in API 2.1    
    public function getReportDataAction() {
        $this->setEnvironment();
        if (!$this->checkApiToken()) {
            $this->returnNotAuthorized();
            return false;
        }

        $from = $this->getRequest()->getParam('from', null);
        $to = $this->getRequest()->getParam('to', null);
        $report = $this->getRequest()->getParam('report', null);

        $result_collection = Mage::getModel('oct8ne/' . $report . 'products')->getCollection();
        if (!empty($from))
            $result_collection->getSelect()->where("created_at >= CAST(? AS DATETIME)", $from);
        if (!empty($to))
            $result_collection->getSelect()->where("CAST(? AS DATETIME) > created_at", $to);

        $v = array();
        foreach ($result_collection as $i => $item) {
            $values = array(
                'productId' => $item['product_id'],
                'qty' => $item['qty'],
                'userId' => $item['customer_id'],
                'oct8neSession' => $item['oct8ne'],
                'productPrice' => $item['product_price'],
                'currency' => $item['currency'],
            );

            if ($report == 'order') {
                $order = Mage::getModel('sales/order')->load($item['order_id']);
                if ($order != null) {
                    $orderValid = 1;
                    $incrementId = $order->getIncrementId();
                    $status = $order->getStatus();
                } else {
                    $orderValid = 0;
                }
                $values += array(
                    'internalId' => $item['orderproducts_id'],
                    'orderId' => $item['order_id'],
                    'orderValid' => $orderValid,
                    'incrementId' => $incrementId,
                    'orderPrice' => $item[$report . '_price'],
                    'status' => $status
                );
            }
            $v[] = $values;
        }

        $results = array(
            'total' => $result_collection->getSize(),
            'results' => $v
        );
        $this->returnJson($results);
    }

    public function systemCheckAction() {
        $this->setEnvironment();
        $text = array();
        $text[] = get_class(Mage::getModel('core/url'));
        $text[] = get_class(Mage::getModel('core/url_rewrite'));
        $text[] = get_class(Mage::getModel('core/design_package'));
        $text[] = get_class(Mage::getModel('checkout/type_onepage'));
        $text[] = get_class($this->getLayout()->createBlock('catalog/product_view'));
        $text[] = get_class($this->getLayout()->createBlock('page/html_head'));

        $this->getResponse()->setHeader('Content-type', 'application/json; charset=UTF8', true);
        $this->getResponse()->setBody(implode("\n", $text));
    }

    private function checkApiToken() {
        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $token = $letssyncromodel->getApitoken();
        $apitoken = $this->getRequest()->getParam('apiToken', null);
        return ($apitoken == $token);
    }

    private function returnJson($jsonData) {
        $response = json_encode($jsonData);
        $callback = $this->getRequest()->getParam('callback', NULL);
        if ($callback) {
            $this->getResponse()->setHeader('Content-type', 'application/javascript; charset=utf-8', true);
            $response = $callback . "(" . $response . ");";
        } else {
            $this->getResponse()->setHeader('Content-type', 'application/json; charset=utf-8', true);
        }
        $this->getResponse()->setBody($response);
    }

    private function returnNotAuthorized() {
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('HTTP/1.0', '401', true);
    }

    private function returnBadRequest() {
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('HTTP/1.0', '400', true);
    }

    private function returnImage($physicalFilePath) {
        $response = $this->getResponse();
        $mime_types = $this->getMimeTypes();
        $path_parts = pathinfo($physicalFilePath);
        $mime = $mime_types[strtolower($path_parts['extension'])];

        $response->clearHeaders();
        $response->setHeader('Content-Type', $mime, true);
        $response->setHeader('Cache-Control', 'max-age: 300', true);
        $response->setHeader('Expires', gmdate('D, d M Y H:i:s \G\M\T', time() + 86400), true);
        $response->setHeader('Pragma', 'cache', true);
        $response->setHeader('Age', '0', true);
        $response->setBody(file_get_contents($physicalFilePath));
    }

    private function getMimeTypes() {
        return array(
            'png' => 'image/png',
            'jpe' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpg' => 'image/jpeg',
            'gif' => 'image/gif',
            'bmp' => 'image/bmp',
            'ico' => 'image/vnd.microsoft.icon',
            'tiff' => 'image/tiff',
            'tif' => 'image/tiff',
            'svg' => 'image/svg+xml',
            'svgz' => 'image/svg+xml',
        );
    }

//    
// For debugging purposes
// Usage: $this->returnContent($anyObject)
// 
    private function returnContent($object) {
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('Content-type', 'text/plain; charset=UTF8', true);
        print_r($object);
    }

    static private function getImageHelper() {
        $helperName = Mage::getStoreConfig('oct8neData/advancedDataConfig/imageHelperName');
        if (!$helperName) {
            $helperName = 'default';
        }
        $helperName = 'oct8ne/image_' . $helperName;
        return Mage::helper($helperName);
    }

    // Sets the current request environment (currency & locale)
    private function setEnvironment() {

        $app = Mage::app();
        $request = $this->getRequest();

        // Set currency, if nedded
        $currency = $request->getParam('currency', null);
        if ($currency) {
            $store = $app->getStore();
            $currentCurrency = $store->getCurrentCurrencyCode();
            if ($currency != $currentCurrency) {
                $store->setCurrentCurrencyCode($currency);
            }
        }

        // Set locale, if nedded
        $locale = $request->getParam("locale", null);
        if ($locale) {
            $locale = str_replace("-", "_", $locale);
            $currentLocale = $app->getLocale();
            if ($locale != $currentLocale->getLocaleCode() && Zend_Locale::isLocale($locale)) {
                $currentLocale->setLocale($locale);
            }
        }
    }

}
