<?php

class LetsSyncroLLC_Oct8ne_SetupController extends Mage_Core_Controller_Front_Action {
    
    public function indexAction() {
        if (!$this->isValidIp()) {
            $this->returnNotAuthorized();
            return false;
        }
        
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('Content-type', 'text/html; charset=UTF8', true);

        $html = "<html><body>
        <h2 style='color: orange'>Oct8ne</h2>
        <p>Welcome to oct8ne's setup utility!</p>
        <ul>
            <li><a href='" . Mage::getBaseUrl() . "oct8ne/setup/settings'>View or change Settings</a></li>
            <li><a href='" . Mage::getBaseUrl() . "oct8ne/setup/linkup'>View or change Linkup or Service status</a></li>
        </ul>
        </body></html>";

        $response->setBody($html);
    }
        
    public function settingsAction() {
        if (!$this->isValidIp()) {
            $this->returnNotAuthorized();
            return false;
        }

        $settings = "";
        $dataList = array();
        $this->addSetting($dataList, $settings, 'oct8neSearch/assistedSearch/elementSelector', "Search element selector", 'CSS selector. Example: "#search"');
        $this->addSetting($dataList, $settings, 'oct8neSearch/searchEngine/engine', "Search engine", 'Allowed: { "magento", "sli", "solr", "celebros", "searchspring", "doofinder", "klevu" }');
        $this->addSetting($dataList, $settings, 'oct8neSearch/searchEngine/params', "Search engine settings", '"Search engine specific settings"');
        $this->addSetting($dataList, $settings, 'oct8neData/productData/productDataDescription', "Comma-separated product description fallback fields or groups.", 'Example: "description,short_description,field1+field2"');
        $this->addSetting($dataList, $settings, 'oct8neData/productData/ignoreExcludedImages', "Ignore images marked as excluded", "1=true, 0=false");
        $this->addSetting($dataList, $settings, 'oct8neData/productData/returnActualProductImageUrl', "Use product's actual images instead of 'image' action", "1=true, 0=false");
        $this->addSetting($dataList, $settings, 'oct8neData/productData/actualProductImageWidth', "Product's actual images default width", "Example: '600' or empty for not resizing");
        $this->addSetting($dataList, $settings, 'oct8neData/productData/ignoreBackorders', "Oct8ne should ignore the backorders property to determine stock availability", "1=true, 0=false");
        $this->addSetting($dataList, $settings, 'oct8neData/advancedDataConfig/imageHelperName', "Image helper name", 'Example: "default" to use helper/images/default.php');
        $this->addSetting($dataList, $settings, 'oct8neData/advancedDataConfig/loadCompleteProductInfo', "Load complete product info", "1=true, 0=false");
        $this->addSetting($dataList, $settings, 'oct8neData/advancedDataConfig/imageGalleryPrefetch', "Prefetch image gallery", "1=true, 0=false");
        $this->addSetting($dataList, $settings, 'oct8neSite/siteUrls/checkoutSuccessPageUrl', "Checkout success page URL", "Example: \"checkout/onepage/success\"");
        $this->addSetting($dataList, $settings, 'oct8neSite/siteUrls/oct8neServerUrl', "Oct8ne Server", "Example: \"backoffice.oct8ne.com/\"");
        $this->addSetting($dataList, $settings, 'oct8neSite/siteUrls/oct8neStaticUrl', "Oct8ne Static Server", "Example: \"static.oct8ne.com/\"");

        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('Content-type', 'text/html; charset=UTF8', true);

        $html = "<html><body>
            <h2>Setup &gt; View/change settings</h2>
        ";
        if($this->getRequest()->getParam('done')) { 
            $html .= "<h3 style='color: blue'>Settings changed!</h3>";
         }
         $html .= "<datalist id='settings'>";
         foreach ($dataList as $item) { 
            $html .= "<option value='". $item . "' />";
         } 
         $html .= "</datalist>";
         $html .= "<table border=1 cellspacing=0 cellpadding=3><tr><th>Key</th><th>Current value</th><th>Description</th><th>Example/Allowed values</th></tr>";
         $html .= $settings;
         $html .= "</table>
        <hr><form method='post' action='setsettings'>
                Key: <input type='text' name='setting' id='setting' list='settings' size='50'>
                New value: <textarea name='value' id='value' style='vertical-align: top; margin-right: 10px'></textarea>
                <input type='hidden' name='apitoken' value='" . $this->getRequest()->getParam('apitoken', null) ."'>
                <input type='submit'>
            </form>
            <p><a href='../setup'>Back to menu</a></p>
            <script>
                function selectSetting(setting, value) {
                   document.getElementById('setting').value = setting;
                   document.getElementById('value').value = value;
                   location.href='#setting';
                }
            </script>
        </body>
        </html>";
        $response->setBody($html);
    }

    public function setSettingsAction() {
        if (!$this->isValidIp()) {
            $this->returnNotAuthorized();
            return false;
        }

        $setting = $this->getRequest()->getParam('setting');
        if (!$setting) {
            $this->returnBadRequest();
            return false;
        }
        $value = $this->getRequest()->getParam('value');

        $config = new Mage_Core_Model_Config();
        $config->saveConfig(trim($setting), trim($value), 'default', 0);
        
        // Mage::app()->cleanCache();
        Mage::getConfig()->reinit();
        
        $current = strtolower($_SERVER['REQUEST_URI']);
        $url = str_replace("setsettings", "settings?done=1", $current);
        $this->getResponse()->setRedirect($url);
    }
    
    public function linkupAction() {
       
        if (!$this->isValidIp()) {
            $this->returnNotAuthorized();
            return false;
        }
        
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('Content-type', 'text/html; charset=UTF8', true);
        
        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $apiToken = $letssyncromodel->getApitoken();
        $licenseId = $letssyncromodel->getLicenseid();
        $enabled = $letssyncromodel->getEnabled() == '1';
        ?>
        <html><body>
        <h2>Setup &gt; Linkup/Status</h2>
        <?php if($this->getRequest()->getParam('done')) { ?>
            <h3 style='color: blue'>Linkup/status settings changed!</h3>
        <?php } ?>
        <hr><form method='post' action='setLinkup'>
                API token: <input type='text' name='apiToken' value='<?php $apiToken ?>' required> <br />
                License ID: <input type='text' name='licenseId' value='<?php $licenseId ?>' required> <br />
                Enabled: <select name='enabled'>
                <?php if ($enabled) { ?>
                    <option value='0'>No</option>
                    <option value='1' selected>Yes</option>
                <?php } else { ?>
                    <option value='0' selected>No</option>
                    <option value='1'>Yes</option>
                <?php } ?>
                </select>
                <br /> <br />
                <input type='submit'>
                </form>
                <p><a href='../setup'>Back to menu</a></p>
            </body>
        </html>
<?php            
    }
    
    public function setLinkupAction() {
        if (!$this->isValidIp()) {
            $this->returnNotAuthorized();
            return false;
        }

        $request = $this->getRequest();
        $letssyncromodel = Mage::getModel('oct8ne/letssyncro')->load(1);
        $apiToken = $request->getParam('apiToken');
        $licenseId = $request->getParam('licenseId');
        $enabled = $request->getParam('enabled');
        
        $letssyncromodel->setApitoken($apiToken);
        $letssyncromodel->setLicenseid($licenseId);
        $letssyncromodel->setEnabled($enabled);
        
        $letssyncromodel->save();
        
        $current = strtolower($_SERVER['REQUEST_URI']);
        $url = str_replace("setlinkup", "linkup?done=1", $current);
        header("Location: " . $url);
        return;
    }

    private function addSetting(&$dataList, &$str, $setting, $title, $example = NULL) {
        $dataList[] = $setting;
        $result = Mage::getStoreConfig($setting);
        $actualResult = $result;
        if (is_null($result) || $result == "") {
            $result = "(not set)";
        }
        $str .= "<tr><td style='cursor: pointer;' onclick=\"selectSetting('{$setting}', '{$actualResult}')\">{$setting}</td><td>{$result}</td><td>{$title}</td><td>$example</td>";
        return $str;
    }
    
    private function isValidIp() {
        if($this->CheckIpFromHeader('REMOTE_ADDR')) {
            return true;
        }
        if($this->CheckIpFromHeader('HTTP_X_FORWARDED_FOR')) {
            return true;
        }        
        if($this->CheckIpFromHeader('HTTP_CLIENT_IP')) {
            return true;
        }
        if($this->CheckIpFromHeader('HTTP_X_FORWARDED')) {
            return true;
        }        
        if($this->CheckIpFromHeader('HTTP_X_CLUSTER_CLIENT_IP')) {
            return true;
        }        
        if($this->CheckIpFromHeader('HTTP_FORWARDED_FOR')) {
            return true;
        }        
        if($this->CheckIpFromHeader('HTTP_FORWARDED')) {
            return true;
        }        
        return false;
    }
    
    private function CheckIpFromHeader($header) {
        if(!isset($_SERVER[$header]))
            return FALSE;
        
        $ip = $_SERVER[$header];
        return $ip == '127.0.0.1' || $ip == '80.28.120.5' || $ip == '83.32.31.92' || $ip == '138.91.153.74' || $ip == '168.62.164.114' || $ip == '::1' || $ip == '52.174.192.174' || $ip == '40.115.11.160';        
    }

    private function returnBadRequest() {
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('HTTP/1.0', '400', true);
    }

    private function returnNotAuthorized() {
        $response = $this->getResponse();
        $response->clearHeaders();
        $response->setHeader('HTTP/1.0', '401', true);
    }
}
