<?php

$installer = $this;
$installer->startSetup();


// *******************************************
// Create and populate table letssyncro
// *******************************************

    $installer->run("
            DROP TABLE IF EXISTS {$this->getTable('letssyncro')};
            CREATE TABLE {$this->getTable('letssyncro')} (
               `letssyncro_id` int(5) NOT NULL auto_increment,
               `email` varchar(100) NULL,
               `password` varchar(100) NULL,
               `urlapi` varchar(100) NOT NULL,
               `licenseid` varchar(32) NULL,
               `apitoken` varchar(32) NULL,
               `enabled` varchar(1) NULL,
               PRIMARY KEY  (`letssyncro_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
         ");

    try {

        $linkupUrl = Mage::helper('oct8ne/url')->getOct8neLinkupServiceUrl();
        $installer->run("
                            INSERT INTO {$this->getTable('letssyncro')}
                            (`letssyncro_id`, `email`, `password`, `urlapi`, `licenseid`, `apitoken`, `enabled`) VALUES
                            (1, '', '', '{$linkupUrl}', '', '', '0');
                        ");
    } catch (\Exception $e) {
        // the insert may fail if we run it more than once (duplicate key)
        // we need this check to prevent errors during the rename of the module
    }

    
// *******************************************
// Create table orderproducts
// *******************************************
    
$installer->run("
    -- DROP TABLE IF EXISTS {$this->getTable('orderproducts')};
    CREATE TABLE IF NOT EXISTS {$this->getTable('orderproducts')} (
      `orderproducts_id` int(11) unsigned NOT NULL auto_increment,
      `order_id` int(11) unsigned NOT NULL,
      `product_id` int(11) unsigned NOT NULL,
      `oct8ne` varchar(128) NOT NULL default 'N',
      `currency` varchar(3) NOT NULL default 'EUR',
      `qty` int(11) unsigned NOT NULL,
      `customer_id` int(11) unsigned NOT NULL,
      `product_price` decimal(12,4) NOT NULL default '0.0000',
      `order_price` decimal(12,4) NOT NULL default '0.0000',
      `created_at` datetime NOT NULL default '0000-00-00 00:00:00',

      PRIMARY KEY (`orderproducts_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");

// *******************************************
// Create table quoteproducts
// *******************************************    
    
$installer->run(" 
    -- DROP TABLE IF EXISTS {$this->getTable('quoteproducts')};
    CREATE TABLE IF NOT EXISTS {$this->getTable('quoteproducts')} (
      `quoteproducts_id` int(11) unsigned NOT NULL auto_increment,
      `quote_id` int(11) unsigned NOT NULL,
      `product_id` int(11) unsigned NOT NULL,
      `product_price` decimal(12,4) NOT NULL default '0.0000',
      `quote_price` decimal(12,4) NOT NULL default '0.0000',
      `oct8ne` varchar(128),
      `qty` int(11) unsigned NOT NULL,
      `customer_id` int(11) unsigned NOT NULL,
      `created_at` datetime NOT NULL default '0000-00-00 00:00:00',
      `currency` varchar(3) NOT NULL default 'EUR',
      PRIMARY KEY (`quoteproducts_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");    
    

$installer->endSetup();
