<?php

$installer = $this;
$installer->startSetup();


// *******************************************
// Create and populate table letssyncro
// *******************************************

$installer->run("
            DROP TABLE IF EXISTS {$this->getTable('letssyncro')};
            CREATE TABLE {$this->getTable('letssyncro')} (
               `letssyncro_id` int(5) NOT NULL auto_increment,
               `email` varchar(100) NULL,
               `password` varchar(100) NULL,
               `urlapi` varchar(100) NOT NULL,
               `licenseid` varchar(32) NULL,
               `apitoken` varchar(32) NULL,
               `enabled` varchar(1) NULL,
               PRIMARY KEY  (`letssyncro_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
         ");

try {

    $linkupUrl = Mage::helper('oct8ne/url')->getOct8neLinkupServiceUrl();
    $installer->run("
                            INSERT INTO {$this->getTable('letssyncro')}
                            (`letssyncro_id`, `email`, `password`, `urlapi`, `licenseid`, `apitoken`, `enabled`) VALUES
                            (1, '', '', '{$linkupUrl}', '', '', '0');
                        ");
} catch (\Exception $e) {
    // the insert may fail if we run it more than once (duplicate key)
    // we need this check to prevent errors during the rename of the module
}

// ***************
// Drop old tables
// ***************
$installer->run("    
    DROP TABLE IF EXISTS {$this->getTable('orderproducts')}
");

$installer->run("    
    DROP TABLE IF EXISTS {$this->getTable('quoteproducts')}
");

// *******************************************
// Create table for orders and quotes
// *******************************************

$ordersTable = $this->getTable('letssyncro_orders');
$installer->run("    
    CREATE TABLE IF NOT EXISTS {$ordersTable} (
      `quote_id` int(11) unsigned NOT NULL,
      `order_id` int(11) unsigned,
      `store_id` int(11) unsigned NOT NULL,      
      `customer_id` int(11) unsigned,      
      `session_id` varchar(32) NOT NULL,
      `price` decimal(12,2) NOT NULL,
      `final_price` decimal (12,2) NOT NULL,
      `currency` varchar(3) NOT NULL default 'USD',
      `products_count` int(11) unsigned NOT NULL,
      `items_count` int(11) unsigned NOT NULL,
      `last_action` varchar(1) NOT NULL,
      `utc_created` datetime NOT NULL default '0000-00-00 00:00:00',
      `utc_last_modified` datetime NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY (`quote_id`),
      INDEX `{$ordersTable}_modified`(`utc_last_modified`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
);

$installer->endSetup();
