<?php

$installer = $this;
$installer->startSetup();

// ***************
// Drop old tables
// ***************
$installer->run("    
    DROP TABLE IF EXISTS {$this->getTable('orderproducts')}
");

$installer->run("    
    DROP TABLE IF EXISTS {$this->getTable('quoteproducts')}
");

// *******************************************
// Create tables for orders and quotes
// *******************************************

$ordersTable = $this->getTable('letssyncro_orders');
$installer->run("
    
    CREATE TABLE IF NOT EXISTS {$ordersTable} (
      `order_id` int(11) unsigned NOT NULL,
      `session_id` varchar(32) NOT NULL,
      `quote_id` int(11) unsigned NOT NULL,
      `store_id` int(11) unsigned NOT NULL,      
      `price` decimal(12,2) NOT NULL,
      `final_price` decimal (12,2) NOT NULL,
      `currency` varchar(3) NOT NULL default 'USD',
      `products_count` int(11) unsigned NOT NULL,
      `items_count` int(11) unsigned NOT NULL,
      `utc_created` datetime NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY (`order_id`),
      INDEX `{$ordersTable}_creation`(`utc_created`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
);

$quoteTable = $this->getTable('letssyncro_quotes');
$installer->run("
    CREATE TABLE IF NOT EXISTS {$quoteTable} (
      `quote_id` int(11) unsigned NOT NULL,
      `session_id` varchar(32) NOT NULL,
      `store_id` int(11) unsigned NOT NULL,
      `price` decimal(12,2) NOT NULL,
      `currency` varchar(3) NOT NULL default 'USD',
      `products_count` int(11) unsigned NOT NULL,
      `items_count` int(11) unsigned NOT NULL,
      `utc_created` datetime NOT NULL default '0000-00-00 00:00:00',
      `utc_last_modified` datetime NOT NULL default '0000-00-00 00:00:00',
      PRIMARY KEY (`quote_id`),
      INDEX `{$quoteTable}_modified`(`utc_last_modified`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");



$installer->endSetup();
