<?php

$installer = $this;

$installer->startSetup();

$installer->run("
ALTER TABLE {$this->getTable('orderproducts')}
    ADD `qty` int(11) unsigned NOT NULL,
    ADD `customer_id` int(11) unsigned NOT NULL,
    ADD `product_price` decimal(12,4) NOT NULL default '0.0000',
    ADD `order_price` decimal(12,4) NOT NULL default '0.0000',
    ADD `created_at` datetime NOT NULL default '0000-00-00 00:00:00',
    ADD `currency` varchar(3) NOT NULL default 'EUR',
    MODIFY `oct8ne` varchar(128)
");

$installer->run("
 
-- DROP TABLE IF EXISTS {$this->getTable('quoteproducts')};
CREATE TABLE IF NOT EXISTS {$this->getTable('quoteproducts')} (
  `quoteproducts_id` int(11) unsigned NOT NULL auto_increment,
  `quote_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `product_price` decimal(12,4) NOT NULL default '0.0000',
  `quote_price` decimal(12,4) NOT NULL default '0.0000',
  `oct8ne` varchar(128),
  `qty` int(11) unsigned NOT NULL,
  `customer_id` int(11) unsigned NOT NULL,
  `created_at` datetime NOT NULL default '0000-00-00 00:00:00',
  `currency` varchar(3) NOT NULL default 'EUR',
  PRIMARY KEY (`quoteproducts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

");

$installer->endSetup();
