<?php

/**
 * Login general
 */

namespace Oct8ne\Oct8ne\Block\Adminhtml\Login;

use \Oct8ne\Oct8ne\Helper\CheckCredentials;
use \Magento\Framework\View\Element\Template\Context;
use \Magento\Framework\Module\Manager;
use \Magento\Store\Api\StoreRepositoryInterface;

class Index extends \Magento\Framework\View\Element\Template
{
    /**
     * @var CheckCredentials
     */
    protected $_check;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var Manager
     */
    protected $_moduleManager;

    /**
     * @var StoreRepositoryInterface
     */
    protected $_store_repository;

    /**
     * Constructor
     *
     * @param Context $context
     * @param CheckCredentials $check
     * @param Manager $moduleManager
     * @param StoreRepositoryInterface $repository
     */
    public function __construct(
        Context $context,
        CheckCredentials $check,
        Manager $moduleManager,
        StoreRepositoryInterface $repository
    ) {
        parent::__construct($context);

        $this->_check = $check;
        $this->_scopeConfig = $context->getScopeConfig();
        $this->_context = $context;
        $this->_moduleManager = $moduleManager;
        $this->_store_repository = $repository;
    }

    /**
     * Obtiene la url a un controlador
     *
     * @return string
     */
    public function getFormAction()
    {
        return $this->getUrl('oct8ne/login/index');
    }

    /**
     * Comprueba si estas logeado o no
     *
     * @return bool
     */
    public function isLogged()
    {
        return $this->_check->isLogged();
    }

    /**
     * Get user email
     *
     * @return mixed
     */
    public function getEmail()
    {
        return $this->_scopeConfig->getValue("Oct8ne/user/email/0", "default", 0);
    }

    /**
     * Get search engine
     *
     * @return mixed
     */
    public function getSearchEngine()
    {
        return $this->_scopeConfig->getValue("Oct8ne/user/search_engine/0", "default", 0);
    }

    /**
     * Get search by
     *
     * @return mixed
     */
    public function getSearchBy()
    {
        return $this->_scopeConfig->getValue("Oct8ne/user/search_by/0", "default", 0);
    }
    
    /**
     * Get doofinder hash id
     *
     * @return mixed
     */
    public function getDoofinderHashId()
    {
        return $this->_scopeConfig->getValue("Oct8ne/doofinder/hashid/0", "default", 0);
    }

    /**
     * Get doofinder api key
     *
     * @return mixed
     */
    public function getDoofinderApiKey()
    {
        return $this->_scopeConfig->getValue("Oct8ne/doofinder/apikey/0", "default", 0);
    }

    /**
     * Posicion donde se carga el JS de magento
     *
     * @return mixed|string
     */
    public function getPositionToLoad()
    {
        $position =  $this->_scopeConfig->getValue("Oct8ne/user/position/0", "default", 0);

        if (!isset($position) || empty($position)) {
            return "Footer";
        }

        return $position;
    }

    /**
     * Additional script
     *
     * @return mixed|string
     */
    public function getAdditionalScript()
    {
        $additionalScript =  $this->_scopeConfig->getValue("Oct8ne/additionalScript/0", "default", 0);

        if (!isset($additionalScript) || empty($additionalScript)) {
            return "";
        }

        return $additionalScript;
    }

    /**
     * Additional Client Timers
     *
     * @return mixed|string
     */
    public function getClientTimer()
    {
        $clientTimer =  $this->_scopeConfig->getValue("Oct8ne/clientTimer/0", "default", 0);

        if (!isset($clientTimer) || empty($clientTimer)) {
            return "";
        }

        return $clientTimer;
    }
    
    /**
     * Additional Client Events
     *
     * @return mixed|string
     */
    public function getClientEvents()
    {
        $clientEvents =  $this->_scopeConfig->getValue("Oct8ne/clientEvents/0", "default", 0);

        if (!isset($clientEvents) || empty($clientEvents)) {
            return "DISABLED";
        }

        return $clientEvents;
    }

    /**
     * Order Search Config
     *
     * @return mixed|string
     */
    public function getOrderSearchConf()
    {
        $ordersearch =  $this->_scopeConfig->getValue("Oct8ne/user/ordersearch/0", "default", 0);
 
        if (!isset($ordersearch) || empty($ordersearch)) {
            return "incrementid";
        }
 
        return $ordersearch;
    }

    /**
     * Comprobar si doofinder está habilitado
     *
     * @return bool
     */
    public function isDoofinderEnabled()
    {
        if ($this->_moduleManager->isEnabled('Doofinder_Feed')) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Obtener la lista de todas las tiendas
     *
     * @return array
     */
    public function getStores()
    {
        $stores = $this->_store_repository->getList();
        $result = [];

        foreach ($stores as $store) {
            $result[$store->getId()] = $store->getName();
        }

        $result = array_filter($result, function ($k) {
            return $k > 0;
        }, ARRAY_FILTER_USE_KEY);

        return $result;
    }
}
