<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 29/05/2017
 * Time: 15:39
 */

namespace Oct8ne\Oct8ne\Block;

use \Oct8ne\Oct8ne\Helper\CheckCredentials;
use \Magento\Framework\View\Element\Template\Context;
use \Magento\Framework\Registry;
use Magento\Checkout\Model\Session as CheckoutSession;
use \Magento\Sales\Api\OrderRepositoryInterface;
use \Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Catalog\Helper\Image as ImageHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Asset\Repository;

class Oct8neJS extends \Magento\Framework\View\Element\Template
{
    /**
     * @var CheckCredentials
     */
    protected $_check;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var Registry
     */
    protected $_registry;

    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $_productFactory;

    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var Repository
     */
    protected $_assetRepo;

    /**
     * @var int
     */
    protected $_storeId;

    /**
     * @var CheckoutSession
     */
    protected $checkoutSession;

    /**
     * @var SearchCriteriaBuilder
     */
    protected $_searchCriteriaBuilder;

    /**
     * @var OrderRepositoryInterface
     */
    protected $_orderRepository;

    /**
     * @var ImageHelper
     */
    protected $_imageHelper;


    /**
     * Oct8neJS constructor.
     *
     * @param Context $context
     * @param CheckCredentials $check
     * @param Registry $registry
     * @param CheckoutSession $checkoutSession
     * @param OrderRepositoryInterface $orderRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param ImageHelper $imageHelper
     */
    public function __construct(
        Context $context,
        CheckCredentials $check,
        Registry $registry,
        CheckoutSession $checkoutSession,
        OrderRepositoryInterface $orderRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        ImageHelper $imageHelper
    ) {
        parent::__construct($context);
        $this->_check = $check;
        $this->_scopeConfig = $context->getScopeConfig();
        $this->_registry = $registry;
        $this->_storeManager = $context->getStoreManager();
        $this->_context = $context;
        $this->_assetRepo = $context->getAssetRepository();

        $storeId = $this->_storeManager->getStore()->getId();
        $this->_storeId = $storeId;
        
        $this->checkoutSession = $checkoutSession;
        $this->_searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_orderRepository = $orderRepository;
        $this->_imageHelper = $imageHelper;
    }

    /**
     * Obtiene el total del carrito
     *
     * @return float|string
     */
    public function getCartTotal()
    {
        // Obtener el total del carro. getLastRealOrderId() devuelve el increment_Id del pedido
        $orderbyorder = 'increment_id';
        $this->_searchCriteriaBuilder = $this->_searchCriteriaBuilder->addFilter(
            $orderbyorder,
            $this->checkoutSession->getLastRealOrderId(),
            'eq'
        );
        $this->_searchCriteriaBuilder = $this->_searchCriteriaBuilder->create();
        $orderList = $this->_orderRepository->getList($this->_searchCriteriaBuilder)->getItems();

        $order = reset($orderList);

        if (empty($order)) {
            return 0.0;
        }

        try {
            return number_format((float)$order->getGrandTotal(), 2, '.', '');
        } catch (\Exception $ex) {
            return 0;
        }
    }

    /**
     * Obtiene el ID del pedido
     *
     * @return string|null
     */
    public function getOrderId()
    {
        // Obtener la referencia del pedido
        return $this->checkoutSession->getLastRealOrderId();
    }

    /**
     * Obtiene el ID del cliente
     *
     * @return int|string|null
     */
    public function getCustomerId()
    {
        // Obtener el ID del cliente
        return $this->checkoutSession->getQuote()->getCustomer()->getId();
    }
    
    /**
     * Comprueba si estás logeado o no
     * Usa el helper
     *
     * @return bool
     */
    public function isLogged()
    {
        $email = $this->_scopeConfig->getValue("Oct8ne/user/email/".$this->_storeId, "default", $this->_storeId);
        $token = $this->_scopeConfig->getValue("Oct8ne/user/token/".$this->_storeId, "default", $this->_storeId);
        $license = $this->_scopeConfig->getValue("Oct8ne/user/license/".$this->_storeId, "default", $this->_storeId);

        if (isset($email) && isset($token) && isset($license) && !empty($email) && !empty($token) && !empty($license)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Obtiene el codigo de licencia que está guardado en user/license
     *
     * @return mixed
     */
    public function getLicense()
    {
        $license = $this->_scopeConfig->getValue("Oct8ne/user/license/".$this->_storeId, "default", $this->_storeId);
        return $license;
    }


    /**
     * Obtiene el servidor de oct8ne
     *
     * @return mixed|string
     */
    public function getOct8neServer()
    {
        $server = $this->_scopeConfig->getValue("Oct8ne/user/server/".$this->_storeId, "default", $this->_storeId);

        if (!isset($server) || empty($server)) {
            return "backoffice.oct8ne.com/";
        }

        return $server;
    }

    /**
     * Devuelve la url estática de oct8ne
     *
     * @return mixed|string
     */
    public function getUrlStatic(){
        $static = $this->_scopeConfig->getValue("Oct8ne/user/static/".$this->_storeId, "default",$this->_storeId);
        $static = trim((string)$static);
        if(!isset($static) || empty($static)){ 
            return "static.oct8ne.com/"; 
        }
        return $static;
    }

    /**
     * Posicion donde se carga el JS de magento
     *
     * @return mixed|string
     */
    public function getPositionToLoad()
    {
        $position =  $this->_scopeConfig->getValue(
            "Oct8ne/user/position/" . $this->_storeId,
            "default",
            $this->_storeId
        );

        if (!isset($position) || empty($position)) {
            return "Footer";
        }

        return $position;
    }

    /**
     * Additional script
     *
     * @return mixed|string
     */
    public function getAdditionalScript()
    {
        $additionalScript =  $this->_scopeConfig->getValue(
            "Oct8ne/additionalScript/" . $this->_storeId,
            "default",
            $this->_storeId
        );

        if (!isset($additionalScript) || empty($additionalScript)) {
            return "";
        }

        return $additionalScript;
    }
    
    /**
     * Additional Client Timers
     *
     * @return mixed|string
     */
    public function getClientTimer()
    {
        $clientTimer =  $this->_scopeConfig->getValue(
            "Oct8ne/clientTimer/" . $this->_storeId,
            "default",
            $this->_storeId
        );

        if (!isset($clientTimer) || empty($clientTimer)) {
            return "";
        }

        return $clientTimer;
    }
    
    /**
     * Additional Client Timers
     *
     * @return mixed|string
     */
    public function getClientEvents()
    {
        $clientEvents =  $this->_scopeConfig->getValue(
            "Oct8ne/clientEvents/" . $this->_storeId,
            "default",
            $this->_storeId
        );

        if (!isset($clientEvents) || empty($clientEvents)) {
            return "DISABLED";
        }

        return $clientEvents;
    }
    
    /**
     * Check if script is delayed
     *
     * @return bool
     */
    public function isScriptDelayed()
    {
        $clientEvents =  $this->getClientEvents();
        $clientTimer =  $this->getClientTimer();

        if ($clientTimer != "" || ($clientEvents != "DISABLED" && $clientEvents != "" )) {
            return true;
        }

        return false;
    }


    /**
     * Obtiene el email del usuario
     *
     * @return mixed
     */
    public function getEmail()
    {
        return $this->_scopeConfig->getValue("Oct8ne/user/email/".$this->_storeId, "default", $this->_storeId);
    }

    /**
     * Obtener la url base de la tienda
     *
     * @return mixed
     */
    public function getBaseUrl()
    {
        return $this->cleanProtocol($this->_storeManager->getStore()->getBaseUrl());
    }

    /**
     * Obtiene la url de checkout
     *
     * @return string
     */
    public function getCheckoutUrl()
    {
        return $this->cleanProtocol($this->getUrl('checkout'));
    }

    /**
     * Obtiene la url de login
     *
     * @return string
     */
    public function getLoginUrl()
    {
        return $this->cleanProtocol($this->getUrl('customer/account/login'));
    }

    /**
     * Obtiene la url de pedido con exito
     *
     * @return string
     */
    public function getSuccessUrl()
    {
        return $this->cleanProtocol($this->getUrl('checkout/onepage/success'));
    }

    /**
     * Obtener el idioma de la tienda
     *
     * @return mixed
     */
    public function getLocale()
    {
        $storeId = $this->_storeManager->getStore()->getId();
        $localeCode = $this->_scopeConfig->getValue(
            'general/locale/code',
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );

        $localeCode = str_replace("_", "-", $localeCode);

        return $localeCode;
    }

    /**
     * Obtiene la moneda de la tienda
     *
     * @return mixed
     */
    public function getCurrency()
    {
        return $this->_storeManager->getStore()->getCurrentCurrency()->getCode();
    }

    /**
     * Determina si la página es un producto o no
     *
     * @return bool
     */
    public function isProductPage()
    {
        return $this->_context->getRequest()->getFullActionName() == "catalog_product_view";
    }

    /**
     * Devuelve la id del producto
     *
     * @return int|string
     */
    public function getProductId()
    {
        $storeId = $this->_context->getRequest()->getParam('store', $this->_storeManager->getStore()->getId());
        $searchBy =  $this->_scopeConfig->getValue("Oct8ne/user/search_by/".$storeId, "default", $storeId);
        $product = $this->_registry->registry('product');

        if ($searchBy == "sku") {
            return $product->getSku();
        } else {
            return $product->getId();
        }
    }

    /**
     * Obtiene la imagen del producto
     *
     * @return string
     */
    public function getProductThumbnail()
    {
        $product = $this->_registry->registry('product');

        if (!empty($product->getImage())) {
            $url_media = $product->getImage();
            if (substr($url_media, 0, 1) !== "/") {
                $url_media = "/".$url_media;
            }
            return $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) .
                'catalog/product' . $url_media;
        } else {
            $img_folder = $this->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) .
                'catalog/product';

            //obtiene los medias de un producto (imagenes y videos)
            $medias_aux = $product->getMediaGalleryEntries();
            $mediaUrl = null;
            foreach ($medias_aux as $media) {
                if ($media->getMediaType() == "image") {
                    $urlImage = $media->getFile();
                    if (substr($urlImage, 0, 1) !== "/") {
                        $mediaUrl = $this->cleanProtocol($img_folder . "/" . $urlImage);
                    } else {
                        $mediaUrl = $this->cleanProtocol($img_folder . $urlImage);
                    }
                    break;
                }
            }

            if (!$mediaUrl) {
                $mediaUrl = $this->_imageHelper->getDefaultPlaceholderUrl('thumbnail');
            }

            if (!$mediaUrl) {
                $mediaUrl = "//static.oct8ne.com/api/img/backoffice/no-thumb-resources.png";
            }

            return $mediaUrl;
        }
    }

    /**
     * Elimina los protocolos
     *
     * @param string $string
     * @return mixed
     */
    public function cleanProtocol($string)
    {
        $aux = str_replace("https:", "", $string);
        $aux = str_replace("http:", "", $aux);
        return $aux;
    }
}
