<?php

namespace Oct8ne\Oct8ne\Block\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;
use \Oct8ne\Oct8ne\Helper\CheckCredentials;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Store\Model\StoreResolver;
use Magento\Framework\App\Request\Http;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use \Magento\Framework\Module\Manager;

class Sysoct8ne extends Field
{
    /**
     * @var CheckCredentials
     */
    protected $_check;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @var StoreResolver
     */
    protected $_storeResolver;

    /**
     * @var Http
     */
    protected $_request;

    /**
     * @var Manager
     */
    protected $_moduleManager;

    /**
     * @var string
     */
    protected $_template = 'Oct8ne_Oct8ne::system/config/sysoct8ne.phtml';

    /**
     * Constructor
     *
     * @param Context $context
     * @param CheckCredentials $check
     * @param StoreManagerInterface $storeManager
     * @param StoreResolver $storeResolver
     * @param Http $request
     * @param TypeListInterface $cacheTypeList
     * @param ScopeConfigInterface $scopeConfig
     * @param Manager $moduleManager
     * @param array $data
     */
    public function __construct(
        Context $context,
        CheckCredentials $check,
        StoreManagerInterface $storeManager,
        StoreResolver $storeResolver,
        Http $request,
        TypeListInterface $cacheTypeList,
        ScopeConfigInterface $scopeConfig,
        Manager $moduleManager,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_check = $check;
        $this->_scopeConfig = $scopeConfig;
        $this->_storeManager = $storeManager;
        $this->_storeResolver = $storeResolver;
        $this->_request = $request;
        $this->_moduleManager = $moduleManager;

        $cacheTypeList->cleanType(\Magento\Framework\App\Cache\Type\Config::TYPE_IDENTIFIER);
        $cacheTypeList->cleanType(\Magento\PageCache\Model\Cache\Type::TYPE_IDENTIFIER);
    }

    /**
     * Remove scope label
     *
     * @param  AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * Return element html
     *
     * @param  AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        return $this->_toHtml();
    }

    /**
     * Return ajax url for collect button
     *
     * @return string
     */
    public function getAjaxUrl()
    {
        return '';
    }

    /**
     * Generate collect button html
     *
     * @return string
     */
    public function getButtonHtml()
    {
        $button = $this->getLayout()->createBlock(
            'Magento\Backend\Block\Widget\Button'
        )->setData(
            [
                'id' => 'collect_button',
                'label' => __('Collect Data'),
            ]
        );

        return $button->toHtml();
    }

    /**
     * Get user email
     *
     * @return mixed
     */
    public function getEmail()
    {
        $store = (int) $this->_request->getParam('store', 0);
        return $this->_scopeConfig->getValue("Oct8ne/user/email/".$store, "default", $store);
    }

    /**
     * Get search engine
     *
     * @return mixed
     */
    public function getSearchEngine()
    {
        $store = (int) $this->_request->getParam('store', 0);
        return $this->_scopeConfig->getValue("Oct8ne/user/search_engine/".$store, "default", $store);
    }

    /**
     * Get searchBy
     *
     * @return mixed
     */
    public function getSearchBy()
    {
        $store = (int) $this->_request->getParam('store', 0);
        return $this->_scopeConfig->getValue("Oct8ne/user/search_by/".$store, "default", $store);
    }
    
    /**
     * Get doofinder hash id
     *
     * @return mixed
     */
    public function getDoofinderHashId()
    {
        $store = (int) $this->_request->getParam('store', 0);
        return $this->_scopeConfig->getValue("Oct8ne/doofinder/hashid/".$store, "default", $store);
    }

    /**
     * Get doofinder api key
     *
     * @return mixed
     */
    public function getDoofinderApiKey()
    {
        $store = (int) $this->_request->getParam('store', 0);
        return $this->_scopeConfig->getValue("Oct8ne/doofinder/apikey/".$store, "default", $store);
    }

    /**
     * Posicion donde se carga el JS de magento
     *
     * @return mixed|string
     */
    public function getPositionToLoad()
    {
        $store = (int) $this->_request->getParam('store', 0);
        $position =  $this->_scopeConfig->getValue("Oct8ne/user/position/".$store, "default", $store);

        if (!isset($position) || empty($position)) {
            return "Footer";
        }

        return $position;
    }

    /**
     * Comprobar si doofinder está habilitado
     *
     * @return bool
     */
    public function isDoofinderEnabled()
    {
        if ($this->_moduleManager->isEnabled('Doofinder_Feed')) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * Additional script
     *
     * @return mixed|string
     */
    public function getAdditionalScript()
    {
        $store = (int) $this->_request->getParam('store', 0);
        $additionalScript =  $this->_scopeConfig->getValue("Oct8ne/additionalScript/".$store, "default", $store);

        if (!isset($additionalScript) || empty($additionalScript)) {
            return "";
        }

        return $additionalScript;
    }

    /**
     * Additional Client Timers
     *
     * @return mixed|string
     */
    public function getClientTimer()
    {
        $store = (int) $this->_request->getParam('store', 0);
        $clientTimer =  $this->_scopeConfig->getValue("Oct8ne/clientTimer/".$store, "default", $store);

        if (!isset($clientTimer) || empty($clientTimer)) {
            return "";
        }

        return $clientTimer;
    }
    
    /**
     * Additional Client Events
     *
     * @return mixed|string
     */
    public function getClientEvents()
    {
        $store = (int) $this->_request->getParam('store', 0);
        $clientEvents =  $this->_scopeConfig->getValue("Oct8ne/clientEvents/".$store, "default", $store);

        if (!isset($clientEvents) || empty($clientEvents)) {
            return "DISABLED";
        }

        return $clientEvents;
    }

    /* Oct8ne */

    /**
     * Obtiene la url a un controlador
     *
     * @return string
     */
    public function getFormAction()
    {
        return $this->getUrl('oct8ne/login/index');
    }

    /**
     * Posicion donde se carga el JS de magento
     *
     * @return mixed|string
     */
    public function getOrderSearchConf()
    {
        $store = (int) $this->_request->getParam('store', 0);

        $ordersearch =  $this->_scopeConfig->getValue("Oct8ne/user/ordersearch/0", "default", 0);
 
        if (!isset($ordersearch) || empty($ordersearch)) {
            return "incrementid";
        }
 
        return $ordersearch;
    }

    /**
     * Comprueba si estas logeado o no
     *
     * @return bool
     */
    public function isLogged()
    {
        $store = (int) $this->_request->getParam('store', 0);

        $email = $this->_scopeConfig->getValue("Oct8ne/user/email/".$store, "default", $store);
        $token = $this->_scopeConfig->getValue("Oct8ne/user/token/".$store, "default", $store);
        $license = $this->_scopeConfig->getValue("Oct8ne/user/license/".$store, "default", $store);

        if (isset($email) && isset($token) && isset($license) && !empty($email) && !empty($token) && !empty($license)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Get Store ID
     *
     * @return int
     */
    public function getStoreId()
    {
        return (int) $this->_request->getParam('store', 0);
    }
}
