<?php

/**
 * Created by Oct8ne
 * User: Miguel Ruiz Bas
 * Date: 18/09/2021
 * Time: 9:18
 */

namespace Oct8ne\Oct8ne\Controller\Adminhtml\Login;

use \Magento\Backend\App\Action\Context;
use \Magento\Framework\View\Result\PageFactory;
use \Magento\Config\Model\ResourceModel\Config;
use \Magento\Framework\HTTP\Client\Curl;
use \Magento\Store\Model\StoreManagerInterface;
use \Magento\Framework\App\Cache\TypeListInterface;
use \Magento\Store\Model\ScopeInterface;
use \Magento\Store\Api\StoreRepositoryInterface; 



class Index extends \Magento\Backend\App\Action
{

    /**
     * @var PageFactory
     */
    protected $request;    
    protected $resultPageFactory;
    protected $messageManager;
    protected $resourceConfig;
    protected $curl;
    protected $storeManagerInterface;
    protected $_cacheTypeList;
    protected $linkupStatus;
    protected $_store_id;
    protected $_exclusiones;
    protected $_store_repository;
    protected $_store_compute;

//https://magento.stackexchange.com/questions/78457/how-to-get-value-from-core-config-data-table-in-magento-2

    /**
     * @param Context $context
     * @param PageFactory $resultPageFactory
     */
    public function __construct(Context $context, PageFactory $resultPageFactory, Config $resourceConfig, Curl $curl, StoreManagerInterface $StoreManagerInterface, TypeListInterface $cacheTypeList, StoreRepositoryInterface $repository)
    {
        parent::__construct($context);
        $this->request = $context->getRequest();
        $this->resultPageFactory = $resultPageFactory;
        $this->messageManager = $context->getMessageManager();
        $this->resourceConfig = $resourceConfig;
        $this->storeManagerInterface = $StoreManagerInterface;
        $this->curl = $curl;
        $this->_cacheTypeList = $cacheTypeList;
        $this->_store_repository = $repository;
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */

    public function execute()
    {

        $resultPage = null;

        $action = $this->request->getParam("oct8ne_form_action", "index");

        $this->_store_id = (int) $this->request->getParam("oct_store", 0);
        if($this->_store_id == 0){

            $exclusiones_aux = ($this->request->getParam("exclusiones") == NULL) ? array() : $this->request->getParam("exclusiones");
            $stores = $this->getStores();     
            $compute_stores = array_diff($stores, $exclusiones_aux);
            $compute_stores[] = $this->_store_id;
            $compute_stores = array_unique($compute_stores);
            $this->_store_compute = $compute_stores;
        } else {
            
            $this->_store_compute = array($this->_store_id);
        }


        if ($action == "login") {
        
        
            //obtener los parametros de la peticion
            $email = $action = $this->request->getParam("oct8ne_user", "");
            $pass = $action = $this->request->getParam("oct8ne_pass", "");

            $this->linkUp($email, $pass);

            $this->cleanCache();
            $this->request->clearParams();

            if($this->_store_id > 0) return; //llamada ajax

           
            return $this->redirect(); 


        } else if ($action == "logout") {

            foreach ($this->_store_compute as $compute) {

                $this->resourceConfig->deleteConfig("Oct8ne/user/email/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/token/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/license/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/server/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/static/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/search_engine/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/position/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/user/ordersearch/0", "default", 0);
                $this->resourceConfig->deleteConfig("Oct8ne/doofinder/hashid/".$compute, "default", $compute);
                $this->resourceConfig->deleteConfig("Oct8ne/doofinder/apikey/".$compute, "default", $compute);
            }

            $this->request->clearParams();
            $this->cleanCache();

            if($this->_store_id > 0) return; //llamada ajax

            $this->messageManager->addSuccessMessage("Desconectado correctamente");

            return $this->redirect();



        } else if ($action == "basic_configuration") {

            $engine = $this->request->getParam("engine", "Magento");
            $searchBy = $this->request->getParam("oct8ne_search_by", "Id");
            $position = $this->request->getParam("position", "Footer");
            $doofinderHashId = $this->request->getParam("oct8ne_doofinder_hashid", "");            
            $doofinderApiKey = $this->request->getParam("oct8ne_doofinder_apikey", "");            
            $ordersearch = $this->request->getParam("ordersearch", "incrementid");
            $additionalScript = $this->request->getParam("additionalScript", "");

            $clientEvents = $this->request->getParam("clientEvents", "");
            $clientTimer = $this->request->getParam("clientTimer", "");

            if (!isset($searchBy)) {
                $searchBy = "id";
            }

            $this->request->clearParams();

            foreach ($this->_store_compute as $compute) {

                $this->resourceConfig->saveConfig("Oct8ne/user/search_engine/".$compute, $engine, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/user/search_by/".$compute, $searchBy, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/user/position/".$compute, $position, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/doofinder/hashid/".$compute, $doofinderHashId, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/doofinder/apikey/".$compute, $doofinderApiKey, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/user/ordersearch/0", $ordersearch, "default", 0);

                if(isset($additionalScript) && trim($additionalScript) !== "") {
                    $this->resourceConfig->saveConfig("Oct8ne/additionalScript/".$compute, $additionalScript, "default", $compute);
                }
                
                $this->resourceConfig->saveConfig("Oct8ne/clientEvents/".$compute, $clientEvents, "default", $compute);
                $this->resourceConfig->saveConfig("Oct8ne/clientTimer/".$compute, $clientTimer, "default", $compute);
            }

            $this->cleanCache();
            $this->messageManager->addSuccessMessage("Configuración actualizada correctamente correctamente");

            if($this->_store_id > 0) return; //llamada ajax

            return $this->redirect();


        } else {

            $resultPage = $this->resultPageFactory->create();
        }

        $resultPage->getConfig()->getTitle()->set('Oct8ne configuration');
        return $resultPage;

    }


    /**
     * Redirecciona al login de nuevo
     * @return \Magento\Framework\Controller\Result\Redirect
     */
    private function redirect()
    {

        /* Do your controller action stuff here */
        $resultRedirect = $this->resultRedirectFactory->create();
        $resultRedirect->setPath('oct8ne/login/index');
        return $resultRedirect;
    }


    /**
     * Linkup hecho con magento
     * @param $user
     * @param $pass
     */
    private function linkUp($user, $pass)
    {


        //endpoint
        $url = 'https://backoffice.oct8ne.com/platformConnection/linkup';  
                
        //datos
        $data = array('email' => $user,
            'pass' => $pass,
            'platform' => 'magento2',
            'urlDomain' => $this->storeManagerInterface->getStore()->getBaseUrl(), //$this->storeManagerInterface->getStore()->getBaseUrl(),
            'statusPlatform' => true);

        //opciones
        $options = array(

            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_CONNECTTIMEOUT => 15,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_HTTPHEADER => array('Content-Type: application/json;charset=UTF-8\r\n'),
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_POSTFIELDS => json_encode($data)

        );

        //establece las opciones del curl
        $this->curl->setOptions($options);

        //hace la llamada
        $this->curl->get($url);

        //obiçtiene la respuesta
        $response = $this->curl->getBody();

        //to array
        $response = json_decode($response, true);


        //comprueba que los datos necesarios se han obtenido
        if ($response == null) {

            $this->messageManager->addErrorMessage("Unexpected error");
        } else {

            if ($response["ApiToken"] != null && $response["LicenseId"] != null) {

                $this->linkupStatus = 1;
                

                //Postprocesado de datos
                $server = $response["Server"];
                $UrlStatic = $response["UrlStatic"];
                $server = (isset($server) && !empty($server)) ? $server : 'backoffice.oct8ne.com/';
                $UrlStatic = (isset($UrlStatic) && !empty($UrlStatic)) ? $UrlStatic : 'static.oct8ne.com/';

                //guardar datos

                foreach($this->_store_compute as $compute) {
                    $this->resourceConfig->saveConfig("Oct8ne/user/server/".$compute, $server, "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/static/".$compute, $UrlStatic, "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/email/".$compute, $user, "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/token/".$compute, $response["ApiToken"], "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/license/".$compute, $response["LicenseId"], "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/search_engine/".$compute,'Magento', "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/position/".$compute, 'Footer', "default", $compute);
                    $this->resourceConfig->saveConfig("Oct8ne/user/ordersearch/0", 'incrementid', "default", 0);
                }

                
                //mensaje correcto
                $this->messageManager->addSuccessMessage("Conectado correctamente");


            } else {

                //mensaje incorrecto
                $this->linkupStatus = 0;
                $this->messageManager->addErrorMessage($response["Message"]);
            }

        }

    }


    /**
     * Limpiar cache
     */
    private function cleanCache()
    {
        $this->_cacheTypeList->cleanType(\Magento\Framework\App\Cache\Type\Config::TYPE_IDENTIFIER);
        $this->_cacheTypeList->cleanType(\Magento\PageCache\Model\Cache\Type::TYPE_IDENTIFIER);
    }


    
    /**
     * Obtener la lista de todas las tiendas
     */
    public function getStores() {

        $stores = $this->_store_repository->getList();

        $result = [];

        foreach ($stores as $store) {

            $result[$store->getId()] = $store->getName();

        }

        $result = array_filter($result, function($k) {
            return $k > 0;
        }, ARRAY_FILTER_USE_KEY);

        return array_keys($result);
    }

}
