<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 10/06/2017
 * Time: 12:06
 */

namespace Oct8ne\Oct8ne\Controller\Frame;

use \Magento\Framework\App\Action\Context;
use \Oct8ne\Oct8ne\Helper\ResponseHelper;
use \Magento\Checkout\Model\Session;
use \Magento\Catalog\Api\ProductRepositoryInterfaceFactory;
use \Magento\Framework\Pricing\PriceCurrencyInterface as CurrencyHelper;
use \Oct8ne\Oct8ne\Helper\Oct8neContextHelper;
use \Oct8ne\Oct8ne\Helper\ProductSummaryHelper;

class GetCart extends \Magento\Framework\App\Action\Action
{
    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var ProductRepositoryInterfaceFactory
     */
    protected $_productRepository;

    /**
     * @var CurrencyHelper
     */
    protected $_currencyHelper;

    /**
     * @var Oct8neContextHelper
     */
    protected $_oct8necontext;

    /**
     * @var ProductSummaryHelper
     */
    protected $_helper;

    /**
     * @var ResponseHelper
     */
    protected $_responseHelper;

    /**
     * @var Session
     */
    protected $_session;

    /**
     * Constructor
     *
     * @param Context $context
     * @param ProductSummaryHelper $helper
     * @param ResponseHelper $responseHelper
     * @param Oct8neContextHelper $oct8necontext
     * @param Session $session
     * @param ProductRepositoryInterfaceFactory $productRepository
     * @param CurrencyHelper $currencyHelper
     */
    public function __construct(
        Context $context,
        ProductSummaryHelper $helper,
        ResponseHelper $responseHelper,
        Oct8neContextHelper $oct8necontext,
        Session $session,
        ProductRepositoryInterfaceFactory $productRepository,
        CurrencyHelper $currencyHelper
    ) {
        $this->_context = $context;
        $this->_responseHelper = $responseHelper;
        $this->_productRepository = $productRepository;
        $this->_currencyHelper = $currencyHelper;
        $this->_oct8necontext = $oct8necontext;
        $this->_helper = $helper;
        $this->_session = $session;

        parent::__construct($context);
    }

    /**
     * Execute action
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $data = [];

        //obtiene el carrito de la sesioon
        $quote = $this->_session->getQuote();
        $id = $quote->getId();

        //si el carro esta vacio
        if ($id === null) {
            return $this->_responseHelper->buildResponse($data);
        }

        $data["currency"] = $quote->getQuoteCurrencyCode(); //obtiene la moneda de pago
        $data["price"] = $quote->getSubtotal(); //subtotal
        $data["finalPrice"] = $quote->getGrandTotal(); //total
        $data["totalItems"] = $quote->getItemsSummaryQty(); //cantidad de productos en el carrito n*m

        $items = $quote->getAllVisibleItems(); //lineas visibbles en el carrito
        $oct8ne_context = $this->_oct8necontext->getOct8neContext();
        
        $products = [];

        foreach ($items as $item) {
            $id = $item->getProductId();
            $qty =  $item->getQty();
            $name = $item->getName();
            
            $product = $this->_productRepository->create()->getById($id, false, $oct8ne_context["context_shop"]);
            
            $rate = $this->_helper->getRateValue($product);
            //OBTIENE LOS PRECIOS DEL PRODUCTO CON Y SIN TASAS
            $prices = $this->_helper->getPricesWWTaxes($product, $rate);
            //CONVIERTE A LA MONEDA REQUERIDA
            $prices = $this->_helper->formatPrices($prices, $oct8ne_context);
            
            $price = $prices["final_incl"];
            
            $products[] = ["internalId" => $id, "title" => $name, "qty" => $qty, "price" => $price];
        }

        $data["cart"] = $products;

        return $this->_responseHelper->buildResponse($data);
    }
}
