<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 02/06/2017
 * Time: 12:06
 */

namespace Oct8ne\Oct8ne\Controller\Frame;

use \Magento\Framework\App\Action\Context;
use \Oct8ne\Oct8ne\Helper\ResponseHelper;
use \Magento\Framework\App\Config\ScopeConfigInterface;
use \Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use \Oct8ne\Oct8ne\Helper\Oct8neContextHelper;
use \Magento\Framework\Pricing\PriceCurrencyInterface as CurrencyHelper;
use \Magento\Sales\Api\OrderRepositoryInterface;
use \Magento\Framework\Api\SearchCriteriaBuilder;
use \Oct8ne\Oct8ne\Helper\CheckCredentials;
use \Magento\Framework\Module\Manager;

class GetOrderDetails extends \Magento\Framework\App\Action\Action
{
    /**
     * @var Oct8neContextHelper
     */
    protected $_oct8necontext;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeconfig;

    /**
     * @var CollectionFactory
     */
    protected $_orderCollectionFactory;

    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var ResponseHelper
     */
    protected $_responseHelper;

    /**
     * @var CurrencyHelper
     */
    protected $_currencyHelper;

    /**
     * @var OrderRepositoryInterface
     */
    protected $_orderRepository;

    /**
     * @var SearchCriteriaBuilder
     */
    protected $_searchCriteriaBuilder;

    /**
     * @var CheckCredentials
     */
    protected $_credentials;

    /**
     * @var Manager
     */
    protected $_moduleManager;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Oct8neContextHelper $oct8necontext
     * @param ResponseHelper $responseHelper
     * @param ScopeConfigInterface $scope
     * @param CollectionFactory $orderCollectionFactory
     * @param CurrencyHelper $currencyHelper
     * @param OrderRepositoryInterface $orderRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param CheckCredentials $check
     * @param Manager $moduleManager
     */
    public function __construct(
        Context $context,
        Oct8neContextHelper $oct8necontext,
        ResponseHelper $responseHelper,
        ScopeConfigInterface $scope,
        CollectionFactory $orderCollectionFactory,
        CurrencyHelper $currencyHelper,
        OrderRepositoryInterface $orderRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        CheckCredentials $check,
        Manager $moduleManager
    ) {
        $this->_context = $context;
        $this->_oct8necontext = $oct8necontext;
        $this->_responseHelper = $responseHelper;
        $this->_scopeconfig = $scope;
        $this->_orderCollectionFactory = $orderCollectionFactory;
        $this->_currencyHelper = $currencyHelper;
        $this->_orderRepository = $orderRepository;
        $this->_searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_credentials = $check;
        $this->_moduleManager = $moduleManager;
    
        parent::__construct($context);
    }

    /**
     * Execute action
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $oct8ne_context = $this->_oct8necontext->getOct8neContext();
        
        $apiToken = $this->_context->getRequest()->getParam("apiToken");
        $id = $this->_context->getRequest()->getParam("reference");
        $email = $this->_context->getRequest()->getParam("email");
        $currency = $this->_context->getRequest()->getParam("currency");
        
        $ordersearch =  $this->_scopeconfig->getValue("Oct8ne/user/ordersearch/0", "default", 'increment_id');
        $orderbyorder = ($ordersearch == 'incrementid') ? 'increment_id' : 'entity_id';

        if (!($this->_credentials->validateToken($apiToken))) {
            return $this->_responseHelper->buildResponse([]);
        }
                
        $this->_searchCriteriaBuilder = $this->_searchCriteriaBuilder->addFilter($orderbyorder, $id, 'eq');

        if (!empty($email)) {
            $this->_searchCriteriaBuilder = $this->_searchCriteriaBuilder->addFilter('customer_email', $email, 'eq');
        }

        $this->_searchCriteriaBuilder = $this->_searchCriteriaBuilder->create();

        $orderList = $this->_orderRepository->getList($this->_searchCriteriaBuilder)->getItems();
        $order = reset($orderList);

        if (empty($order)) {
            return $this->_responseHelper->buildResponse([]);
        }

        $currencyOrder = "";
        $total = (string)$this->_currencyHelper->convertAndRound($order->getGrandTotal(), null, $currency, 2);

        if ($oct8ne_context["context_currency"] != $currency) {
            $currencyOrder = $currency;
        } else {
            $currencyOrder = $oct8ne_context["context_currency"];
            $total = $order->getGrandTotal();
        }

        $tracksCollection = $order->getTracksCollection();
        $trackNumbers = [];

        foreach ($tracksCollection->getItems() as $track) {
            $tracknumber = $track->getTrackNumber();
            $trakURL = $track->getUrl();

            $aux = [];
            $aux["trackNumber"] = isset($tracknumber) ? $tracknumber : "";
            $aux["trackURL"] = isset($trakURL) ? $trakURL : "";
            $trackNumbers = $aux;
        }

        $products = [];

        foreach ($order->getAllVisibleItems() as $item) {
            $aux = [];
            $aux["quantity"] = (string)(int)$item->getQtyOrdered();
            $aux["name"] =  $item->getName();

            try {
                $productOptions = $item->getProductOptions();
                if (isset($productOptions)) {
                    if (isset($productOptions["simple_name"]) && $productOptions["simple_name"] != $aux["name"]) {
                        $aux["name"] = $productOptions["simple_name"];
                    } else {
                        if (isset($productOptions["attributes_info"])) {
                            $string = "";
                            foreach ($productOptions["attributes_info"] as $attribute) {
                                if (isset($attribute['label']) && isset($attribute['value'])) {
                                    $string .= "{$attribute['label']}={$attribute['value']}, ";
                                }
                            }
                            $string = rtrim($string, ", ");
                            $aux["name"] = $item->getName() . " (" . $string . ")";
                        }
                    }
                }
            } catch (\Exception $e) {
                // Log error if needed, but avoid breaking execution
                $this->_context->getLogger()->error($e->getMessage());
            }
            
            $products[] = $aux;
        }

        $histories = $order->getStatusHistories();
        $comments = [];

        foreach ($histories as $history) {
            $aux = [];
            $aux["message"] = $history->getComment();
            $comments[] = $aux;
        }
        
        $orderincrementid = ($ordersearch == 'incrementid') ? $order->getIncrementId() : $order->getOrderId();
        $estimatedDeliveryDateDatetime = "";
    
        if ($this->_moduleManager->isEnabled('Wyomind_EstimatedDeliveryDate')) {
            $estimatedDeliveryDateDatetime = $order->getEstimatedDeliveryDateDatetime();
            if (!empty($estimatedDeliveryDateDatetime)) {
                $estimatedDeliveryDateDatetime = explode(" ", $estimatedDeliveryDateDatetime)[0];
            }
        }
        
        $data = [
            "date" => $order->getCreatedAt(),
            "reference" => $orderincrementid,
            "total" => $total,
            "currency" => $currencyOrder,
            "labelState" => $order->getStatusLabel(),
            "deliveryDate" => $estimatedDeliveryDateDatetime,
            "carrier" => $order->getShippingMethod(),
            "trackingNumber" => isset($trackNumbers["trackNumber"]) ? $trackNumbers["trackNumber"] : "",
            "trackingURL" => isset($trackNumbers["trackURL"]) ? $trackNumbers["trackURL"] : "",
            "products" => $products,
            "comments" => $comments
        ];
        
        return $this->_responseHelper->buildResponse($data);
    }
}
