<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 02/06/2017
 * Time: 12:06
 */

namespace Oct8ne\Oct8ne\Controller\Frame;

use \Magento\Framework\App\Action\Context;
use \Oct8ne\Oct8ne\Helper\ResponseHelper;
use \Magento\Framework\App\Config\ScopeConfigInterface;
use \Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use \Oct8ne\Oct8ne\Helper\Oct8neContextHelper;
use \Magento\Framework\Pricing\PriceCurrencyInterface as CurrencyHelper;
use \Oct8ne\Oct8ne\Helper\CheckCredentials;

class GetOrders extends \Magento\Framework\App\Action\Action
{

    /**
     * @var Oct8neContextHelper
     */
    protected $_oct8necontext;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeconfig;

    /**
     * @var CollectionFactory
     */
    protected $_orderCollectionFactory;

    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var ResponseHelper
     */
    protected $_responseHelper;

    /**
     * @var CurrencyHelper
     */
    protected $_currencyHelper;

    /**
     * @var CheckCredentials
     */
    protected $_credentials;

    /**
     * Inyeccion de dependencias. Inyectamos lo que nos hace falta
     * GetAdapterInfo constructor.
     * @param Context $context
     * @param Oct8neContextHelper $oct8necontext
     * @param ResponseHelper $responseHelper
     * @param ScopeConfigInterface $scope
     * @param CollectionFactory $orderCollectionFactory
     * @param CurrencyHelper $currencyHelper
     * @param CheckCredentials $check
     */
    public function __construct(
        Context $context,
        Oct8neContextHelper $oct8necontext,
        ResponseHelper $responseHelper,
        ScopeConfigInterface $scope,
        CollectionFactory $orderCollectionFactory,
        CurrencyHelper $currencyHelper,
        CheckCredentials $check
    ) {
        $this->_context = $context;
        $this->_oct8necontext = $oct8necontext;
        $this->_responseHelper = $responseHelper;
        $this->_scopeconfig = $scope;
        $this->_orderCollectionFactory = $orderCollectionFactory;
        $this->_currencyHelper = $currencyHelper;
        $this->_credentials = $check;

        parent::__construct($context);
    }

    /**
     * Todos los controladores ejecutan el execute despues de la construccion
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $oct8ne_context = $this->_oct8necontext->getOct8neContext();
        
        $apiToken = $this->_context->getRequest()->getParam("apiToken");
        $customerEmail = $this->_context->getRequest()->getParam("customerEmail");
        $page = $this->_context->getRequest()->getParam("page");
        $pagesize = $this->_context->getRequest()->getParam("pageSize");
        $locale = $this->_context->getRequest()->getParam("locale");
        $currency = $this->_context->getRequest()->getParam("currency");

        $page = isset($page) ? $page : 1;
        $pagesize = isset($pagesize) ? $pagesize : 10;
        
        if (!($this->_credentials->validateToken($apiToken))) {
            return $this->_responseHelper->buildResponse([]);
        }

        $ordersCollection = $this->_orderCollectionFactory->create();
        $ordersCollection->addAttributeToSelect('*');
        $ordersCollection->addFieldToFilter('customer_email', $customerEmail);
        $ordersCollection->setPageSize($pagesize);
        $ordersCollection->setCurPage($page);

        $data = [];
        
        foreach ($ordersCollection as $order) {
            $currencyOrder = "";
            $total = (string)$this->_currencyHelper->convertAndRound($order->getGrandTotal(), null, $currency, 2);
    
            if ($oct8ne_context["context_currency"] != $currency) {
                $currencyOrder = $currency;
            } else {
                $currencyOrder = $oct8ne_context["context_currency"];
                $total = $order->getGrandTotal();
            }

            $aux = [
                "date" => $order->getCreatedAt(),
                //"reference" => $order->getEntityId(),
                "reference" => $order->getIncrementId(),
                "total" => $total,
                "currency" => $currencyOrder,
                "labelState" => $order->getStatusLabel(),
                "deliveryDate" => ""
            ];
            $data[] = $aux;
        }
    
        return $this->_responseHelper->buildResponse($data);
    }
}
