<?php

/**
 * Created by PhpStorm.
 * User: migue
 * Date: 10/06/2017
 * Time: 12:06
 */

namespace Oct8ne\Oct8ne\Controller\Frame;

use \Magento\Framework\App\Action\Context;
use \Oct8ne\Oct8ne\Helper\ResponseHelper;
use \Magento\Framework\App\Config\ScopeConfigInterface;
use \Oct8ne\Oct8ne\Helper\Search\SearchFactory;
use \Magento\Store\Model\StoreManagerInterface;
use \Oct8ne\Oct8ne\Helper\Oct8neContextHelper;
use \Oct8ne\Oct8ne\Helper\ProductSummaryHelper;

class Search extends \Magento\Framework\App\Action\Action
{
    /**
     * @var ProductSummaryHelper
     */
    protected $_helper;

    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var ResponseHelper
     */
    protected $_responseHelper;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var SearchFactory
     */
    protected $_searchFactory;

    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * @var Oct8neContextHelper
     */
    protected $_oct8neContext;

    /**
     * @var ProductSummaryHelper
     */
    protected $_productSummaryHelper;

    /**
     * Inyeccion de dependencias. Inyectamos lo que nos hace falta
     *
     * @param Context $context
     * @param ResponseHelper $responseHelper
     * @param ScopeConfigInterface $scopeConfig
     * @param SearchFactory $searchFactory
     * @param StoreManagerInterface $storeManager
     * @param Oct8neContextHelper $oct8neContextHelper
     * @param ProductSummaryHelper $productSummaryHelper
     */
    public function __construct(
        Context $context,
        ResponseHelper $responseHelper,
        ScopeConfigInterface $scopeConfig,
        SearchFactory $searchFactory,
        StoreManagerInterface $storeManager,
        Oct8neContextHelper $oct8neContextHelper,
        ProductSummaryHelper $productSummaryHelper
    ) {
        $this->_context = $context;
        $this->_responseHelper = $responseHelper;
        $this->_scopeConfig = $scopeConfig;
        $this->_searchFactory = $searchFactory;
        $this->_storeManager = $storeManager;
        $this->_oct8neContext = $oct8neContextHelper;
        $this->_productSummaryHelper = $productSummaryHelper;

        parent::__construct($context);
    }

    /**
     * Todos los controladores ejecutan el execute despues de la construccion
     *
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $data = [
            'total' => 0,
            'results' => [],
            'filters' => [
                'applied' => [],
                'available' => []
            ]
        ];

        $storeId = $this->_context->getRequest()->getParam('store', $this->_storeManager->getStore()->getId());
        $engine =  $this->_scopeConfig->getValue("Oct8ne/user/search_engine/" . $storeId, "default", $storeId);
        $searchTerm = $this->_context->getRequest()->getParam('search', null);
        $searchOrder = $this->_context->getRequest()->getParam('orderby', 'relevance');
        $searchDir = $this->_context->getRequest()->getParam('dir', 'asc');
        $searchBy =  $this->_scopeConfig->getValue("Oct8ne/user/search_by/" . $storeId, "default", $storeId);

        $page = (int)$this->_context->getRequest()->getParam("page", 1);

        if ($page < 1) {
            $page = 1;
        }

        $pageSize = (int)$this->_context->getRequest()->getParam('pageSize', 10);

        $search_engine = $this->_searchFactory->getInstance($engine);

        $totalSearchResults = 0;
        $attrs_applied = [];
        $attrs_available = [];

        if ($search_engine->isValidSearchData($searchTerm, $storeId)) {
            $products = $search_engine->search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, $searchBy, $totalSearchResults, $attrs_applied, $attrs_available);

            $oct8necontext = $this->_oct8neContext->getOct8neContext();

            $data["total"] = $totalSearchResults;

            $data['filters']['applied'] = $attrs_applied;
            $data['filters']['available'] = $attrs_available;

            foreach ($products as $product) {
                $data["results"][] = $this->_productSummaryHelper->getProductSummary($product, $oct8necontext);
            }
        }

        return $this->_responseHelper->buildResponse($data);
    }
}
