<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 30/05/2017
 * Time: 16:56
 * Login general
 */

namespace Oct8ne\Oct8ne\Helper;

use \Magento\Framework\App\Helper\AbstractHelper;
use \Magento\Framework\App\Helper\Context;
use \Magento\Store\Api\StoreRepositoryInterface;

class CheckCredentials extends AbstractHelper
{
    /**
     * @var Context
     */
    protected $_context;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeconfig;

    /**
     * @var StoreRepositoryInterface
     */
    protected $_store_repository;

    /**
     * Constructor
     *
     * @param Context $context
     * @param StoreRepositoryInterface $repository
     */
    public function __construct(Context $context, StoreRepositoryInterface $repository)
    {
        parent::__construct($context);
        $this->_context = $context;
        $this->_scopeconfig = $context->getScopeConfig();
        $this->_store_repository = $repository;
    }

    /**
     * Comprueba si estas logeado o no
     *
     * @return bool
     */
    public function isLogged()
    {
        $email = $this->_scopeconfig->getValue("Oct8ne/user/email/0", "default", 0);
        $token = $this->_scopeconfig->getValue("Oct8ne/user/token/0", "default", 0);
        $license = $this->_scopeconfig->getValue("Oct8ne/user/license/0", "default", 0);

        if (isset($email) && isset($token) && isset($license) && !empty($email) && !empty($token) && !empty($license)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Comprueba si el token de la petición es uno de los válidos
     *
     * @param string $token
     * @return bool
     */
    public function validateToken($token)
    {
        $stores = $this->_store_repository->getList();
        $tokens = [];

        foreach ($stores as $store) {
            $tokens[] = $this->_scopeconfig->getValue("Oct8ne/user/token/".$store->getId(), "default", $store->getId());
        }
        return in_array($token, $tokens);
    }
}
