<?php

namespace Oct8ne\Oct8ne\Helper\Search;

use \Magento\CatalogSearch\Helper\Data as CatalogSearch;
use \Magento\Catalog\Model\Layer\Category\FilterableAttributeList;
use \Magento\Catalog\Api\ProductRepositoryInterface;
use \Magento\Framework\Api\Search\SearchCriteriaBuilderFactory;
use \Magento\Framework\Api\FilterBuilder;
use \Magento\Framework\Api\Search\FilterGroupBuilder;
use Magento\Framework\Api\SortOrderBuilder;
use Magento\Framework\Api\SortOrder;
use \Magento\CatalogInventory\Model\Stock\StockItemRepository;
use \Magento\Search\Api\SearchInterface;
use Magento\Framework\Api\Filter;
use \Magento\Framework\App\Helper\Context;

class Magento extends Base
{
    protected $_catalogSearchHelper;
    protected $_filterableAttributeList;
    protected $_productRepository;
    protected $_searchCriteriaBuilderFactory;
    protected $_filterBuilder;
    protected $_sortOrderBuilder;
    protected $_filterGroupBuilder;
    protected $_stockItemRepository;
    protected $_SearchInterface;
    protected $_eavConfig;

    public function __construct(
        Context $context,
        
        CatalogSearch $catalogSearchHelper, 
        FilterableAttributeList $filterableAttributeList, 
        ProductRepositoryInterface $productRepository, 
        SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory, 
        FilterBuilder $filterBuilder, 
        FilterGroupBuilder $filterGroupBuilder, 
        StockItemRepository $stockItemRepository, 
        SearchInterface $SearchInterface, 
        SortOrderBuilder $sortOrder,
        \Magento\Eav\Model\Config $eavConfig
    ) {
        parent::__construct($context);

        $this->_catalogSearchHelper = $catalogSearchHelper;
        $this->_filterableAttributeList = $filterableAttributeList;
        $this->_productRepository = $productRepository;
        $this->_searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->_filterBuilder = $filterBuilder;
        $this->_filterGroupBuilder = $filterGroupBuilder;
        $this->_stockItemRepository = $stockItemRepository;
        $this->_SearchInterface = $SearchInterface;
        $this->_sortOrderBuilder = $sortOrder;
        $this->_eavConfig = $eavConfig;
    }

    public function getEngineName()
    {
        return "Magento";
    }

    public function isValidSearchData($searchTerm, $storeId)
    {
        if (is_null($searchTerm) || strlen($searchTerm) == 0) {
            return false;
        }
        $helper = $this->_catalogSearchHelper;
        $len = strlen($searchTerm);
        if ($len < $helper->getMinQueryLength() || $len > $helper->getMaxQueryLength()) {
            return false;
        }
        return true;
    }

    public function search($storeId, $searchTerm, $searchOrder, $searchDir, $page, $pageSize, $searchBy, &$totalSearchResults, &$attrs_applied, &$attrs_available)
    {
        $searchCriteriaBuilder = $this->_searchCriteriaBuilderFactory->create();
        
        $realPage = (int)$page - 1;
        if ($realPage < 0) $realPage = 0;

        $searchCriteriaBuilder->setPageSize((int)$pageSize);
        $searchCriteriaBuilder->setCurrentPage($realPage); 
        
        $direction = (strtoupper($searchDir) === 'DESC') ? SortOrder::SORT_DESC : SortOrder::SORT_ASC;
        $field = ($searchOrder && $searchOrder !== 'relevance') ? $searchOrder : 'relevance';
        
        if ($field === 'relevance') {
            $direction = SortOrder::SORT_DESC;
        }
        $searchCriteriaBuilder->addSortOrder($field, $direction);
        
        $first_character = substr($searchTerm, 0, 1);
        $resultObj = null;
        $products = [];

        if ($first_character === "@" || $first_character === "#") {
            $cleanTerm = substr($searchTerm, 1);
            
            $filter = $this->_filterBuilder->setField('sku')
                ->setValue($cleanTerm)
                ->setConditionType("like")
                ->create();
            
            $searchCriteriaBuilder->addFilter($filter);
            $search_criteria = $searchCriteriaBuilder->create();

            try {
                $resultObj = $this->_productRepository->getList($search_criteria);
                $products = $resultObj->getItems();
                $totalSearchResults = $resultObj->getTotalCount();
            } catch (\Exception $e) {
                $products = [];
                $totalSearchResults = 0;
            }

        } else {
            $filter = $this->_filterBuilder->setField('search_term')
                ->setValue($searchTerm)
                ->setConditionType("like")
                ->create();
            $searchCriteriaBuilder->addFilter($filter);

            $paramsFromUrl = $this->getAppliedFilters();
            if (!empty($paramsFromUrl)) {
                foreach ($paramsFromUrl as $code => $value) {
                    $conditionType = 'eq';
                    $filterValue = $value;

                    if (is_array($value)) {
                        $conditionType = 'in';
                    } elseif (strpos($value, ',') !== false) {
                        $conditionType = 'in';
                        $filterValue = explode(',', $value);
                    }

                    $facetFilter = $this->_filterBuilder
                        ->setField($code)
                        ->setValue($filterValue)
                        ->setConditionType($conditionType)
                        ->create();
                    $searchCriteriaBuilder->addFilter($facetFilter);
                }
            }

            $search_criteria = $searchCriteriaBuilder->create();
            $search_criteria->setRequestName("quick_search_container");

            try {
                $resultObj = $this->_SearchInterface->search($search_criteria);
                $products = $resultObj->getItems();
                $totalSearchResults = $resultObj->getTotalCount();
            } catch (\Exception $e) {
                $products = [];
                $totalSearchResults = 0;
            }

            if ($resultObj) {
                $aggregations = $resultObj->getAggregations();
                
                if ($aggregations) {
                    foreach ($aggregations->getBuckets() as $bucket) {
                        $bucketName = $bucket->getName();
                        $attributeCode = str_replace('_bucket', '', $bucketName);

                        if ($attributeCode === 'category') continue;

                        if ($attributeCode === 'price') {
                            $attributeLabel = __('Price');
                            $attribute = null;
                        } else {
                            try {
                                $attribute = $this->_eavConfig->getAttribute('catalog_product', $attributeCode);
                                $attributeLabel = $attribute->getStoreLabel() ? $attribute->getStoreLabel() : $attribute->getFrontendLabel();
                            } catch (\Exception $e) {
                                $attributeLabel = null;
                                $attribute = null;
                            }
                        }

                        if (!$attributeLabel) {
                            $attributeLabel = ucfirst($attributeCode);
                        }

                        $options = [];
                        $isApplied = isset($paramsFromUrl[$attributeCode]); 
                        $currentValue = $isApplied ? $paramsFromUrl[$attributeCode] : null;
                        
                        $currentValuesArray = [];
                        if ($isApplied) {
                            $currentValuesArray = is_array($currentValue) ? $currentValue : explode(',', $currentValue);
                        }

                        $valueLabelMap = []; 

                        // 1. Filtros Disponibles (Estructura original como string simple)
                        foreach ($bucket->getValues() as $value) {
                            $valId = $value->getValue(); 
                            $metrics = $value->getMetrics();
                            $count = isset($metrics['count']) ? $metrics['count'] : 0;
                            
                            $optionLabel = $valId;
                            if ($attributeCode === 'price') {
                                $optionLabel = str_replace('_', '-', $valId);
                            } elseif (isset($attribute) && $attribute && $attribute->usesSource()) {
                                $optionText = $attribute->getSource()->getOptionText($valId);
                                if ($optionText) $optionLabel = $optionText;
                            }
                            
                            $valueLabelMap[$valId] = (string)$optionLabel;
                            $options[] = $this->createFilterOption($valId, (string)$optionLabel, $count);
                        }
                        
                        // 2. Filtros Aplicados (Implementación de Objeto Multi-idioma)
                        if ($isApplied) {
                            foreach ($currentValuesArray as $vid) {
                                $vLabel = isset($valueLabelMap[$vid]) ? $valueLabelMap[$vid] : $vid;

                                // Solo buscamos traducciones para atributos de tipo opción (no para el precio)
                                if ($attribute && $attribute->usesSource() && $attributeCode !== 'price') {
                                    try {
                                        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                                        $resource = $objectManager->get(\Magento\Framework\App\ResourceConnection::class);
                                        $connection = $resource->getConnection();
                                        $tableName = $resource->getTableName('eav_attribute_option_value');
                                        
                                        $select = $connection->select()
                                            ->from($tableName, ['store_id', 'value'])
                                            ->where('option_id = ?', (int)$vid);
                                        
                                        $translations = $connection->fetchAll($select);
                                        
                                        if (!empty($translations)) {
                                            $allTranslations = [];
                                            foreach ($translations as $t) {
                                                // Usamos store_id como clave string para forzar Objeto en JSON
                                                $allTranslations[(string)$t['store_id']] = (string)$t['value'];
                                            }
                                            $vLabel = (object)$allTranslations;
                                        }
                                    } catch (\Exception $e) {
                                        // Si falla, se queda con el label por defecto (string)
                                    }
                                }
                                
                                // Bypass del helper para evitar el array ["Azul"] y devolver el objeto directamente
                                $attrs_applied[] = [
                                    'param' => $attributeCode,
                                    'paramLabel' => (string)$attributeLabel,
                                    'value' => $vid,
                                    'valueLabel' => $vLabel
                                ];
                            }
                        }
                        
                        $attrs_available[] = $this->createFilterInfo($attributeCode, $attributeLabel, $options);
                    }
                }
            }
        }

        $result = [];
        $isSkuSearch = ($searchBy === "sku");
        
        foreach ($products as $item) {
            if ($item instanceof \Magento\Catalog\Api\Data\ProductInterface) {
                $result[] = $isSkuSearch ? $item->getSku() : $item->getId();
            } else {
                if ($isSkuSearch) {
                    $skuAttr = $item->getCustomAttribute('sku');
                    $result[] = ($skuAttr) ? $skuAttr->getValue() : $item->getId();
                } else {
                    $result[] = $item->getId();
                }
            }
        }
        
        if ($isSkuSearch && count($result) > 0 && is_numeric($result[0])) {
            $skuSearchBuilder = $this->_searchCriteriaBuilderFactory->create();
            $skuSearchBuilder->addFilter('entity_id', $result, 'in');
            $skuSearchBuilder->addSortOrder($field, $direction);
            
            $finalCollection = $this->_productRepository->getList($skuSearchBuilder->create());
            
            $finalSkus = [];
            foreach($finalCollection->getItems() as $p) {
                $finalSkus[$p->getId()] = $p->getSku();
            }
            
            $finalResult = [];
            foreach($result as $id) {
                if(isset($finalSkus[$id])) {
                    $finalResult[] = $finalSkus[$id];
                }
            }
            return $finalResult;
        }

        if (!$isSkuSearch && $searchOrder === 'entity_id') {
            if (strtoupper($searchDir) === 'DESC') {
                rsort($result);
            } else {
                sort($result);
            }
        }

        return $result;
    }
}