<?php
/**
 * Created by PhpStorm.
 * User: migue
 * Date: 20/06/2017
 * Time: 19:20
 */

namespace Oct8ne\Oct8ne\Helper\Search;

use \Magento\Framework\App\Helper\AbstractHelper;
use \Magento\Framework\App\Helper\Context;

/**
 * Devuelve una instancia de search para el motor de busqueda configurado
 * Class SearchFactory
 */
class SearchFactory extends AbstractHelper
{
    /**
     * @var Magento
     */
    protected $_magento;

    /**
     * @var Solr
     */
    protected $_solr;

    /**
     * @var Sli
     */
    protected $_sli;

    /**
     * @var Celebros
     */
    protected $_celebros;

    /**
     * @var Doofinder
     */
    protected $_doofinder;

    /**
     * SearchFactory constructor.
     *
     * @param Context $context
     * @param Magento $magento
     * @param Sli $sli
     * @param Solr $solr
     * @param Celebros $celebros
     * @param Doofinder $doofinder
     */
    public function __construct(
        Context $context,
        Magento $magento,
        Sli $sli,
        Solr $solr,
        Celebros $celebros,
        Doofinder $doofinder
    ) {
        $this->_celebros = $celebros;
        $this->_solr = $solr;
        $this->_sli = $sli;
        $this->_magento = $magento;
        $this->_doofinder = $doofinder;

        parent::__construct($context);
    }

    /**
     * Obtiene la instancia del motor de búsqueda
     *
     * @param string $engine
     * @return Celebros|Magento|Sli|Solr|Doofinder
     */
    public function getInstance($engine)
    {
        if ($engine == "Magento") {
            return $this->_magento;
        } elseif ($engine == "Celebros") {
            return $this->_celebros;
        } elseif ($engine == "Solr") {
            return $this->_solr;
        } elseif ($engine == "Sli") {
            return $this->_sli;
        } elseif ($engine == "Doofinder") {
            return $this->_doofinder;
        } else {
            return $this->_magento;
        }
    }
}
