<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Oct8ne\Oct8ne\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Config\Model\ResourceModel\Config;
use Magento\Store\Api\StoreRepositoryInterface;

class UpdateConfiguration implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * @var Config
     */
    protected $_resourceConfig;

    /**
     * @var StoreRepositoryInterface
     */
    protected $_store_repository;

    /**
     * Constructor
     *
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param ScopeConfigInterface $scopeConfig
     * @param Config $config
     * @param StoreRepositoryInterface $repository
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup, ScopeConfigInterface $scopeConfig, Config $config, StoreRepositoryInterface $repository)
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->_scopeConfig = $scopeConfig;
        $this->_resourceConfig = $config;
        $this->_store_repository = $repository;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        
        $email = $this->_scopeConfig->getValue("Oct8ne/user/email", "default", 0);

        if (isset($email) && !empty($email)) {
            $email = $this->_scopeConfig->getValue("Oct8ne/user/email", "default", 0);
            $token = $this->_scopeConfig->getValue("Oct8ne/user/token", "default", 0);
            $license = $this->_scopeConfig->getValue("Oct8ne/user/license", "default", 0);
            $server = $this->_scopeConfig->getValue("Oct8ne/user/server", "default", 0);
            $static = $this->_scopeConfig->getValue("Oct8ne/user/static", "default", 0);
            $position = $this->_scopeConfig->getValue("Oct8ne/user/position", "default", 0);
            $search_engine = $this->_scopeConfig->getValue("Oct8ne/user/search_engine", "default", 0);
            $hashid = $this->_scopeConfig->getValue("Oct8ne/doofinder/hashid", "default", 0);
            $apikey = $this->_scopeConfig->getValue("Oct8ne/doofinder/apikey", "default", 0);

            $additionalScript = $this->_scopeConfig->getValue("Oct8ne/additionalScript", "default", 0);
            $clientEvents = $this->_scopeConfig->getValue("Oct8ne/clientEvents", "default", 0);
            $clientTimer = $this->_scopeConfig->getValue("Oct8ne/clientTimer", "default", 0);

            $stores = $this->_store_repository->getList();
            foreach ($stores as $store) {
                $id = $store->getId();
                $this->_resourceConfig->saveConfig("Oct8ne/user/email/".$id, $email, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/token/".$id, $token, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/license/".$id, $license, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/server/".$id, $server, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/static/".$id, $static, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/position/".$id, $position, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/user/search_engine/".$id, $search_engine, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/doofinder/hashid/".$id, $hashid, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/doofinder/apikey/".$id, $apikey, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/additionalScript/".$id, $additionalScript, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/clientEvents/".$id, $clientEvents, "default", $id);
                $this->_resourceConfig->saveConfig("Oct8ne/clientTimer/".$id, $clientTimer, "default", $id);
            }

            $this->_resourceConfig->saveConfig("Oct8ne/user/ordersearch/0", 'incrementid', "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/email", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/token", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/license", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/server", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/static", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/position", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/user/search_engine", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/doofinder/hashid", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/doofinder/apikey", "default", 0);

            $this->_resourceConfig->deleteConfig("Oct8ne/additionalScript", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/clientEvents", "default", 0);
            $this->_resourceConfig->deleteConfig("Oct8ne/clientTimer", "default", 0);
        }
        
        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }
    
    /**
     * Get Version
     * @return string
     */
    public static function getVersion()
    {
        return '1.2.15';
    }
}
