<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once _PS_MODULE_DIR_ . 'oct8ne/classes/Oct8neContext.php';

class Oct8neOct8neCustomerConfigModuleFrontController extends ModuleFrontController
{
    public function init()
    {
        parent::init();

        $valid = $this->IsValidIp();

        if (!$valid) {
            Tools::redirect(_PS_BASE_URL_);
            exit;
        }
    }

    private function getContext()
    {
        if (isset($this->context)) {
            return $this->context;
        }

        return Oct8neContext::get($this);
    }

    public function initContent()
    {
        parent::initContent();

        $orderDetailsName = $this->module->getORDERDETAILSBYNAME();
        $searchenginename = $this->module->getSEARCHENGINENAME();
        $urltypename = $this->module->getURLIMGTYPENAME();
        $positionloadName = $this->module->getPOSITIONLOADNAME();
        $urlEmpathyBrokerName = $this->module->getURLEMPATHYBORKER();

        $urlMotiveSearchName = $this->module->getURLMOTIVESEARCH();
        $tenantMotiveSearchName = $this->module->getTENANTMOTIVESEARCH();

        $searchengine = Configuration::get($searchenginename);
        $urltype = Configuration::get($urltypename);
        $positionload = Configuration::get($positionloadName);
        $filterByField = Configuration::get($orderDetailsName);
        $urlEmpathyBroker = Configuration::get($urlEmpathyBrokerName);

        $urlMotiveSearch = Configuration::get($urlMotiveSearchName);
        $tenantMotiveSearch = Configuration::get($tenantMotiveSearchName);

        if (!$filterByField) {
            $filterByField = 'reference';
        }

        $submit = $this->context->link->getModuleLink('oct8ne', 'oct8necustomerconfig');

        $serchengines = $this->module->getDetectedSearchEngines();

        $this->getContext()->smarty->assign([
            'POSITION_LOAD_NAME' => $positionloadName,
            'SEARCH_ENGINE_NAME' => $searchenginename,
            'URL_IMG_TYPE_NAME' => $urltypename,
            'SEARCH_ENGINES' => $serchengines,
            'POSITION_LOAD' => $positionload,
            'SEARCH_ENGINE' => $searchengine,
            'URL_IMG_TYPE' => $urltype,
            'SUBMIT' => $submit,
            'ORDER_DETAILS_BY_VALUE' => $filterByField,
            'ORDER_DETAILS_BY_NAME' => $orderDetailsName,
            'URL_API_EMPATHYBROKER_NAME' => $urlEmpathyBrokerName,
            'URL_API_EMPATHYBROKER_VALUE' => $urlEmpathyBroker,
            'URL_API_MOTIVESEARCH_NAME' => $urlMotiveSearchName,
            'URL_API_MOTIVESEARCH_VALUE' => $urlMotiveSearch,
            'TENANT_MOTIVESEARCH_NAME' => $tenantMotiveSearchName,
            'TENANT_MOTIVESEARCH_VALUE' => $tenantMotiveSearch,
        ]);

        if (version_compare(_PS_VERSION_, '1.7.0.0', '<')) {
            $this->setTemplate('customerconfig.tpl');
        } else {
            $this->setTemplate('module:oct8ne/views/templates/front/customerconfig7.tpl');
        }
    }

    public function postProcess()
    {
        $this->module->postProcess();
    }

    private function IsValidIp()
    {
        if ($this->CheckIpFromHeader('REMOTE_ADDR')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_X_FORWARDED_FOR')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_CLIENT_IP')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_X_FORWARDED')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_X_CLUSTER_CLIENT_IP')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_FORWARDED_FOR')) {
            return true;
        }

        if ($this->CheckIpFromHeader('HTTP_FORWARDED')) {
            return true;
        }

        return false;
    }

    private function CheckIpFromHeader($header)
    {
        if (!isset($_SERVER[$header])) {
            return false;
        }

        $ip = $_SERVER[$header];

        return $ip == '::1' || $ip == '151.252.119.166' || $ip == '80.23.23.23' || $ip == '80.24.24.24' || $ip == '138.91.153.74' || $ip == '168.62.164.114' || $ip == '80.28.120.5' || $ip == '127.0.0.1' || $ip == '52.174.192.174' || $ip = '88.16.136.16';
    }
}
