<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';
require_once _PS_MODULE_DIR_ . 'oct8ne/classes/Oct8neContext.php';

/**
 * Implementacion especifica de empathybroker
 * Class OctEmpathybrokerSearch
 */
class OctEmpathybrokerSearch extends AbstractSearchEngine
{
    private function getContext()
    {
        if (isset($this->context)) {
            return $this->context;
        }

        return Oct8neContext::get($this);
    }

    public function getEngineInfo()
    {
        $info = [
            'engine' => 'EmpathyBrokerSearch',
            'languages' => [],
        ];

        $context = $this->getContext();
        $id_shop = (int) $context->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        foreach ($languages as $lang) {
            $isoCode = $lang['language_code'];
            $legacyIso = $lang['iso_code'];

            $endpoint = Configuration::get(Oct8ne::$URL_API_EMPATHYBROKER . '_' . $isoCode);

            if (empty($endpoint)) {
                $endpoint = Configuration::get(Oct8ne::$URL_API_EMPATHYBROKER);
            }

            $info['languages'][$isoCode] = [
                'endpoint' => $endpoint,
            ];
        }

        return $info;
    }

    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        $this->context = $this->getContext();

        $iso_code = Language::getIsoById($language);
        $isoCode = $this->context->language->language_code;

        $curl = curl_init();
        $endpoint = Configuration::get(Oct8ne::$URL_API_EMPATHYBROKER . '_' . $isoCode);

        if (empty($endpoint)) {
            $endpoint = Configuration::get(Oct8ne::$URL_API_EMPATHYBROKER);
        }

        $endpointX = strpos($endpoint, 'searchX?') !== false;

        $search = urlencode($search);
        // Get url
        $url = $endpoint . $search . '&lang=' . $iso_code;

        // Get start and row parameter. Set them if there are not found, otherwise let it be
        $parts = parse_url($url);
        parse_str($parts['query'], $query);

        if (!isset($query['start'])) {
            $url = $url . '&start=' . ($page - 1);
        }

        if (!isset($query['rows'])) {
            $url = $url . '&rows=' . $pageSize;
        }

        // Execute curl
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $output = curl_exec($curl);

        // Check the return value of curl_exec()
        if ($output === false) {
            throw new Exception(curl_error($curl), curl_errno($curl));
        }
        curl_close($curl);

        if (version_compare(_PS_VERSION_, '8.0', '<')) {
            $result = Tools::jsonDecode($output);
        } else {
            $result = json_decode($output);
        }

        $total = (int) $result->content->numFound;
        $products = [];

        if (is_array($result->content->docs) && count($result->content->docs) > 0) {
            foreach ($result->content->docs as $item) {
                if (!$endpointX) {
                    $query = new DbQuery();
                    $query->select('p.id_product');
                    $query->from('product', 'p');
                    $query->where('p.reference = \'' . pSQL((int) $item->id) . '\'');

                    $id_product = (int) Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query);

                    if (!empty($id_product)) {
                        $product = [
                            'id_product' => $id_product,
                        ];

                        $products[] = $product;
                    }
                } else {
                    if (!empty($item->id)) {
                        $product = [
                            'id_product' => $item->id,
                        ];

                        $products[] = $product;
                    }
                }
            }
        }

        return [
            'total' => $total,
            'result' => $products,
        ];
    }
}
