<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';

/**
 * Implementacion especifica de doofinder
 * Class OctDoofinderSearch
 */
class OctJolieSearch extends AbstractSearchEngine
{
    public function getEngineInfo()
    {
        $info = [
            'engine' => 'JolieSearch',
            'languages' => [],
        ];

        return $info;
    }

    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        $context = $this->context;
        // Cargar jolisearch.
        $jolieSearch = Module::getInstanceByName('AmbJoliSearch');

        if (!$jolieSearch) {
            $jolieSearch = Module::getInstanceByName('ambjolisearch');
        }

        $searcher = new AmbSearch(true, $context, $jolieSearch);
        $searcher->search($language, $search, $page, $pageSize, $orderBy, $dir, false, false);

        $products = $searcher->getResults();
        $total = $searcher->getTotal();

        return [
            'total' => $total,
            'result' => $products,
        ];
    }
}
