<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';
require_once _PS_MODULE_DIR_ . 'oct8ne/classes/Oct8neContext.php';

/**
 * Implementacion especifica de doofinder
 * Class OctDoofinderSearch
 */
class OctMotiveSearch extends AbstractSearchEngine
{
    private function getContext()
    {
        if (isset($this->context)) {
            return $this->context;
        }

        return Oct8neContext::get($this);
    }

    public function getEngineInfo()
    {
        $info = [
            'engine' => 'MotiveSearch',
            'languages' => [],
        ];

        $context = $this->getContext();
        $id_shop = (int) $context->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        foreach ($languages as $lang) {
            $isoCode = $lang['language_code'];
            $legacyIso = $lang['iso_code'];

            $endpoint = Configuration::get(Oct8ne::$URL_API_MOTIVESEARCH . '_' . $isoCode);
            $tenantId = Configuration::get(Oct8ne::$TENANT_MOTIVESEARCH . '_' . $isoCode);

            if (empty($endpoint)) {
                $endpoint = Configuration::get(Oct8ne::$URL_API_MOTIVESEARCH);
            }

            if (empty($tenantId)) {
                $tenantId = Configuration::get(Oct8ne::$TENANT_MOTIVESEARCH);
            }

            $isConfigured = !empty($endpoint) && !empty($tenantId);

            $info['languages'][$isoCode] = [
                'iso' => $legacyIso,
                'configured' => $isConfigured,
                'endpoint' => $endpoint,
                'tenant_id' => $this->maskValue($tenantId),
            ];
        }

        return $info;
    }

    private function maskValue($value)
    {
        if (empty($value)) {
            return '';
        }

        if (strlen($value) <= 10) {
            return str_repeat('X', strlen($value));
        }

        return substr($value, 0, 10) . str_repeat('X', strlen($value) - 10);
    }

    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        $this->context = $this->getContext();

        $searchIdInDB = false;
        $curl = curl_init();
        $isoCode = $this->context->language->language_code;

        $endpoint = Configuration::get(Oct8ne::$URL_API_MOTIVESEARCH . '_' . $isoCode);
        $tenantId = Configuration::get(Oct8ne::$TENANT_MOTIVESEARCH . '_' . $isoCode);

        // Obtener valores genéricos como respaldo si no existen los específicos por idioma
        if (empty($endpoint)) {
            $endpoint = Configuration::get(Oct8ne::$URL_API_MOTIVESEARCH);
        }

        if (empty($tenantId)) {
            $tenantId = Configuration::get(Oct8ne::$TENANT_MOTIVESEARCH);
        }

        $search = urlencode($search);
        // Get url
        $url = $endpoint . '?query=' . $search;

        // Get start and row parameter. Set them if there are not found, otherwise let it be
        $parts = parse_url($url);
        parse_str($parts['query'], $query);

        if (!isset($query['start'])) {
            $url = $url . '&start=' . ($page - 1);
        }

        if (!isset($query['rows'])) {
            $url = $url . '&rows=96';
        }

        $headers = ['x-engine-id: ' . $tenantId];

        // Execute curl
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $output = curl_exec($curl);

        // Check the return value of curl_exec()
        if ($output === false) {
            throw new Exception(curl_error($curl), curl_errno($curl));
        }
        curl_close($curl);

        if (version_compare(_PS_VERSION_, '8.0', '<')) {
            $result = Tools::jsonDecode($output);
        } else {
            $result = json_decode($output);
        }

        $total = (int) $result->pagination->total;
        $products = [];

        if (is_array($result->hits->docs) && count($result->hits->docs) > 0) {
            foreach ($result->hits->docs as $item) {
                if (!empty($item->id)) {
                    $product = [
                        'id_product' => $item->id,
                    ];

                    $products[] = $product;
                }
            }
        }

        if ($total == 0) {
            if (is_array($result)) {
                $total = (int) $result['pagination']['total'];
                $products = [];

                if (is_array($result['hits']['docs']) && count($result['hits']['docs']) > 0) {
                    foreach ($result['hits']['docs'] as $item) {
                        if (!empty($item['id'])) {
                            $product = [
                                'id_product' => $item['id'],
                            ];

                            $products[] = $product;
                        }
                    }
                }
            }
        }

        return [
            'total' => $total,
            'result' => $products,
        ];
    }
}
