<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';

/**
 * Implementacion especifica de doofinder
 * Class OctDoofinderSearch
 */
class OctApiSearchSearch extends AbstractSearchEngine
{
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    private function getContext()
    {
        return $this->context;
    }

    public function getEngineInfo()
    {
        $info = [
            'engine' => 'ApiSearch',
            'languages' => [],
        ];

        $id_shop = (int) $this->getContext()->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        foreach ($languages as $lang) {
            $isoCode = $lang['language_code'];

            $indexId = Configuration::get(Oct8ne::$INDEXID_APISEARCH . '_' . $isoCode);
            $site = Configuration::get(Oct8ne::$SITE_APISEARCH . '_' . $isoCode);
            $endpoint = Configuration::get(Oct8ne::$ENDPOINT_APISEARCH . '_' . $isoCode);

            // Fallbacks generales
            if (empty($endpoint)) {
                $endpoint = Configuration::get(Oct8ne::$ENDPOINT_APISEARCH);
            }

            if (empty($indexId)) {
                $indexId = Configuration::get(Oct8ne::$INDEXID_APISEARCH);
            }

            if (empty($site)) {
                $site = Configuration::get(Oct8ne::$SITE_APISEARCH);
            }

            // Enmascarar valores
            $maskedIndexId = $this->maskValue($indexId);
            $maskedSite = $this->maskValue($site);

            $info['languages'][$isoCode] = [
                'endpoint' => $endpoint,
                'index_id' => $maskedIndexId,
                'site' => $maskedSite,
            ];
        }

        return $info;
    }

    private function maskValue($value)
    {
        if (strlen($value) <= 8) {
            return str_repeat('X', strlen($value));
        }

        return substr($value, 0, 8) . str_repeat('X', strlen($value) - 8);
    }

    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        $this->context = $this->getContext();

        $iso_code = Language::getIsoById($language);
        $isoCode = $this->context->language->language_code;

        $curl = curl_init();

        $indexId = Configuration::get(Oct8ne::$INDEXID_APISEARCH . '_' . $isoCode);
        $site = Configuration::get(Oct8ne::$SITE_APISEARCH . '_' . $isoCode);
        $endpoint = Configuration::get(Oct8ne::$ENDPOINT_APISEARCH . '_' . $isoCode);

        if (empty($endpoint)) {
            $endpoint = Configuration::get(Oct8ne::$ENDPOINT_APISEARCH);
        }

        if (empty($indexId)) {
            $indexId = Configuration::get(Oct8ne::$INDEXID_APISEARCH);
        }

        if (empty($site)) {
            $site = Configuration::get(Oct8ne::$SITE_APISEARCH);
        }

        if (strpos($site, '-') !== false) {
            $sitePart = explode('-', $site);
            $site = $sitePart[0];
        }

        $search = urlencode($search);

        $endpoint = str_replace('{index_id}', $indexId, $endpoint);
        $endpoint = str_replace('{site}', $site . '-' . strtoupper($iso_code), $endpoint);
        $endpoint = str_replace('{language}', $iso_code, $endpoint);
        $endpoint = str_replace('{page}', $page, $endpoint);
        $endpoint = str_replace('{size}', $pageSize, $endpoint);
        $endpoint = str_replace('{query}', $search, $endpoint);

        // Get url
        $url = $endpoint;

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 1);

        $output = curl_exec($curl);

        // Check the return value of curl_exec()
        if ($output === false) {
            throw new Exception(curl_error($curl), curl_errno($curl));
        }
        curl_close($curl);

        if (version_compare(_PS_VERSION_, '8.0', '<')) {
            $result = Tools::jsonDecode($output);
        } else {
            $result = json_decode($output);
        }

        $total = (int) $result->total_hits;
        $products = [];

        if (is_array($result->ids) && count($result->ids) > 0) {
            foreach ($result->ids as $item) {
                $products[] = [
                    'id_product' => $item,
                ];
            }
        }

        return [
            'total' => $total,
            'result' => $products,
        ];
    }
}
