<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';

/**
 * Implementacion especifica de doofinder
 * Class OctDoofinderSearch
 */
class OctDoofinderSearch extends AbstractSearchEngine
{
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    private function getContext()
    {
        return $this->context;
    }

    public function getEngineInfo()
    {
        $info = [
            'engine' => 'DoofinderSearch',
            'languages' => [],
        ];

        $context = $this->getContext();
        $id_shop = (int) $context->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        foreach ($languages as $lang) {
            $isoCode = $lang['language_code'];

            $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID . '_' . $isoCode);
            $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY . '_' . $isoCode);
            $searchZone = Configuration::get(Oct8ne::$DOOFINDER_SEARCH_ZONE . '_' . $isoCode);
            $query_name = Configuration::get(Oct8ne::$DOOFINDER_QUERY_NAME . '_' . $isoCode);

            // Fallbacks
            if (empty($hashId)) {
                $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID);
            }

            if (empty($apiKey)) {
                $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY);
            }

            if (empty($searchZone)) {
                $searchZone = Configuration::get(Oct8ne::$DOOFINDER_SEARCH_ZONE);
            }

            if (empty($query_name)) {
                $query_name = Configuration::get(Oct8ne::$DOOFINDER_QUERY_NAME);
            }

            $info['languages'][$isoCode] = [
                'hash_id' => $this->maskValue($hashId),
                'api_key' => $this->maskValue($apiKey),
                'search_zone' => $searchZone,
                'query_name' => $query_name,
            ];
        }

        return $info;
    }

    private function maskValue($value)
    {
        if (empty($value)) {
            return '';
        }

        if (strlen($value) <= 10) {
            return str_repeat('X', strlen($value));
        }

        return substr($value, 0, 10) . str_repeat('X', strlen($value) - 10);
    }

    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        $this->context = $this->getContext();
        // Cargar doofinder.
        $isoCode = strtoupper($this->context->language->iso_code);
        $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID . '_' . $isoCode);
        $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY . '_' . $isoCode);

        if (empty($hashId)) {
            $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID);
        }

        if (empty($apiKey)) {
            $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY);
        }

        if (!isset($apiKey) && !isset($hashId)) {
            $doofinder = Module::getInstanceByName('doofinder');
            $aux = $doofinder->searchOnApi($search, $page, $pageSize);

            return $aux;
        } else {
            return $this->executeDoofinderSearchQuery($search, null, $orderBy, $dir, $page, $pageSize);
        }
    }

    public function executeDoofinderSearchQuery($searchTerm, $searchCategories, $searchOrder, $searchDir, $page, $pageSize, $includeFacets = true, $method = null)
    {
        $this->context = $this->getContext();

        $isoCode = $this->context->language->language_code;

        $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID . '_' . $isoCode);
        $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY . '_' . $isoCode);
        $searchZone = Configuration::get(Oct8ne::$DOOFINDER_SEARCH_ZONE . '_' . $isoCode);
        $query_name = Configuration::get(Oct8ne::$DOOFINDER_QUERY_NAME . '_' . $isoCode);
        $indices = Configuration::get(Oct8ne::$DOOFINDER_INDICES . '_' . $isoCode);
        $idPropertyConf = Configuration::get(Oct8ne::$DOOFINDER_PRODUCTID_PROPERTY . '_' . $isoCode);

        if (empty($hashId)) {
            $hashId = Configuration::get(Oct8ne::$DOOFINDER_HASH_ID);
        }

        if (empty($apiKey)) {
            $apiKey = Configuration::get(Oct8ne::$DOOFINDER_API_KEY);
        }

        if (empty($searchZone)) {
            $searchZone = Configuration::get(Oct8ne::$DOOFINDER_SEARCH_ZONE);
        }

        if (empty($query_name)) {
            $query_name = Configuration::get(Oct8ne::$DOOFINDER_QUERY_NAME);
        }

        if (empty($indices)) {
            $indices = Configuration::get(Oct8ne::$DOOFINDER_INDICES);
        }

        if (empty($idPropertyConf)) {
            $idPropertyConf = Configuration::get(Oct8ne::$DOOFINDER_PRODUCTID_PROPERTY);
        }

        if (!isset($idPropertyConf) || $idPropertyConf == '') {
            $idPropertyConf = 'id';
        }

        if (!isset($searchZone)) {
            $searchZone = 'eu1';
        }

        if (!isset($query_name)) {
            $query_name = 'match_and';
        }

        $url = 'https://##zone##-search.doofinder.com/6/' . $hashId . '/_search';
        $host = str_replace('##zone##', $searchZone, $url);

        $sortLabel = '_score';

        if ($sortLabel != '_score' || ($sortLabel == '_score' && $searchDir != 'desc')) {
            $queryParams = [
                'rpp' => $pageSize, // response results will be formatted as native JSON objects
                'page' => $page,
                'query' => $searchTerm,
                'sort[' . $sortLabel . ']' => $searchDir,
            ];
        } else {
            $queryParams = [
                'rpp' => $pageSize, // response results will be formatted as native JSON objects
                'page' => $page,
                'query' => $searchTerm,
            ];
        }

        if ($query_name != 'none') {
            $queryParams['query_name'] = $query_name;
        }

        if (isset($indices) && !is_null($indices) && $indices != '') {
            $pos = 0;
            $multipleIndices = explode(',', $indices);
            foreach ($multipleIndices as $index) {
                $queryParams['indices[' . $pos . ']'] = $index;
                $pos = $pos + 1;
            }
        }

        $query = $host . '?' . http_build_query($queryParams);
        $request = curl_init($query);

        curl_setopt($request, CURLOPT_CUSTOMREQUEST, 'GET');
        // curl_setopt($request, CURLOPT_POST, 1);
        curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);

        $headers = [
            'Authorization: Token ' . $apiKey,
            'Content-Type: application/json',
            'Expect:', // Fixes the HTTP/1.1 417 Expectation Failed error
        ];

        curl_setopt($request, CURLOPT_HTTPHEADER, $headers);

        $response = curl_exec($request);
        $err = curl_error($request);
        $result = null;

        if (is_null($err) || $err == '') {
            $result = json_decode($response, true);

            if (is_null($result)) {
                curl_close($request);

                return [
                    'total' => 0,
                    'result' => [],
                ];
            }
        } else {
            curl_close($request);

            return [
                'total' => 0,
                'result' => [],
            ];
        }
        curl_close($request);

        if (!is_null($result)) {
            $products = [];
            foreach ($result['results'] as $item) {
                // $idProperty contains ","
                $idProperty = explode(',', $idPropertyConf);
                foreach ($idProperty as $key => $value) {
                    $value = trim($value);

                    if (isset($item[$value]) && $item[$value] != '') {
                        $id = $item[$value];

                        if (strpos($id, 'product@') === 0) {
                            $id = substr($id, strlen('product@'));
                        }

                        if (strpos($id, 'products@') === 0) {
                            $id = substr($id, strlen('products@'));
                        }

                        $product = [
                            'id_product' => $id,
                        ];
                        $products[] = $product;
                        break;
                    }
                }
            }
            
            return [
                'total' => $result['total'],
                'result' => $products,
            ];
        }

        return [
            'total' => 0,
            'result' => [],
        ];
    }
}
