<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
require_once dirname(__FILE__) . '/AbstractSearchEngine.php';

class OctInternalSearch extends AbstractSearchEngine
{
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    public function getEngineInfo()
    {
        $info = [
            'engine' => 'InternalSearch',
            'languages' => [],
        ];

        return $info;
    }

    // realiza la busqueda a partir del motor de busqueda por defecto de prestashop
    public function doSearch($language, $search, $page, $pageSize, $orderBy, $dir)
    {
        // buscar
        // subir
        $aux = Search::find($language, $search, $page, $pageSize, $orderBy, $dir);

        if ($orderBy == 'price') {
            Tools::orderbyPrice($aux['result'], $dir);
        }

        return $aux;
    }
}
