<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class Oct8ne extends Module
{
    public $updateSource;
    private static $EMAIL_CK = 'OCT_EMAIL';

    private static $PASSWORD_CK = 'OCT_PASS';

    private static $API_TOKEN_CK = 'OCT_API_TOKEN';

    private static $LICENSE_ID_CK = 'OCT_LICID';

    public static $SEARCH_ENGINE = 'OCT_SEARCH_ENGINE';

    public static $POSITION_LOAD = 'OCT_POSITION_LOAD';

    public static $URL_IMG_TYPE = 'OCT_URL_IMG_TYPE';

    public static $SERVER_OC_CK = 'OCT_SERVER';

    public static $URL_STATIC_OC_CK = 'OCT_URL_STATIC';

    public static $URL_API_EMPATHYBROKER = 'OCT_URL_API_EMPATHYBROKER';

    public static $ORDER_DETAILS_BY = 'OTC_ORDER_DETAILS_BY';

    public static $CLIENT_EXTRA_SCRIPT = 'OCT_CLIENT_EXTRA_SCRIPT';

    public static $SCRIPT_LOAD_EVENTS = 'OCT_CLIENT_EVENTS';

    public static $SCRIPT_LOAD_TIMER = 'OCT_CLIENT_TIMER';

    public static $UPDATE_NOTIFIER = 'OCT_UPDATE_NOTIFIER';

    public static $URL_API_APISEARCH = 'OCT_URL_API_APISEARCH';

    public static $TENANT_APISEARCH = 'OCT_TENANT_APISEARCH';

    public static $ENDPOINT_APISEARCH = 'OCT_ENDPOINT_APISEARCH';

    public static $APPID_APISEARCH = 'OCT_APPID_APISEARCH';

    public static $INDEXID_APISEARCH = 'OCT_INDEXID_APISEARCH';

    public static $TOKEN_APISEARCH = 'OCT_TOKEN_APISEARCH';

    public static $SITE_APISEARCH = 'OCT_SITE_APISEARCH';

    // public static $LANG_APISEARCH = "OCT_LANG_APISEARCH";
    public static $DEFAULT_ENDPOINT_APISEARCH = 'https://apisearch.cloud/{index_id}/query.json?site={site}&language={language}&page={page}&size={size}&q={query}';

    public static $URL_API_MOTIVESEARCH = 'OCT_URL_API_MOTIVESEARCH';

    public static $TENANT_MOTIVESEARCH = 'OCT_TENANT_MOTIVESEARCH';

    public static $DOOFINDER_API_KEY = 'OCT_DOOFINDER_API_KEY';

    public static $DOOFINDER_HASH_ID = 'OCT_DOOFINDER_HASH_ID';

    public static $DOOFINDER_SEARCH_ZONE = 'OCT_DOOFINDER_SEARCH_ZONE';

    public static $DOOFINDER_QUERY_NAME = 'OCT_DOOFINDER_QUERY_NAME';

    public static $DOOFINDER_INDICES = 'OCT_DOOFINDER_INDICES';

    public static $DOOFINDER_PRODUCTID_PROPERTY = 'OCT_DOOFINDER_PRODUCTID_PROPERTY';

    public static $EMPATHY_API_ENDPOINT = 'OCT_EMPATHY_API_ENDPOINT';
    public static $EMPATHY_SITE_ID = 'OCT_EMPATHY_SITE_ID';
    public static $EMPATHY_INSTANCE = 'OCT_EMPATHY_INSTANCE';
    public static $EMPATHY_LANG = 'OCT_EMPATHY_LANG';
    public static $EMPATHY_STORE = 'OCT_EMPATHY_STORE';
    public static $KIMERA_API_ENDPOINT = 'OCT_KIMERA_API_ENDPOINT';
    public static $KIMERA_STORE_ID = 'OCT_KIMERA_STORE_ID';
    public static $KIMERA_API_KEY = 'OCT_KIMERA_API_KEY';

    public static $KIMERA_LANG = 'OCT_KIMERA_LANG';
    public static $KIMERA_PASSWORD = 'OCT_KIMERA_PASSWORD';
    public static $KIMERA_INPUT_MODE = 'OCT_KIMERA_INPUT_MODE';

    public static $INSTANCE_EMPATHY = 'OCT8NE_INSTANCE_EMPATHY';
    public static $SITE_EMPATHY = 'OCT8NE_SITE_EMPATHY';

    private static $error_file_name = 'error_log.log';

    private static $class_folder = 'classes/';

    private static $lib_folder = 'lib/';

    /**
     * añade al log la información sobre una excepcion
     *
     * @param Exception $ex
     */
    public function logException($ex)
    {
        $this->logError($ex->getFile() . ':' . $ex->getLine() . ' -> ' . $ex->getMessage());
    }

    private function getContext()
    {
        return $this->context;
    }

    /**
     * Añade la información indicada al log de excepciones
     *
     * @param string $msg
     */
    public function logError($msg)
    {
        // Recogemos el nombre del archivo local y general
        $files_log = [$this->getLocalPath() . self::$error_file_name, _PS_ROOT_DIR_ . '/log/' . date('Ymd') . '_exception.log'];
        $logger = new FileLogger();
        // Guardamos el log
        foreach ($files_log as $file_log) {
            $logger->setFilename($file_log);
            $logger->logError($msg);
        }
    }

    /**
     * Carga la clase solicitada
     *
     * @param string $class_name Nombre de la clase
     *
     * @throws Exception Si el archivo no existe
     */
    public function loadClass($class_name)
    {
        // Componemos el path
        $path = $this->getLocalPath() . self::$class_folder . $class_name . '.php';

        // Comprobamos que exista
        if (!file_exists($path)) {
            throw new Exception('This class can not be loaded: ' . $class_name);
        }
        // La incluimos
        require_once $path;
    }

    /**
     * Carga la libreria solicitada
     *
     * @param string $class_name Nombre de la clase
     *
     * @throws Exception Si el archivo no existe
     */
    public function loadLibrary($class_name, $internal_path = '')
    {
        if (!empty($internal_path)) {
            $internal_path .= '/';
        }
        // Componemos el path
        $path = $this->getLocalPath() . self::$lib_folder . $internal_path . $class_name . '.php';

        // Comprobamos que exista
        if (!file_exists($path)) {
            throw new Exception('This library can not be loaded: ' . $class_name);
        }
        // La incluimos
        require_once $path;
    }

    /**
     * Remove hthp: or https:
     */
    public static function removeHttProtocol($string)
    {
        $string = str_replace('https:', '', $string);
        $string = str_replace('http:', '', $string);

        return $string;
    }

    /**
     * @return string
     */
    public function getTENANTMOTIVESEARCH()
    {
        return self::$TENANT_MOTIVESEARCH;
    }

    /**
     * @return string
     */
    public function getURLMOTIVESEARCH()
    {
        return self::$URL_API_MOTIVESEARCH;
    }

    /**
     * @return string
     */
    public function getENDPOINTAPISEARCH()
    {
        return self::$ENDPOINT_APISEARCH;
    }

    /**
     * @return string
     */
    public function getSITEAPISEARCH()
    {
        return self::$SITE_APISEARCH;
    }

    /**
     * @return string
     */
    public function getTOKENAPISEARCH()
    {
        return self::$TOKEN_APISEARCH;
    }

    /**
     * @return string
     */
    public function getINDEXIDAPISEARCH()
    {
        return self::$INDEXID_APISEARCH;
    }

    /**
     * @return string
     */
    public function getAPPIDAPISEARCH()
    {
        return self::$APPID_APISEARCH;
    }

    /**
     * @return string
     */
    public function getURLEMPATHYBORKER()
    {
        return self::$URL_API_EMPATHYBROKER;
    }

    /**
     * @return string
     */
    public function getDOOFINDERAPIKEY()
    {
        return self::$DOOFINDER_API_KEY;
    }

    /**
     * @return string
     */
    public function getDOOFINDERSEARCHZONE()
    {
        return self::$DOOFINDER_SEARCH_ZONE;
    }

    /**
     * @return string
     */
    public function getDOOFINDERQUERYNAME()
    {
        return self::$DOOFINDER_QUERY_NAME;
    }

    /**
     * @return string
     */
    public function getDOOFINDERINDICES()
    {
        return self::$DOOFINDER_INDICES;
    }

    /**
     * @return string
     */
    public function getDOOFINDERPRODUCTIDPROPERTY()
    {
        return self::$DOOFINDER_PRODUCTID_PROPERTY;
    }

    /**
     * @return string
     */
    public function getDOOFINDERHASHID()
    {
        return self::$DOOFINDER_HASH_ID;
    }

    /**
     * @return string
     */
    public function getTENANTAPISEARCH()
    {
        return self::$TENANT_APISEARCH;
    }

    /**
     * @return string
     */
    public function getURLAPISEARCH()
    {
        return self::$URL_API_APISEARCH;
    }

    /**
     * @return string
     */
    public function getORDERDETAILSBYNAME()
    {
        return self::$ORDER_DETAILS_BY;
    }

    /**
     * @return string
     */
    public function getSEARCHENGINENAME()
    {
        return self::$SEARCH_ENGINE;
    }

    /**
     * @return string
     */
    public function getPOSITIONLOADNAME()
    {
        return self::$POSITION_LOAD;
    }

    /**
     * @return string
     */
    public function getURLIMGTYPENAME()
    {
        return self::$URL_IMG_TYPE;
    }

    /**
     * Oct8ne constructor.
     * Variables de configuracion del modulo
     */
    public function __construct()
    {
        $this->name = 'oct8ne';
        $this->tab = 'front_office_features';
        $this->version = '1.3.0';
        $this->author = 'Oct8ne';
        $this->need_instance = 0;
        $this->module_key = '75e2a2709ae2d368b085faf7c049ac4e';
        $this->ps_versions_compliancy = [
            'min' => '1.7.0.0',
            'max' => '9.0.99',
        ];
        $this->updateSource = self::isZipVersion() ? 'Oct8ne.com' : 'Addons';

        /*
         * Set $this->bootstrap to true if your module is compliant with bootstrap (PrestaShop 1.6)
         */
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Oct8ne');
        $this->description = $this->l('Oct8ne module connector for Prestashop');

        $this->confirmUninstall = $this->l('All data will be deleted ¿continue?');
    }

    /**
     * Instalacion
     *
     * @param bool $full : completa o parcial
     *
     * @return bool
     */
    public function install($full = true)
    {
        try {
            $correct = parent::install();

            if ($full) {
                $tryhtac = $this->setHtaccessRules();

                if (!$tryhtac) {
                    throw new Exception('htaccess not found');
                }
                // Configuración
                Configuration::updateValue(Oct8ne::$POSITION_LOAD, 1);
                Configuration::updateValue(Oct8ne::$URL_IMG_TYPE, 1);
                Configuration::updateValue(Oct8ne::$SCRIPT_LOAD_EVENTS, 'DISABLED');
                Configuration::updateValue(Oct8ne::$SCRIPT_LOAD_TIMER, 0);
                Configuration::updateValue(Oct8ne::$UPDATE_NOTIFIER, 1);

                Configuration::updateValue(
                    Oct8ne::$URL_API_EMPATHYBROKER,
                    'https://api.empathybroker.com/search/v1/query/INSTANCE_ID/search?q='
                );

                Configuration::updateValue(
                    Oct8ne::$URL_API_APISEARCH,
                    'https://search-applications-0.api.motive.co/search'
                );

                Configuration::updateValue(
                    Oct8ne::$URL_API_MOTIVESEARCH,
                    'https://search.api.motive.co/search'
                );
            }
            // Ganchos
            $correct = $correct && $this->registerHook('displayFooter') && $this->registerHook('displayHeader') && $this->registerHook('displayOrderConfirmation') && $this->registerHook('displayBackOfficeHeader');

            return $correct;
        } catch (Exception $ex) {
            $this->logException($ex);

            return false;
        }
    }

    /**
     * Desinstalacion
     *
     * @param bool $full : completa o parcial
     *
     * @return bool
     */
    public function uninstall($full = true)
    {
        if ($full) {
            include dirname(__FILE__) . '/sql/uninstall.php';
            $this->removeHtaccessRules();
            Configuration::deleteByName(self::$EMAIL_CK);
            Configuration::deleteByName(self::$API_TOKEN_CK);
            Configuration::deleteByName(self::$LICENSE_ID_CK);

            Configuration::deleteByName(self::$SEARCH_ENGINE);
            Configuration::deleteByName(self::$POSITION_LOAD);
            Configuration::deleteByName(self::$URL_IMG_TYPE);
            Configuration::deleteByName(self::$URL_API_EMPATHYBROKER);
            Configuration::deleteByName(self::$CLIENT_EXTRA_SCRIPT);
            Configuration::deleteByName(self::$SCRIPT_LOAD_EVENTS);
            Configuration::deleteByName(self::$SCRIPT_LOAD_TIMER);
            Configuration::deleteByName(self::$UPDATE_NOTIFIER);

            Configuration::deleteByName(self::$TENANT_APISEARCH);
            Configuration::deleteByName(self::$TENANT_MOTIVESEARCH);
        }

        return parent::uninstall();
    }

    /**
     * Resetear modulo
     *
     * @return bool
     */
    public function reset()
    {
        if (!$this->uninstall(false)) {
            return false;
        }

        if (!$this->install(false)) {
            return false;
        }

        return true;
    }

    /**
     * Vista configuracion del modulo
     */
    public function getContent()
    {
        $notificationHtml = '';
        ContextCore::getContext()->controller->addJS(_PS_MODULE_DIR_ . 'oct8ne/views/js/oct8neadmin.js?v=' . $this->version);

        if (self::isZipVersion()) {
            $notificationHtml = $this->renderUpdateNotification();
        }
        // Ejecutamos el postprocess
        $this->postProcess();

        $api_key = Configuration::get(self::$API_TOKEN_CK);
        $settingsForms = '';

        // si no hay api key es que no estamos registrados por lo tanto llamamos a iniciar sesion
        if (empty($api_key)) {
            $settingsForms = $this->renderSettingsForm();
        // si hay api key es que estamos iniciados, mostramos una vista para cerrar sesión
        } else {
            $settingsForms = $this->renderLoggedForm() . $this->renderSearchEngineForm() . $this->renderPositionLoadForm() . $this->renderUpdateNotifierForm();
        }

        return $notificationHtml . $settingsForms;
    }

    public function renderUpdateNotifierForm()
    {
        $form_schema = [];
        $form_schema[] = $this->getUpdateNotifierFormSchema();

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->identifier = $this->identifier;

        $helper->submit_action = 'oct_update_notifier_changed';

        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = [
            'fields_value' => [
                self::$UPDATE_NOTIFIER => Configuration::get(self::$UPDATE_NOTIFIER),
            ],
        ];

        $formHtml = $helper->generateForm($form_schema);
        $this->context->smarty->assign('formHtml', $formHtml);

        return $this->display(__FILE__, 'views/templates/admin/update_notifier_form.tpl');
    }

    private function getUpdateNotifierFormSchema()
    {
        return [
            'form' => [
                'input' => [
                    [
                        'type' => 'switch',
                        'required' => true,
                        'label' => $this->l('Notify when a new version is available:'),
                        'name' => self::$UPDATE_NOTIFIER,
                        'is_bool' => true,
                        'desc' => $this->l('Enable or disable update notifications in the module manager.'),
                        'values' => [
                            [
                                'id' => 'active_on',
                                'value' => 1,
                                'label' => $this->l('Enabled'),
                            ],
                            [
                                'id' => 'active_off',
                                'value' => 0,
                                'label' => $this->l('Disabled'),
                            ],
                        ],
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save'),
                    'icon' => 'process-icon-save',
                ],
            ],
        ];
    }

    /**
     * Submit Llegada de formularios
     */
    public function postProcess()
    {
        try {
            // si el submit es de tipo login, hacemos las comprobaciones pertinentes
            if ((bool) Tools::isSubmit('login') == true) {
                $email = pSQL(trim(strip_tags(Tools::getValue(self::$EMAIL_CK))));
                $password = pSQL(trim(strip_tags(Tools::getValue(self::$PASSWORD_CK))));
                $check = $this->checkOct8neLinkUp($email, $password);

                if (!empty($email) && !empty($password) && $check != false) {                    // guardamos las variables de configuracion si to.do está correcto
                    Configuration::updateValue(self::$LICENSE_ID_CK, $check['license']);
                    Configuration::updateValue(self::$API_TOKEN_CK, $check['token']);
                    Configuration::updateValue(self::$EMAIL_CK, $email);
                    Configuration::updateValue(self::$SEARCH_ENGINE, 1);
                    Configuration::updateValue(self::$POSITION_LOAD, 1);
                    Configuration::updateValue(self::$URL_IMG_TYPE, 1);

                    Configuration::updateValue(self::$SERVER_OC_CK, $check['server']);
                    Configuration::updateValue(self::$URL_STATIC_OC_CK, $check['urlstatic']);
                } else {
                    $error_msg = $this->l('Cannot login, please check your credentials');
                    $this->context->controller->errors[] = $error_msg;
                }

            // si el submit es de tipo logout, borramos la configuracion
            } elseif ((bool) Tools::isSubmit('logout') == true) {
                Configuration::deleteByName(self::$EMAIL_CK);
                Configuration::deleteByName(self::$API_TOKEN_CK);
                Configuration::deleteByName(self::$LICENSE_ID_CK);
                Configuration::deleteByName(self::$SEARCH_ENGINE);
                Configuration::deleteByName(self::$POSITION_LOAD);
                Configuration::deleteByName(self::$URL_IMG_TYPE);
                Configuration::deleteByName(self::$SERVER_OC_CK);
                Configuration::deleteByName(self::$URL_STATIC_OC_CK);
                Configuration::deleteByName(self::$URL_API_EMPATHYBROKER);
                Configuration::deleteByName(self::$SCRIPT_LOAD_EVENTS);
                Configuration::deleteByName(self::$SCRIPT_LOAD_TIMER);
                Configuration::deleteByName(self::$UPDATE_NOTIFIER);
            } elseif ((bool) Tools::isSubmit('oct_search_engine_changed') == true) {
                $engine = pSQL(trim(strip_tags(Tools::getValue(self::$SEARCH_ENGINE))));
                Configuration::updateValue(self::$SEARCH_ENGINE, $engine);

                $id_shop = (int) $this->getContext()->shop->id;
                $languages = Language::getLanguages(true, $id_shop);

                foreach ($languages as $language) {
                    // $iso_code = strtoupper($language['iso_code']);
                    $iso_code = $language['language_code'];

                    $getInputValue = function ($configKey) use ($iso_code) {
                        return pSQL(trim(strip_tags(Tools::getValue($configKey . '_' . $iso_code))));
                    };

                    // Guardar valores para cada campo con sufijo de idioma
                    $url_type_empathybroker = $getInputValue(self::$URL_API_EMPATHYBROKER) ?: 'https://api.empathybroker.com/search/v1/query/INSTANCE_ID/search?q=';
                    $endpoint_motiveSearch = $getInputValue(self::$ENDPOINT_APISEARCH) ?: self::$DEFAULT_ENDPOINT_APISEARCH;
                    $indexId_motiveSearch = $getInputValue(self::$INDEXID_APISEARCH);
                    $site_motiveSearch = $getInputValue(self::$SITE_APISEARCH);
                    $url_type_motiveSearch = $getInputValue(self::$URL_API_MOTIVESEARCH) ?: 'https://search.api.motive.co/search';
                    $tenant_type_motiveSearch = $getInputValue(self::$TENANT_MOTIVESEARCH);
                    $doofinderHashId = $getInputValue(self::$DOOFINDER_HASH_ID);
                    $doofinderApiKey = $getInputValue(self::$DOOFINDER_API_KEY);
                    $doofinderSearchZone = $getInputValue(self::$DOOFINDER_SEARCH_ZONE);
                    $doofinderQueryName = $getInputValue(self::$DOOFINDER_QUERY_NAME);
                    $doofinderIndices = $getInputValue(self::$DOOFINDER_INDICES);
                    $doofinderProductIdProperty = $getInputValue(self::$DOOFINDER_PRODUCTID_PROPERTY);
                    $empathyEndpoint = $getInputValue(self::$EMPATHY_API_ENDPOINT);
                    $empathySiteId = $getInputValue(self::$EMPATHY_SITE_ID);
                    $empathyInstance = $getInputValue(self::$EMPATHY_INSTANCE);
                    $empathyLang = $getInputValue(self::$EMPATHY_LANG);
                    $empathyStore = $getInputValue(self::$EMPATHY_STORE);

                    $kimeraEndpoint = $getInputValue(self::$KIMERA_API_ENDPOINT);
                    $kimeraStoreId = $getInputValue(self::$KIMERA_STORE_ID);
                    $kimeraApiKey = $getInputValue(self::$KIMERA_API_KEY);
                    $kimeraLang = $getInputValue(self::$KIMERA_LANG);
                    $kimeraPassword = $getInputValue(self::$KIMERA_PASSWORD);
                    $kimeraInputMode = $getInputValue(self::$KIMERA_INPUT_MODE);

                    Configuration::updateValue(self::$URL_API_EMPATHYBROKER . '_' . $iso_code, $url_type_empathybroker);
                    Configuration::updateValue(self::$ENDPOINT_APISEARCH . '_' . $iso_code, $endpoint_motiveSearch);
                    Configuration::updateValue(self::$INDEXID_APISEARCH . '_' . $iso_code, $indexId_motiveSearch);
                    Configuration::updateValue(self::$SITE_APISEARCH . '_' . $iso_code, $site_motiveSearch);
                    Configuration::updateValue(self::$URL_API_MOTIVESEARCH . '_' . $iso_code, $url_type_motiveSearch);
                    Configuration::updateValue(self::$TENANT_MOTIVESEARCH . '_' . $iso_code, $tenant_type_motiveSearch);
                    Configuration::updateValue(self::$DOOFINDER_API_KEY . '_' . $iso_code, $doofinderApiKey);
                    Configuration::updateValue(self::$DOOFINDER_HASH_ID . '_' . $iso_code, $doofinderHashId);
                    Configuration::updateValue(self::$DOOFINDER_SEARCH_ZONE . '_' . $iso_code, $doofinderSearchZone);
                    Configuration::updateValue(self::$DOOFINDER_QUERY_NAME . '_' . $iso_code, $doofinderQueryName);
                    Configuration::updateValue(self::$DOOFINDER_INDICES . '_' . $iso_code, $doofinderIndices);
                    Configuration::updateValue(self::$DOOFINDER_PRODUCTID_PROPERTY . '_' . $iso_code, $doofinderProductIdProperty);
                    Configuration::updateValue(self::$EMPATHY_API_ENDPOINT . '_' . $iso_code, $empathyEndpoint);
                    Configuration::updateValue(self::$EMPATHY_SITE_ID . '_' . $iso_code, $empathySiteId);
                    Configuration::updateValue(self::$EMPATHY_INSTANCE . '_' . $iso_code, $empathyInstance);
                    Configuration::updateValue(self::$EMPATHY_LANG . '_' . $iso_code, $empathyLang);
                    Configuration::updateValue(self::$EMPATHY_STORE . '_' . $iso_code, $empathyStore);

                    Configuration::updateValue(self::$KIMERA_API_ENDPOINT . '_' . $iso_code, $kimeraEndpoint);
                    Configuration::updateValue(self::$KIMERA_STORE_ID . '_' . $iso_code, $kimeraStoreId);
                    Configuration::updateValue(self::$KIMERA_API_KEY . '_' . $iso_code, $kimeraApiKey);
                    Configuration::updateValue(self::$KIMERA_LANG . '_' . $iso_code, $kimeraLang);
                    Configuration::updateValue(self::$KIMERA_PASSWORD . '_' . $iso_code, $kimeraPassword);
                    Configuration::updateValue(self::$KIMERA_INPUT_MODE . '_' . $iso_code, $kimeraInputMode);
                }
            } elseif ((bool) Tools::isSubmit('oct_options_changed') == true) {
                $position = pSQL(trim(strip_tags(Tools::getValue(self::$POSITION_LOAD)))); // posicion donde se cargara el js de oct8ne
                $url_img_type = pSQL(trim(strip_tags(Tools::getValue(self::$URL_IMG_TYPE)))); // image url type
                $order_details_by = pSQL(trim(strip_tags(Tools::getValue(self::$ORDER_DETAILS_BY)))); // order details by
                $script_events = pSQL(trim(strip_tags(Tools::getValue(self::$SCRIPT_LOAD_EVENTS))));
                $script_timer = pSQL(trim(strip_tags(Tools::getValue(self::$SCRIPT_LOAD_TIMER))));
                $update_notifier = pSQL(trim(strip_tags(Tools::getValue(self::$UPDATE_NOTIFIER))));

                $client_extra_script = trim(strip_tags(Tools::getValue(self::$CLIENT_EXTRA_SCRIPT)));

                if (!empty($client_extra_script)) {
                    Configuration::updateValue(self::$CLIENT_EXTRA_SCRIPT, $client_extra_script);
                }

                // update values
                Configuration::updateValue(self::$POSITION_LOAD, $position);
                Configuration::updateValue(self::$URL_IMG_TYPE, $url_img_type);
                Configuration::updateValue(self::$ORDER_DETAILS_BY, $order_details_by);
                Configuration::updateValue(self::$SCRIPT_LOAD_EVENTS, $script_events);
                Configuration::updateValue(self::$SCRIPT_LOAD_TIMER, $script_timer);
                Configuration::updateValue(self::$UPDATE_NOTIFIER, $update_notifier);
            } elseif ((bool) Tools::isSubmit('oct_update_notifier_changed') == true) {
                $update_notifier = pSQL(trim(strip_tags(Tools::getValue(self::$UPDATE_NOTIFIER))));
                Configuration::updateValue(self::$UPDATE_NOTIFIER, $update_notifier);
            }
        } catch (Exception $ex) {
            $this->context->controller->errors[] = $ex->getMessage();
        }
    }

    /**
     * Muestra el formulario de inicio de sesion
     * inicio sesion
     */
    private function renderSettingsForm()
    {
        // Esquleto del formulario
        $form_schema = [];
        // Configuración General
        $form_schema[] = $this->getSettingsFormSchema();

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'login';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = [
            'fields_value' => [self::$EMAIL_CK => pSQL(Tools::getValue(self::$EMAIL_CK)), self::$PASSWORD_CK => pSQL(Tools::getValue(self::$PASSWORD_CK))], /* Add values for your inputs */
        ];

        return $helper->generateForm($form_schema);
    }

    /**
     * Esquema del formulario de inicio de sesion
     *
     * @return array
     */
    private function getSettingsFormSchema()
    {
        $id_lang = (int) $this->context->employee->id_lang;
        $lang = new Language($id_lang);
        $iso = $lang->locale;
        $safe_iso = htmlspecialchars($iso, ENT_QUOTES, 'UTF-8');

        return [
            'form' => [
                'legend' => [
                    'title' => $this->l('Oct8ne Settings'),
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'text',
                        'name' => self::$EMAIL_CK,
                        'required' => true,
                        'label' => $this->l('Email'),
                        'class' => 'col-lg-4',
                        'placeholder' => $this->l('Your email...'),
                        'prefix' => "<i class='icon-envelope'></i>",
                    ],
                    [
                        'type' => 'password',
                        'name' => self::$PASSWORD_CK,
                        'required' => true,
                        'label' => $this->l('Password'),
                        'placeholder' => $this->l('Your password'),
                        'class' => 'col-lg-6',
                    ],
                    [
                        'type' => 'html',
                        'name' => 'help',
                        'html_content' => $this->l('You must fill out the fields with your user information from the admin panel on Oct8ne. If you still do not have an Oct8ne user name, you can create one') . " <a href='https://secure.oct8ne.com/SignUp/StepOne?lang={$safe_iso}' target='_blank' >" . $this->l('here') . '</a>',
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Login'),
                ],
            ],
        ];
    }

    /**
     * Muestra el formulario de cerrar sesion
     */
    private function renderLoggedForm()
    {
        // Esquleto del formulario
        $form_schema = [];
        // Configuración General
        $form_schema[] = $this->getLoggedFormSchema();

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'logout';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = [
            'fields_value' => ['email' => Configuration::get(self::$EMAIL_CK)], /* Add values for your inputs */
        ];

        return $helper->generateForm($form_schema);
    }

    /**
     * Muestra el formulario de metodo de busqueda
     */
    private function renderSearchEngineForm()
    {
        // Obtenemos los motores de búsqueda
        $search_engines = $this->getDetectedSearchEngines();

        // Esquema del formulario
        $form_schema = [];
        // Configuración General
        $form_schema[] = $this->getSearchEngineFormSchema($search_engines);

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'oct_search_engine_changed';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $id_shop = (int) $this->getContext()->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        $fields_values = [
            self::$SEARCH_ENGINE => Configuration::get(self::$SEARCH_ENGINE),
        ];

        foreach ($languages as $language) {
            // Usamos language_code para compatibilidad con Kimera (ej: en-us)
            $iso_code = $language['language_code'];
            $iso_short = $language['iso_code'];

            $getConfigValue = function ($configKey) use ($iso_code) {
                $configValue = Configuration::get($configKey . '_' . $iso_code);
                if (empty($configValue)) {
                    $configValue = Configuration::get($configKey);
                }

                return $configValue;
            };

            $fields_values[self::$URL_API_EMPATHYBROKER . '_' . $iso_code] = $getConfigValue(self::$URL_API_EMPATHYBROKER);
            $fields_values[self::$ENDPOINT_APISEARCH . '_' . $iso_code] = $getConfigValue(self::$ENDPOINT_APISEARCH) ?: self::$DEFAULT_ENDPOINT_APISEARCH;
            $fields_values[self::$INDEXID_APISEARCH . '_' . $iso_code] = $getConfigValue(self::$INDEXID_APISEARCH);
            $fields_values[self::$SITE_APISEARCH . '_' . $iso_code] = $getConfigValue(self::$SITE_APISEARCH);
            $fields_values[self::$URL_API_MOTIVESEARCH . '_' . $iso_code] = $getConfigValue(self::$URL_API_MOTIVESEARCH);
            $fields_values[self::$TENANT_MOTIVESEARCH . '_' . $iso_code] = $getConfigValue(self::$TENANT_MOTIVESEARCH);

            // Doofinder
            $fields_values[self::$DOOFINDER_API_KEY . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_API_KEY);
            $fields_values[self::$DOOFINDER_HASH_ID . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_HASH_ID);
            $fields_values[self::$DOOFINDER_SEARCH_ZONE . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_SEARCH_ZONE);
            $fields_values[self::$DOOFINDER_QUERY_NAME . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_QUERY_NAME);
            $fields_values[self::$DOOFINDER_INDICES . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_INDICES);
            $fields_values[self::$DOOFINDER_PRODUCTID_PROPERTY . '_' . $iso_code] = $getConfigValue(self::$DOOFINDER_PRODUCTID_PROPERTY);

            // Empathy
            $fields_values[self::$EMPATHY_API_ENDPOINT . '_' . $iso_code] = $getConfigValue(self::$EMPATHY_API_ENDPOINT);
            $fields_values[self::$EMPATHY_SITE_ID . '_' . $iso_code] = $getConfigValue(self::$EMPATHY_SITE_ID);
            $fields_values[self::$EMPATHY_INSTANCE . '_' . $iso_code] = $getConfigValue(self::$EMPATHY_INSTANCE);
            $valEmpathy = $getConfigValue(self::$EMPATHY_LANG);
            $fields_values[self::$EMPATHY_LANG . '_' . $iso_code] = !empty($valEmpathy) ? $valEmpathy : $iso_short;

            $valStore = $getConfigValue(self::$EMPATHY_STORE);
            $fields_values[self::$EMPATHY_STORE . '_' . $iso_code] = !empty($valStore) ? $valStore : $iso_short;

            // Kimera
            $fields_values[self::$KIMERA_API_ENDPOINT . '_' . $iso_code] = $getConfigValue(self::$KIMERA_API_ENDPOINT);
            $fields_values[self::$KIMERA_STORE_ID . '_' . $iso_code] = $getConfigValue(self::$KIMERA_STORE_ID);
            $fields_values[self::$KIMERA_API_KEY . '_' . $iso_code] = $getConfigValue(self::$KIMERA_API_KEY);
            $valKimera = $getConfigValue(self::$KIMERA_LANG);
            $fields_values[self::$KIMERA_LANG . '_' . $iso_code] = !empty($valKimera) ? $valKimera : $iso_short;

            $fields_values[self::$KIMERA_PASSWORD . '_' . $iso_code] = $getConfigValue(self::$KIMERA_PASSWORD);
            $fields_values[self::$KIMERA_INPUT_MODE . '_' . $iso_code] = $getConfigValue(self::$KIMERA_INPUT_MODE);
        }

        $helper->tpl_vars = [
            'fields_value' => $fields_values,
        ];

        return $helper->generateForm($form_schema);
    }

    /**
     * Devuelve una lista de motores de búsqueda detectados
     *
     * @return array
     */
    public function getDetectedSearchEngines()
    {
        // Cargamos la libreria para determina los tipos soportados
        $this->loadLibrary('OctSearchEngineType', 'search');
        $search_engines = [];

        // Por defecto
        $search_engines[OctSearchEngineType::Internal] = $this->l('Default prestashop search engine');
        $search_engines[OctSearchEngineType::Empathybroker] = $this->l('Empathybroker search engine');
        $search_engines[OctSearchEngineType::MotiveSearch] = $this->l('Motive search engine');
        $search_engines[OctSearchEngineType::ApiSearch] = $this->l('ApiSearch engine');
        $search_engines[OctSearchEngineType::EcommFinderSearch] = $this->l('EcommFinder Search engine');
        $search_engines[OctSearchEngineType::Doofinder] = $this->l('Doofinder search engine');
        $search_engines[OctSearchEngineType::EmpathyCoSearch] = $this->l('EmpathyCo search engine');
        $search_engines[OctSearchEngineType::KimeraSearch] = $this->l('Kimera search engine');

        if (Module::isEnabled('ambjolisearch')) {
            $search_engines[OctSearchEngineType::JolieSearch] = $this->l('JoliSearch');
        }

        return $search_engines;
    }

    /**
     * Esquema del formulario para cambiar el metodo de busqueda
     *
     * @return array
     */
    private function getSearchEngineFormSchema($search_engines)
    {
        $options = [];
        // Añadimos cada motor detectado
        foreach ($search_engines as $id => $name) {
            $options[] = [
                'id_option' => $id,
                'name' => $name,
            ];
        }

        $optionsQueryName = [
            [
                'id_option' => 'none',
                'name' => 'none',
            ],
            [
                'id_option' => 'match_and',
                'name' => 'match_and',
            ],
            [
                'id_option' => 'match_or',
                'name' => 'match_or',
            ],
            [
                'id_option' => 'fuzzy',
                'name' => 'fuzzy',
            ],
        ];

        $kimeraInputModeOptions = [
            [
                'id_option' => '1',
                'name' => 'Text (1)',
            ],
            [
                'id_option' => '0.5',
                'name' => 'Hybrid (0.5) - Text & Image (Recomended)',
            ],
            [
                'id_option' => '0',
                'name' => 'Image (0)',
            ],
        ];

        $searchEngineSchema = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Oct8ne search engine'),
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'select',
                        'required' => true,
                        'label' => $this->l('Search engine'),
                        'name' => self::$SEARCH_ENGINE,
                        'class' => 'search_engine',
                        'desc' => ' ',
                        'options' => [
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name',
                        ],
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save changes'),
                    'icon' => 'process-icon-save',
                ],
            ],
        ];

        $id_shop = (int) $this->getContext()->shop->id;
        $languages = Language::getLanguages(true, $id_shop);

        foreach ($languages as $language) {
            $languageCode = $language['language_code'];
            $languageName = $language['name'];

            $this->context->smarty->assign('languageName', $languageName);
            $separatorHtml = $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'oct8ne/views/templates/admin/_partials/language_separator.tpl');

            $searchEngineSchema['form']['input'][] = [
                'type' => 'html',
                'name' => 'separator_' . $languageCode,
                'html_content' => $separatorHtml,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('URL API') . ' (' . $languageCode . ')',
                'name' => self::$URL_API_EMPATHYBROKER . '_' . $languageCode,
                'class' => 'url_api_empathybroker',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('URL MOTIVE API') . ' (' . $languageCode . ')',
                'name' => self::$URL_API_MOTIVESEARCH . '_' . $languageCode,
                'class' => 'url_api_motiveSearch',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('TENANT MOTIVESEARCH') . ' (' . $languageCode . ')',
                'name' => self::$TENANT_MOTIVESEARCH . '_' . $languageCode,
                'class' => 'tenant_motiveSearch',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('EndPoint') . ' (' . $languageCode . ')',
                'name' => self::$ENDPOINT_APISEARCH . '_' . $languageCode,
                'class' => 'endpoint_apiSearch',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('Index ID') . ' (' . $languageCode . ')',
                'name' => self::$INDEXID_APISEARCH . '_' . $languageCode,
                'class' => 'indexid_apiSearch',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('Site') . ' (' . $languageCode . ')',
                'name' => self::$SITE_APISEARCH . '_' . $languageCode,
                'class' => 'site_apiSearch',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('DOOFINDER SEARCH ZONE') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_SEARCH_ZONE . '_' . $languageCode,
                'class' => 'doofinder_search_zone',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('DOOFINDER API KEY') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_API_KEY . '_' . $languageCode,
                'class' => 'doofinder_api_key',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('DOOFINDER HASH ID') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_HASH_ID . '_' . $languageCode,
                'class' => 'doofinder_hash_id',
                'desc' => ' ',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('DOOFINDER INDICES') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_INDICES . '_' . $languageCode,
                'class' => 'doofinder_indices',
                'desc' => 'Your search engine is composed by one or many Indices. With this config you can specify to search within one specific Index. If this parameter is not provided, the search will work with all Indices. You can specify multiple index separated by comma. These indices must all exist',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('DOOFINDER PRODUCTID PROPERTY') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_PRODUCTID_PROPERTY . '_' . $languageCode,
                'class' => 'doofinder_productId_property',
                'desc' => 'The name of the property on doofinder feed that contains the product ID  from prestashop database. If not provided, will use "id" property by default.',
                'size' => 75,
            ];
            $searchEngineSchema['form']['input'][] = [
                'type' => 'select',
                'required' => true,
                'label' => $this->l('DOOFINDER QUERY TYPE') . ' (' . $languageCode . ')',
                'name' => self::$DOOFINDER_QUERY_NAME . '_' . $languageCode,
                'class' => 'doofinder_query_name',
                'desc' => 'none ==> Doofinder search service uses the best query for the search being made.</br>match_and ==> Doofinder will return results that contain all the search terms.</br>match_or ==> Doofinder will return results that contain any of the search terms. Of course, results that contain all the terms are scored better.</br>fuzzy ==> Doofinder will try to apply some «fuzzy logic» to determine whether a result, even if it’s not an exact match, is «close enough» to the search terms.',
                'options' => [
                    'query' => $optionsQueryName,
                    'id' => 'id_option',
                    'name' => 'name',
                ],
            ];

            // Empathy Co
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('EMPATHY SEARCH ENDPOINT') . ' (' . $languageCode . ')',
                'name' => self::$EMPATHY_API_ENDPOINT . '_' . $languageCode,
                'class' => 'empathy_api_endpoint',
                'placeholder' => 'https://api.empathy.co/search/v1/query/',
                'desc' => 'Default: https://api.empathy.co/search/v1/query',
                'size' => 75,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('EMPATHY SITE ID') . ' (' . $languageCode . ')',
                'name' => self::$EMPATHY_SITE_ID . '_' . $languageCode,
                'class' => 'empathy_site_id',
                'desc' => 'El Site ID proporcionado por Empathy',
                'size' => 75,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('EMPATHY INSTANCE') . ' (' . $languageCode . ')',
                'name' => self::$EMPATHY_INSTANCE . '_' . $languageCode,
                'class' => 'empathy_instance',
                'desc' => 'Ejemplo: myshop-es',
                'size' => 75,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('EMPATHY LANG') . ' (' . $languageCode . ')',
                'name' => self::$EMPATHY_LANG . '_' . $languageCode,
                'class' => 'empathy_lang',
                'desc' => 'Código de idioma: es, en, fr…',
                'size' => 75,
                // 'value' => $languageCode,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('EMPATHY STORE') . ' (' . $languageCode . ')',
                'name' => self::$EMPATHY_STORE . '_' . $languageCode,
                'class' => 'empathy_store',
                'desc' => 'Ej: es',
                'size' => 75,
            ];

            // Kimera
            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'label' => $this->l('KIMERA API ENDPOINT') . ' (' . $languageCode . ')',
                'name' => self::$KIMERA_API_ENDPOINT . '_' . $languageCode,
                'class' => 'kimera_api_endpoint',
                'placeholder' => 'https://api.kimeratechnologies.com/API/v3_0/DB/query',
                'desc' => 'Default: https://api.kimeratechnologies.com/API/v3_0/DB/query',
                'size' => 75,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('KIMERA API KEY (JWT)') . ' (' . $languageCode . ')',
                'name' => self::$KIMERA_API_KEY . '_' . $languageCode,
                'class' => 'kimera_api_key',
                'desc' => 'The long token can be viewed in the Kimera administration panel.',
                'size' => 75,
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'select',
                'required' => true,
                'label' => $this->l('KIMERA INPUT MODE') . ' (' . $languageCode . ')',
                'name' => self::$KIMERA_INPUT_MODE . '_' . $languageCode,
                'class' => 'kimera_input_mode',
                'desc' => 'Select search logic: 0 (Image only), 1 (Text only), or 0.5 (Hybrid). Default Hybrid(0.5)',
                'options' => [
                    'query' => $kimeraInputModeOptions,
                    'id' => 'id_option',
                    'name' => 'name',
                ],
            ];

            $searchEngineSchema['form']['input'][] = [
                'type' => 'text',
                'required' => true,
                'label' => $this->l('KIMERA LANG') . ' (' . $languageCode . ')',
                'name' => self::$KIMERA_LANG . '_' . $languageCode,
                'class' => 'kimera_lang',
                'desc' => 'Specific language code for Kimera (es, en, en-us...)',
                'size' => 75,
                // 'value' => $languageCode,
            ];
        }

        return $searchEngineSchema;
    }

    /**
     * Esquema del formulario cerrar sesion
     *
     * @return array
     */
    private function getLoggedFormSchema()
    {
        $this->context->smarty->assign('oct_mail', Configuration::get(self::$EMAIL_CK));

        return [
            'form' => [
                'legend' => [
                    'title' => $this->l('Oct8ne info'),
                    'icon' => 'icon-cogs',
                ],
                'input' => [
                    [
                        'type' => 'html',
                        'required' => true,
                        'label' => $this->l('Active User: '),
                        'name' => 'email',
                        'html_content' => $this->display(__FILE__, 'views/templates/admin/mail.tpl'),
                    ],
                ],

                'submit' => [
                    'title' => $this->l('Logout'),
                    'icon' => 'process-icon-close',
                ],
            ],
        ];
    }

    /**
     * Muestra el formulario para cambiar la posicion donde se carga el codigo de Oct8ne
     */
    public function renderPositionLoadForm()
    {        // Esquleto del formulario
        $form_schema = [];
        // Configuración General
        $form_schema[] = $this->getPositionLoadFormSchema();

        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'oct_options_changed';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = [
            'fields_value' => [self::$POSITION_LOAD => Configuration::get(self::$POSITION_LOAD), self::$URL_IMG_TYPE => Configuration::get(self::$URL_IMG_TYPE), self::$ORDER_DETAILS_BY => Configuration::get(self::$ORDER_DETAILS_BY), self::$CLIENT_EXTRA_SCRIPT => Configuration::get(self::$CLIENT_EXTRA_SCRIPT), self::$SCRIPT_LOAD_EVENTS => Configuration::get(self::$SCRIPT_LOAD_EVENTS), self::$SCRIPT_LOAD_TIMER => Configuration::get(self::$SCRIPT_LOAD_TIMER)], /* Add values for your inputs */
        ];

        return $helper->generateForm($form_schema);
    }

    /**
     * Esquema del formulario para cambiar la posicion donde se carga el codigo de Oct8ne
     *
     * @return array
     */
    private function getPositionLoadFormSchema()
    {
        $this->context->smarty->assign(self::$POSITION_LOAD, Configuration::get(self::$POSITION_LOAD));
        $this->context->smarty->assign(self::$URL_IMG_TYPE, Configuration::get(self::$URL_IMG_TYPE));
        $this->context->smarty->assign(self::$CLIENT_EXTRA_SCRIPT, Configuration::get(self::$CLIENT_EXTRA_SCRIPT));
        $this->context->smarty->assign(self::$SCRIPT_LOAD_EVENTS, Configuration::get(self::$SCRIPT_LOAD_EVENTS));
        $this->context->smarty->assign(self::$SCRIPT_LOAD_TIMER, Configuration::get(self::$SCRIPT_LOAD_TIMER));

        $options = [];
        // Añadimos cada motor detectado
        $options[] = [
            'id_option' => 1,
            'name' => $this->l('On Header'),
        ];

        $options[] = [
            'id_option' => 2,
            'name' => $this->l('On Footer'),
        ];

        $options2 = [];
        // Añadimos cada motor detectado
        $options2[] = [
            'id_option' => 1,
            'name' => $this->l('Standard'),
        ];

        $options2[] = [
            'id_option' => 2,
            'name' => 'Type 1',
        ];

        $options3 = [];
        $options3[] = [
            'id_option' => 'DISABLED',
            'name' => $this->l('Disabled'),
        ];
        $options3[] = [
            'id_option' => 'ALL',
            'name' => 'Any user event (Click, Scroll, Mousemove)',
        ];
        $options3[] = [
            'id_option' => 'scroll',
            'name' => 'Scroll',
        ];
        $options3[] = [
            'id_option' => 'click',
            'name' => 'Click',
        ];
        $options3[] = [
            'id_option' => 'mousemove',
            'name' => 'Mousemove',
        ];
        $options3[] = [
            'id_option' => 'SCRIPT',
            'name' => 'Script call',
        ];

        $options4 = [];
        $options4[] = [
            'id_option' => 0,
            'name' => $this->l('Disabled'),
        ];
        $options4[] = [
            'id_option' => 1,
            'name' => '1 sec',
        ];
        $options4[] = [
            'id_option' => 2,
            'name' => '2 secs',
        ];
        $options4[] = [
            'id_option' => 3,
            'name' => '3 secs',
        ];
        $options4[] = [
            'id_option' => 4,
            'name' => '4 secs',
        ];
        $options4[] = [
            'id_option' => 5,
            'name' => '5 secs',
        ];
        $options4[] = [
            'id_option' => 6,
            'name' => '6 secs',
        ];
        $options4[] = [
            'id_option' => 7,
            'name' => '7 secs',
        ];
        $options4[] = [
            'id_option' => 8,
            'name' => '8 secs',
        ];
        $options4[] = [
            'id_option' => 9,
            'name' => '9 secs',
        ];
        $options4[] = [
            'id_option' => 10,
            'name' => '10 secs',
        ];

        return [
            'form' => [
                'legend' => [
                    'title' => $this->l('Oct8ne options'),
                    'icon' => 'icon-cogs',
                ],

                'input' => [
                    [
                        'type' => 'select',
                        'required' => true,
                        'desc' => $this->l('You can choose the position to load Oct8ne scripts (On Footer or On Header) of the page'),
                        'label' => $this->l('Position'),
                        'name' => self::$POSITION_LOAD,
                        'options' => [
                            'query' => $options,
                            'id' => 'id_option',
                            'name' => 'name',
                        ],
                    ],
                    [
                        'type' => 'select',
                        'required' => true,
                        'label' => $this->l('Url image type'),
                        'desc' => $this->l('Type 1 adds product id before image id. Useful in specific instances. Be careful, change this option only when necessary'),
                        'name' => self::$URL_IMG_TYPE,
                        'options' => [
                            'query' => $options2,
                            'id' => 'id_option',
                            'name' => 'name',
                        ],
                    ],
                    [
                        'type' => 'text',
                        'required' => false,
                        'label' => $this->l('Get order details by'),
                        'desc' => $this->l('Select the parameter to get the order details by in the query'),
                        'name' => self::$ORDER_DETAILS_BY,
                    ],
                    [
                        'type' => 'select',
                        'required' => true,
                        'desc' => $this->l('**If you choose "Script call" you must call the function insertOct8ne();whenever you want load Oct8ne\'s code on the page.**'),
                        'label' => $this->l('Delay Oct8ne loading until user interaction:'),
                        'name' => self::$SCRIPT_LOAD_EVENTS,
                        'options' => [
                            'query' => $options3,
                            'id' => 'id_option',
                            'name' => 'name',
                        ],
                    ],
                    [
                        'type' => 'select',
                        'required' => true,
                        'desc' => $this->l(''),
                        'label' => $this->l('Delay Oct8ne loading on page (seconds):'),
                        'name' => self::$SCRIPT_LOAD_TIMER,
                        'options' => [
                            'query' => $options4,
                            'id' => 'id_option',
                            'name' => 'name',
                        ],
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save'),
                    'icon' => 'process-icon-save',
                ],
            ],
        ];
    }

    /**
     * Conecta con la API REST de Oct8ne y comprueba los datos de usuario
     *
     * @return array|bool
     */
    private function checkOct8neLinkUp($user, $pass)
    {
        try {
            // peticion
            $url = 'https://backoffice.oct8ne.com/platformConnection/linkup';
            $data = [
                'email' => $user,
                'pass' => $pass,
                'platform' => 'prestashop',
                'urlDomain' => $this->getContext()->shop->domain_ssl,
                'statusPlatform' => $this->active == 1,
            ];

            $encodedData = '';
            $encodedData = json_encode($data);

            $options = [
                'http' => [
                    'header' => 'Content-Type: application/json;charset=UTF-8',
                    'method' => 'POST',
                    'content' => $encodedData,
                ],
            ];
            $context = stream_context_create($options);
            $result = self::OctFileGetContents($url, false, $context);
            $result = json_decode($result);

            if (isset($result)) {
                // si se devuelve una licencia y token correctos se devuelve
                $license = $result->LicenseId;
                $token = $result->ApiToken;
                $server = $result->Server;
                $UrlStatic = $result->UrlStatic;
                // $msg = $result->Message;

                if ($license != null && $token != null) {
                    return ['license' => $license, 'token' => $token, 'server' => $server, 'urlstatic' => $UrlStatic];
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (Exception $ex) {
            return false;
        }
    }

    private static function octFileGetContents($url, $use_include_path = false, $stream_context = null, $curl_timeout = 5)
    {
        if ($stream_context == null && preg_match('/^https?:\/\//', $url)) {
            $stream_context = @stream_context_create([
                'http' => ['timeout' => $curl_timeout],
                'ssl' => [
                    'verify_peer' => true,
                    'verify_peer_name' => true,
                    'disable_compression' => true,
                    'allow_self_signed' => false,
                    'ciphers' => 'HIGH:!SSLv2:!SSLv3',
                ],
            ]);
        }

        $return = false;

        if (in_array(ini_get('allow_url_fopen'), ['On', 'on', '1']) || !preg_match('/^https?:\/\//', $url)) {
            $meth = 'file_get_contents';
            $return = @$meth($url, $use_include_path, $stream_context);
        }

        if ($return === false && function_exists('curl_init')) {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
            curl_setopt($curl, CURLOPT_TIMEOUT, $curl_timeout);

            curl_setopt($curl, CURLOPT_SSL_CIPHER_LIST, 'HIGH:!SSLv2:!SSLv3');

            curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: application/json;charset=UTF-8']);

            if ($stream_context != null) {
                $opts = stream_context_get_options($stream_context);

                if (isset($opts['http']['method']) && Tools::strtolower($opts['http']['method']) == 'post') {
                    curl_setopt($curl, CURLOPT_POST, true);

                    if (isset($opts['http']['content'])) {
                        curl_setopt($curl, CURLOPT_POSTFIELDS, $opts['http']['content']);
                    }
                }
            }
            $content = curl_exec($curl);
            curl_close($curl);
            $return = $content;
        }

        return $return;
    }

    private function formatPrice($price, $currency = null)
    {
        if (!$currency) {
            $currency = $this->context->currency;
        }

        if (version_compare(_PS_VERSION_, '1.7.7.0', '>=')) {
            // Desde PS 1.7.6 usamos el formateador de Locale

            $locale = $this->context->getCurrentLocale();

            return $locale->formatPrice($price, $currency->iso_code);
        } else {
            // Compatibilidad con PS 1.5 a 1.7.5
            return $this->legacyDisplayPrice($price, $currency);
        }
    }

    private function legacyDisplayPrice($price, $currency)
    {
        // Solo PS < 1.7.6 usará esto
        $method = 'displayPrice';

        return Tools::$method($price, $currency);
    }

    /*
     * Hook actionValidateOrder
     * Es llamado al ser creado un pedido y crear el pixel de confirmacion de venta.
     */
    public function hookDisplayOrderConfirmation($params)
    {
        $license = Configuration::get(self::$LICENSE_ID_CK);
        $server = Configuration::get(self::$SERVER_OC_CK);
        $urlstatic = Configuration::get(self::$URL_STATIC_OC_CK);

        if (!empty($license) && !empty($server) && !empty($urlstatic)) {
            // LÓGICA DE COMPATIBILIDAD 1.6 - 9.0
            $order = null;
            if (isset($params['order'])) {
                $order = $params['order']; // PS 1.7, 8, 9
            } elseif (isset($params['objOrder'])) {
                $order = $params['objOrder']; // PS 1.6
            }

            if ($order && Validate::isLoadedObject($order)) {
                $currency = Currency::getCurrency($order->id_currency);
                $isoLang = Language::getIsoById($order->id_lang);
                $total = $this->formatPrice($order->total_paid);

                // Compatibilidad array vs objeto currency según versión
                $sign = ($currency && is_array($currency)) ? $currency['sign'] : (is_object($currency) ? $currency->sign : '');
                $currencyIso = ($currency && is_array($currency)) ? $currency['iso_code'] : (is_object($currency) ? $currency->iso_code : '');

                if ($sign) {
                    $total = str_replace($sign, '', $total);
                }
                $total = str_replace(' ', '', $total);

                $this->context->smarty->assign([
                    'license' => $license,
                    'urlstatic' => $urlstatic,
                    'currency_code' => $currencyIso,
                    'locale' => $isoLang . '-' . Tools::strtoupper($isoLang),
                    'value' => $total,
                    'reference' => $order->reference,
                ]);

                return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'oct8ne/views/templates/hook/sale_notification.tpl');
            }
        }

        return '';
    }

    /**
     * Hook footer
     */
    public function hookDisplayFooter($params)
    {
        $position = Configuration::get(self::$POSITION_LOAD);

        if ($position == 2) {
            return $this->octDisplayCode();
        }

        return '';
    }

    /**
     * Hook header
     */
    public function hookDisplayHeader($params)
    {
        $position = Configuration::get(self::$POSITION_LOAD);

        if ($position == 1) {
            return $this->octDisplayCode();
        }

        return '';
    }

    /**
     * Codigo JS para el footer, solo disponible si existe licencia de oct8ne
     *
     * @return bool
     */
    public function octDisplayCode()
    {
        $license = Configuration::get(self::$LICENSE_ID_CK);

        if (!empty($license)) {
            $baseUrl = rtrim($this->context->shop->getBaseURL(), '/');

            $loginUrl = $this->context->link->getPageLink('authentication', true);

            $checkoutSuccessUrl = '';
            $aux = Configuration::get('PS_ORDER_PROCESS_TYPE');

            if ($aux == 0) {
                $checkoutSuccessUrl = $this->context->link->getPageLink('order', true);
            } elseif ($aux == 1) {
                $checkoutSuccessUrl = $this->context->link->getPageLink('order-opc', true);
            }

            $orderConfirmationUrl = $this->context->link->getPageLink('order-confirmation', true);

            $locale = $this->context->language->language_code;

            if (strpos($locale, '-') == true) {
                $aux = explode('-', $locale);
                $aux[1] = Tools::strtoupper($aux[1]);
                $locale = implode('-', $aux);
            }
            $currencyCode = $this->context->currency->iso_code;

            // /Comprobar si estamos es una pagina de producto
            $controller = $this->context->controller;

            if ($this->isaProductController()) {
                $product = new Product((int) Tools::getValue('id_product'), false, $this->getContext()->language->id);

                if (Validate::isLoadedObject($product) && ($product->price > 0 || $product->getPrice() > 0)) {
                    $id = $product->id;
                    $image = Product::getCover($id);
                    $image = $image['id_image'];

                    $thumbnail = $this->getContext()->link->getImageLink($product->link_rewrite, $image);

                    $this->context->smarty->assign([
                        'oct8ne_product_id' => $id,
                        'oct8ne_product_thumb' => $thumbnail,
                    ]);
                }
            }

            $baseUrl = Oct8ne::removeHttProtocol($baseUrl);
            $loginUrl = Oct8ne::removeHttProtocol($loginUrl);
            $checkoutSuccessUrl = Oct8ne::removeHttProtocol($checkoutSuccessUrl);
            $orderConfirmationUrl = Oct8ne::removeHttProtocol($orderConfirmationUrl);

            $server = Configuration::get(self::$SERVER_OC_CK);
            $urlstatic = Configuration::get(self::$URL_STATIC_OC_CK);
            $clientextraData = Configuration::get(self::$CLIENT_EXTRA_SCRIPT);

            if (!empty($clientextraData)) {
                $this->context->smarty->assign('oct8neExtraData', $clientextraData);
            }

            $scriptTimer = Configuration::get(self::$SCRIPT_LOAD_TIMER);
            $scriptTimer = (int) $scriptTimer;

            $scriptEvents = Configuration::get(self::$SCRIPT_LOAD_EVENTS);

            $userLastName = null;
            $userFirstName = null;
            $userEmail = null;

            if (empty($server)) {
                $server = 'backoffice.oct8ne.com/';
            }

            if (empty($urlstatic)) {
                $urlstatic = 'static.oct8ne.com/';
            }

            $customer = $this->getContext()->customer;

            if (!empty($customer) && Validate::isLoadedObject($customer) && $customer->isLogged() && !$customer->deleted) {
                $userFirstName = $customer->firstname;

                if (!empty($customer->lastname)) {
                    $userLastName = $customer->lastname;
                }
                $userEmail = $customer->email;
            }

            $this->context->smarty->assign([
                'oct8neLicense' => $license,
                'oct8neBaseUrl' => $baseUrl,
                'oct8neLoginUrl' => $loginUrl,
                'oct8neCheckOutSuccessUrl' => $checkoutSuccessUrl,
                'oct8neLocale' => $locale,
                'oct8neCurrencyCode' => $currencyCode,
                'oct8neorderConfirmationUrl' => $orderConfirmationUrl,
                'oct8neServer' => $server,
                'oct8neUrlStatic' => $urlstatic,
                'oct8neScriptTimer' => $scriptTimer,
                'oct8neScriptEvents' => $scriptEvents,
                'oct8neUserFirstName' => $userFirstName,
                'oct8neUserLastName' => $userLastName,
                'oct8neUserEmail' => $userEmail,
            ]);

            return $this->display(__FILE__, 'hookDisplayOctCode.tpl');
        } else {
            return false;
        }
    }

    private function isaProductController()
    {
        // Método 1
        $controller = $this->context->controller;

        if (isset($controller->php_self)) {
            if ($controller->php_self == 'product') {
                return true;
            }
        }

        // Método 2 - Legacy
        $class = get_class($controller);

        return Tools::strtolower($class) == 'productcontroller';
    }

    /**
     * Regla que permite a Oct8ne Conectar con nuestro controlador
     */
    public function setHtaccessRules()
    {
        return true;
    }

    /**
     * Eliminar regla Oct8ne
     */
    public function removeHtaccessRules()
    {
    }

    private function getOct8neUpdateData($force = false)
    {
        $cacheKey = 'OCT8NE_UPDATE_DATA_OBJ';
        $dbTimeKey = 'OCT8NE_UPDATE_LAST_CHECK';
        $dbDataKey = 'OCT8NE_UPDATE_JSON_DATA';
        $ttl = 86400;
        $isCacheEnabled = (defined('_PS_CACHE_ENABLED_') && _PS_CACHE_ENABLED_);
        $cache = Cache::getInstance();
        $remoteData = [];
        if ($isCacheEnabled) {
            if ($cache->exists($cacheKey)) {
                $remoteData = $cache->get($cacheKey);
                if (!empty($remoteData) && isset($remoteData['latest_version'])) {
                    if (version_compare($this->version, $remoteData['latest_version'], '>=')) {
                        return false;
                    }

                    return $remoteData;
                }
            }
        }
        $lastCheck = (int) Configuration::get($dbTimeKey);
        $storedJson = Configuration::get($dbDataKey);
        $currentTime = time();
        if ($currentTime > ($lastCheck + $ttl) || empty($storedJson)) {
            $apiResponse = $this->fetchUpdateData();
            if ($apiResponse && isset($apiResponse['latest_version'])) {
                $remoteData = $apiResponse;
                Configuration::updateValue($dbDataKey, json_encode($apiResponse));
                Configuration::updateValue($dbTimeKey, $currentTime);
                if ($isCacheEnabled) {
                    $cache->set($cacheKey, $remoteData, $ttl);
                }
            } elseif (!empty($storedJson)) {
                $remoteData = json_decode($storedJson, true);
            }
        } else {
            $remoteData = json_decode($storedJson, true);
            if ($isCacheEnabled) {
                $remainingTime = ($lastCheck + $ttl) - $currentTime;
                if ($remainingTime > 0) {
                    $cache->set($cacheKey, $remoteData, $remainingTime);
                }
            }
        }
        if (empty($remoteData) || !isset($remoteData['latest_version'])) {
            return false;
        }
        if (version_compare($this->version, $remoteData['latest_version'], '>=')) {
            return false;
        }

        return $remoteData;
    }

    public function hookDisplayBackOfficeHeader(array $params)
    {
        if (!self::isZipVersion()) {
            return '';
        }
        if (Configuration::get(self::$UPDATE_NOTIFIER) == 0) {
            return '';
        }
        $controller = Tools::getValue('controller');
        $allowedControllers = [
            'AdminModulesManage',
            'AdminModulesNotifications',
            'AdminModulesUpdates',
        ];
        if (!in_array($controller, $allowedControllers)) {
            return '';
        }
        $remoteData = $this->getOct8neUpdateData(false);
        if (!$remoteData) {
            return '';
        }
        $isoCode = $this->context->language->iso_code;
        $msgKey = 'message_' . $isoCode;
        $urlKey = 'download_url_' . $isoCode;
        $finalMessage = !empty($remoteData[$msgKey]) ? $remoteData[$msgKey] : ($remoteData['message'] ?? '');
        $finalUrl = !empty($remoteData[$urlKey]) ? $remoteData[$urlKey] : ($remoteData['download_url'] ?? '');
        $this->context->smarty->assign([
            'oct8ne_current_version' => $this->version,
            'oct8ne_latest_version' => $remoteData['latest_version'],
            'oct8ne_download_url' => $finalUrl,
            'oct8ne_message' => $finalMessage,
        ]);

        return $this->display(__FILE__, 'views/templates/admin/update_notification.tpl');
    }

    private function renderUpdateNotification()
    {
        $remoteData = $this->getOct8neUpdateData(true);
        if ($remoteData) {
            $isoCode = $this->context->language->iso_code;
            $msgKey = 'message_' . $isoCode;
            $urlKey = 'download_url_' . $isoCode;
            $finalMessage = !empty($remoteData[$msgKey]) ? $remoteData[$msgKey] : ($remoteData['message'] ?? '');
            $finalUrl = !empty($remoteData[$urlKey]) ? $remoteData[$urlKey] : ($remoteData['download_url'] ?? '');
            $this->context->smarty->assign([
                'oct8ne_current_version' => $this->version,
                'oct8ne_latest_version' => $remoteData['latest_version'],
                'oct8ne_download_url' => $finalUrl,
                'oct8ne_message' => $finalMessage,
            ]);

            return $this->context->smarty->fetch($this->local_path . 'views/templates/admin/update_notification.tpl');
        }

        return '';
    }

    private function fetchUpdateData()
    {
        $apiUrl = 'https://oct8ne.com/plugins/prestashop/update.json';
        if (!function_exists('curl_init')) {
            return false;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $curlError = curl_error($ch);
        curl_close($ch);
        if ($response === false || $httpCode !== 200) {
            return false;
        }
        $data = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return false;
        }
        if (!isset($data['latest_version']) || !isset($data['download_url'])) {
            return false;
        }

        return $data;
    }

    public static function isZipVersion()
    {
        return file_exists(_PS_MODULE_DIR_ . 'oct8ne/source.txt');
    }
}
