{*
* 2007-2025 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Oct8ne <support@oct8ne.com>
* @copyright 2007-2025 PrestaShop SA
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
* International Registered Trademark & Property of PrestaShop SA
*}
{* 1. Capturamos el HTML limpio *}
{capture name="oct8ne_alert_html"}
    <div class="bootstrap oct8ne-custom-notification" style="margin-bottom: 20px; margin-top: 15px;">
        
        <div style="
            background-color: #fcf8e3; 
            border: 1px solid #faebcc; 
            border-left: 4px solid #f0ad4e; 
            padding: 15px 20px; 
            color: #8a6d3b; 
            border-radius: 2px;
            display: flex; 
            justify-content: space-between; 
            align-items: center;
            font-family: 'Open Sans', Helvetica, Arial, sans-serif;
        ">
            
            <div style="display:flex; align-items:center;">
                <i class="material-icons" style="font-size: 28px; margin-right: 15px; color:#f0ad4e;">cloud_download</i>
                
                <div>
                    <h4 style="margin:0 0 5px 0; font-size: 15px; color: #8a6d3b; line-height: 1.2;">
                        <span style="font-weight:900; color:#333;">Oct8ne:</span> 
                        <span style="font-weight:normal;">{l s='New version available!' mod='oct8ne'}</span>
                    </h4>
                    <p style="margin:0; font-size: 13px; color: #8a6d3b;">
                        {l s='You are using version' mod='oct8ne'} <strong>{$oct8ne_current_version|escape:'html':'UTF-8'}</strong>. 
                        {l s='Version' mod='oct8ne'} <strong>{$oct8ne_latest_version|escape:'html':'UTF-8'}</strong> {l s='is available.' mod='oct8ne'}
                    </p>
                    
                    {if isset($oct8ne_message) && $oct8ne_message}
                        <p style="margin:5px 0 0 0; font-style:italic; font-size: 12px; opacity: 0.8;">
                            {$oct8ne_message|escape:'html':'UTF-8'}
                        </p>
                    {/if}
                </div>
            </div>

            {if isset($oct8ne_download_url) && $oct8ne_download_url}
                <div style="margin-left: 20px;">
                    <a href="{$oct8ne_download_url|escape:'html':'UTF-8'}" target="_blank" class="btn btn-warning" style="white-space: nowrap; font-weight: bold; box-shadow: none;">
                        {l s='Download v' mod='oct8ne'}{$oct8ne_latest_version|escape:'html':'UTF-8'}
                    </a>
                </div>
            {/if}
        </div>
    </div>
{/capture}

{* 2. Script JS para inyectarlo (Misma lógica que funciona) *}
<script type="text/javascript">
    (function() {
        var alertHtml = "{$smarty.capture.oct8ne_alert_html|escape:'javascript':'UTF-8'}";

        var injectAlert = function() {
            // Evitamos duplicados
            if ($('.oct8ne-custom-notification').length > 0) return true;

            // Lista de posibles contenedores
            var $target = $('.page-content').first();
            if ($target.length === 0) $target = $('#content').first();
            if ($target.length === 0) $target = $('.content-div').first();
            if ($target.length === 0) $target = $('#main').first();

            if ($target.length > 0) {
                $target.prepend(alertHtml);
                return true;
            }
            return false;
        };

        var attempts = 0;
        var intervalId = setInterval(function() {
            attempts++;
            if (injectAlert() || attempts >= 20) {
                clearInterval(intervalId);
            }
        }, 500);
    })();
</script>