<?php
/**
 * Prestashop module for Oct8ne
 *
 * @author    Prestaquality.com
 * @copyright 2016 Prestaquality
 * @license   Commercial license see license.txt *
 *
 * @category  Prestashop
 * @category  Module
 * Support by mail  : info@prestaquality.com
 */
if (!defined('_PS_VERSION_')) {
    exit;
}
class OctSearchFactory
{
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    /**
     * Devuelve el motor de busqueda especifico
     *
     * @param $param motor de busqueda
     *
     * @return OctDoofinderSearch|OctInternalSearch|null
     */
    public function getInstance($param)
    {
        // engine
        $searchEngine = null;
        switch ($param) {
            // internal
            case 1:
                require_once dirname(__FILE__) . '/OctInternalSearch.php';
                $searchEngine = new OctInternalSearch($this->context);
                break;
                // doofinder
            case 2:
                require_once dirname(__FILE__) . '/OctDoofinderSearch.php';
                $searchEngine = new OctDoofinderSearch($this->context);
                break;
                // empathybroker
            case 3:
                require_once dirname(__FILE__) . '/OctEmpathybrokerSearch.php';
                $searchEngine = new OctEmpathybrokerSearch($this->context);
                break;
                // JolieSearch
            case 4:
                require_once dirname(__FILE__) . '/OctJolieSearch.php';
                $searchEngine = new OctJolieSearch($this->context);
                break;
                // motivesearch
            case 5:
                require_once dirname(__FILE__) . '/OctMotiveSearch.php';
                $searchEngine = new OctMotiveSearch($this->context);
                break;
                // ApiSearch
            case 6:
                require_once dirname(__FILE__) . '/OctApiSearchSearch.php';
                $searchEngine = new OctApiSearchSearch($this->context);
                break;
                // EcommFinder
            case 7:
                require_once dirname(__FILE__) . '/OctEcommFinderSearch.php';
                $searchEngine = new OctEcommFinderSearch($this->context);
                break;
                // internal
            case 8:
                require_once dirname(__FILE__) . '/OctEmpathySearch.php';
                $searchEngine = new OctEmpathySearch($this->context);
                break;
                // Empathy Search (nuevo)
            case 9:
                require_once dirname(__FILE__) . '/OctKimeraSearch.php';
                $searchEngine = new OctKimeraSearch($this->context);
                break;
                // Kimera Search (nuevo)
            default:
                require_once dirname(__FILE__) . '/OctInternalSearch.php';
                $searchEngine = new OctInternalSearch($this->context);
                break;
        }

        return $searchEngine;
    }

    /**
     * Comprueba si el modulo esta activo o no
     */
    private function checkSearchEngine($name)
    {
        return Module::isEnabled($name);
    }
}
