<?php
/**
 * Oct8ne
 *
 * @author      Oct8ne
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once ("basesearch.php");

class AjaxSearchProOct8ne extends Oct8neBaseSearch
{

    public function getEngineName()
    {
        return "AjaxSearchPro";
    }

    public function search(){

        $result = array();
        $result["results"] = [];

        $args = array();

        $filterInfo = array();
        $filterInfo["applied"] = array();
        $filterInfo["available"] = array();

        $search = isset($_GET["search"]) ? sanitize_text_field($_GET["search"]) : '';

        $locale = isset($_GET["locale"]) ? sanitize_text_field($_GET["locale"]) : '';

        if (!isset($search) || empty($search)) return $result;

        //CRITERIO DE ORDENACION
        $orderby = isset($_GET["orderby"]) ? sanitize_text_field($_GET["orderby"]) : '';
        switch ($orderby) {

            case "relevance":
                $args["orderby"] = "relevance";
                break;

            case "name":
                $args["orderby"] = "title";
                break;

            case "price":
                $args["orderby"] = "meta_value_num";
                $args["meta_key"] = "_price"; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
                break;

            default:
                $args["orderby"] = "relevance";
                break;
        }


        //DIRECCION DE LA BUSQUEDA ASCENDENTE O DESCENTE
        $dir = $search = isset($_GET["dir"]) ? sanitize_text_field($_GET["dir"]) : "ASC";
        if (!isset($dir) || empty($dir)) $dir = "ASC";

        //NUMERO DE PAGINA
        $page = $search = isset($_GET["page"]) ? absint($_GET["page"]) : 1;
        if (!isset($page) || empty($page)) $page = 1;

        //NUMERO DE ELEMENTOS POR PAGINA
        $pagesize = $search = isset($_GET["pageSize"]) ? absint($_GET["pageSize"]) : 10;
        if (!isset($pagesize) || empty($pagesize)) $pagesize = 10;
        $args["posts_per_page"] = $pagesize;
        $args["s"] = $search;
        $args["page"] = $page;
        $args["post_type"] = "product";
        $args["post_status"] = "publish";
        $args["order"] = $dir;
        $args['suppress_filters'] = false;               

        try {
            if (in_array("wpml-all-import/wpml-all-import.php", apply_filters( 'active_plugins', get_option('active_plugins')))) {
                $lang = explode("-", $locale)[0];
                $args['_wpml_lang'] = $lang;
            }
        }
        catch(Exception $e) {
            
        }         
        
        $args['meta_query'] = array( // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_query
            //'relation' => 'OR',
            array(
                'key' => '_stock_status',
                'value' => 'instock',
                'compare' => '=',
            )
        );

          //Búsqueda por sku (la palabra debe empezar por '_')
        if (strpos($_GET["search"], '#') === 0) { 
            
             $sku = preg_replace('/#/', '', $_GET["search"], 1);
             $id = $this->get_product_by_sku($sku);
             if ( $id ) {
                $connector = new Oct8neConnector();
                $result["results"][] =  $connector->getProductData($id, $locale);
                $result["total"] = 1;
                $result["filters"] = $filterInfo;
            }

        }else{ //Sino es sku buscamos en el campo título.
            add_filter('posts_where', array('Oct8neConnector', 'alter_posts_where_clause'));        
            
            //obtiene los posts
            $asp_query = new ASP_Query($args);

            $myposts = $asp_query->posts;
            $count = $asp_query->found_posts;
            $result["total"] = $count;

            $connector = new Oct8neConnector();

            foreach ($myposts as $post) {
                $result["results"][] = $connector->getProductData($post->ID, $locale);          
            }

            $result["filters"] = $filterInfo;
        }
        return $result;
    }
    

    public function get_product_by_sku ($sku) {
        if ( function_exists( 'wc_get_product_id_by_sku' ) ) {
            return wc_get_product_id_by_sku( $sku );
        }
        return 0;  
    }
}