<?php
/*
Plugin Name: oct8ne
Plugin URI: https://oct8ne.com/
Description: Help your customers by showing them images and videos of your products using the coviewer to help them along in the decision making process.
Version: 1.1.6
Author: Oct8ne
License: GPL2
*/

if (!defined('ABSPATH')) {
    exit;
}

require_once('helpers/loginhelper.php');
require_once('helpers/oct8neHtaccessHelper.php');
require_once('helpers/jsinfo.php');
require_once('helpers/oct8nedb.php');
require_once('helpers/search/searchfactory.php');
require_once('helpers/wishlist/wishlistfactory.php');
require_once('helpers/translation/translationfactory.php');

if (!class_exists('WC_Oct8ne_Plugin')) :

    class WC_Oct8ne_Plugin
    {

        /**
         * Singleton
         * @var
         */
        public static $instance;


        /**
         * Get or create class
         * @return WC_Oct8ne_Plugin
         */
        public static function get_instance()
        {
            if (null === self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }
        //http://hookr.io/plugins/woocommerce/#index=a
        //https://businessbloomer.com/woocommerce-visual-hook-guide-cart-page/

        /**
         * WC_Oct8ne_Plugin constructor.
         */
        protected function __construct()
        {
            add_action('admin_init', array($this, 'check_environment'));
            add_action('admin_notices', array($this, 'admin_notices'), 15);
            add_action('admin_menu', array($this, 'init'));

            //Position to load js
            $position = get_option('oct8ne_js_position', 'Footer');
            if ($position == 'Footer') {
                add_action('wp_footer', array($this, 'addOct8neJs'));
            } else if ($position == 'Header') {
                add_action('wp_head', array($this, 'addOct8neJs'));
            } else {
                add_action('wp_footer', array($this, 'addOct8neJs'));
                update_option('oct8ne_js_position', 'Footer');
            }

            //register hooks
            register_deactivation_hook(__FILE__, array('WC_Oct8ne_Plugin', 'unistall'));
            register_activation_hook(__FILE__, array('WC_Oct8ne_Plugin', 'install'));
            register_uninstall_hook(__FILE__, array('WC_Oct8ne_Plugin', 'fullUninstall'));

            add_action('admin_init', array($this, 'oct8ne_register_settings'));
            add_action('admin_init', array($this, 'oct8ne_handle_login'));
            add_action('admin_init', array($this, 'oct8ne_handle_logout'));
        }





        function oct8ne_settings_page()
        {
            $license = get_option('oct8ne_license');

            if (empty($license)) {
?>
                <div class="wrap">
                    <h2><?php echo __('Oct8ne plugin configuration', 'oct8ne') ?></h2>
                    <?php settings_errors('oct8ne_login'); ?>
                    <form method="post" action="">
                        <table class="form-table">
                            <tr valign="top">
                                <th scope="row"><?php echo __('Email', 'oct8ne'); ?></th>
                                <td><input type="email" name="oct8ne_email" class="regular-text" required /></td>
                            </tr>
                            <tr valign="top">
                                <th scope="row"><?php echo __('Password', 'oct8ne'); ?></th>
                                <td><input type="password" name="oct8ne_password" class="regular-text" required /></td>
                            </tr>
                        </table>
                        <?php submit_button(__('Login', 'oct8ne'), 'primary', 'oct8ne_login'); ?>
                    </form>
                </div>
            <?php
            } else {
            ?>
                <div class="wrap">
                    <h2><?php echo __('Oct8ne plugin configuration', 'oct8ne') ?></h2>
                    <form method="post" action="options.php">
                        <?php
                        settings_fields('oct8ne-settings-group');
                        do_settings_sections('oct8ne');
                        submit_button();
                        ?>
                    </form>
                    <form method='POST' action=''>
                        <h1>Session</h1>
                        <br>
                        <table>
                            <tr>
                                <th><label for="oct8ne_value">Email: </label></th>
                                <td>
                                    <span id='oct8ne_value'> <?php echo get_option('oct8ne_email_linked'); ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php submit_button('Logout', 'primary', 'oct8ne_logout'); ?>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>
            <?php
            }
        }

        function oct8ne_handle_logout()
        {
            if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['oct8ne_logout'])) {
                delete_option('oct8ne_token');
                delete_option('oct8ne_license');
                delete_option('oct8ne_email');
                delete_option('oct8ne_server');
                delete_option('oct8ne_static');
                wp_redirect(admin_url('admin.php?page=oct8ne-settings'));
                exit;
            }
        }

        function oct8ne_handle_login()
        {
            if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['oct8ne_login'])) {
                $email = sanitize_email($_POST['oct8ne_email']);
                $password = sanitize_text_field($_POST['oct8ne_password']);

                $response = wp_remote_post('https://backoffice.oct8ne.com/platformConnection/linkup', array(
                    'method'    => 'POST',
                    'body'      => json_encode(array(
                        'email' => $email,
                        'pass' => $password,
                        'platform' => 'wordpress_v1',
                        'urlDomain' => site_url(),
                        'statusPlatform' => true
                    )),
                    'headers'   => array(
                        'Content-Type' => 'application/json'
                    ),
                    'timeout'   => 60, 
                ));

                if (is_wp_error($response)) {
                    add_settings_error('oct8ne_login', 'invalid_credentials', 'Invalid email or password', 'error');
                    return;
                }

                $body = wp_remote_retrieve_body($response);
                $response = json_decode($body, true);
                $apiToken = $response['ApiToken'];

                $licenseId = $response['LicenseId'];

                $server = $response['Server'];

                $UrlStatic = $response['UrlStatic'];
                if (isset($apiToken) && isset($licenseId) && !empty($apiToken) && !empty($licenseId)) {
                    update_option('oct8ne_token', $apiToken);
                    update_option('oct8ne_license', $licenseId);

                    if (isset($server) && !empty($server)) {

                        update_option('oct8ne_server', $server);
                    } else {
                        update_option('oct8ne_server', 'backoffice.oct8ne.com/');
                    }

                    if (isset($UrlStatic) && !empty($UrlStatic)) {

                        update_option('oct8ne_static', $UrlStatic);
                    } else {
                        update_option('oct8ne_static', 'static.oct8ne.com/');
                    }

                    update_option('oct8ne_email', $email);
                    update_option('oct8ne_email_linked', $email);
                    wp_redirect(admin_url('admin.php?page=oct8ne-settings'));
                    exit;
                }

                add_settings_error('oct8ne_login', 'invalid_credentials', 'Invalid email or password', 'error');
            }
        }

        function oct8ne_register_settings()
        {
            register_setting('oct8ne-settings-group', 'oct8ne_js_position');
            register_setting('oct8ne-settings-group', 'oct8ne_search_engine');
            register_setting('oct8ne-settings-group', 'oct8ne_wishlist_engine');
            register_setting('oct8ne-settings-group', 'oct8ne_translation_engine');
            register_setting('oct8ne-settings-group', 'oct8ne_script_extra');
            register_setting('oct8ne-settings-group', 'oct8ne_script_events');
            register_setting('oct8ne-settings-group', 'oct8ne_script_timer');
            register_setting('oct8ne-settings-group', 'oct8ne_email');

            add_settings_section('oct8ne_main_section', 'Oct8ne Settings', null, 'oct8ne');

            add_settings_field('oct8ne_email', 'Email', array($this, 'oct8ne_email_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_js_position', 'Javascript Position', array($this, 'oct8ne_js_position_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_search_engine', 'Search Engine', array($this, 'oct8ne_search_engine_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_wishlist_engine', 'WishList Engine', array($this, 'oct8ne_wishlist_engine_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_translation_engine', 'Translation Engine', array($this, 'oct8ne_translation_engine_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_script_extra', 'Additional script', array($this, 'oct8ne_script_extra_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_script_events', 'Delay Oct8ne loading until user interaction', array($this, 'oct8ne_script_events_callback'), 'oct8ne', 'oct8ne_main_section');
            add_settings_field('oct8ne_script_timer', 'Delay Oct8ne loading on page (seconds)', array($this, 'oct8ne_script_timer_callback'), 'oct8ne', 'oct8ne_main_section');
        }

        function oct8ne_email_callback()
        {
            $value = get_option('oct8ne_email_linked');
            echo "<input style='width: 200px' type='text' disabled name='oct8ne_email' value='$value' />";
        }

        function oct8ne_js_position_callback()
        {
            $options = Oct8neJsInfo::getPositions();
            $value = get_option('oct8ne_js_position');
            echo "<select style='width: 200px'  name='oct8ne_js_position'>";
            foreach ($options as $key => $label) {
                $selected = ($label) ? 'selected="selected"' : '';
                echo "<option value='$key' $selected>$key</option>";
            }
            echo "</select>";
        }

        function oct8ne_search_engine_callback()
        {
            $options = Oct8neSearchFactory::getEngines();
            $value = get_option('oct8ne_search_engine');
            echo "<select style='width: 200px'  name='oct8ne_search_engine'>";
            foreach ($options as $key => $label) {
                $selected = ($key == $value) ? 'selected="selected"' : '';
                echo "<option value='$key' $selected>$key</option>";
            }
            echo "</select>";
        }

        function oct8ne_wishlist_engine_callback()
        {
            $options = WishListFactory::getEngines();
            $value = get_option('oct8ne_wishlist_engine');
            echo "<select style='width: 200px'  name='oct8ne_wishlist_engine'>";
            foreach ($options as $key => $label) {
                $selected = ($key == $value) ? 'selected="selected"' : '';
                echo "<option value='$key' $selected>$key</option>";
            }
            echo "</select>";
        }

        function oct8ne_translation_engine_callback()
        {
            $options = Oct8neTranslationFactory::getEngines();
            $value = get_option('oct8ne_translation_engine');
            echo "<select style='width: 200px'  name='oct8ne_translation_engine'>";
            foreach ($options as $key => $label) {
                $selected = ($key == $value) ? 'selected="selected"' : '';
                echo "<option value='$key' $selected>$key</option>";
            }
            echo "</select>";
        }

        function oct8ne_script_extra_callback()
        {
            $value = get_option('oct8ne_script_extra');
            echo "<textarea style='width: 200px'  name='oct8ne_script_extra' style='width: 400px;height: 100px;'>$value</textarea>";
        }

        function oct8ne_script_events_callback()
        {
            $value = get_option('oct8ne_script_events');
            $options = [
                'Disabled' => 'Disabled',
                'All' => 'Any user event (Click, Scroll, Mousemove)',
                'scroll' => 'Scroll',
                'click' => 'Click',
                'mousemove' => 'Mousemove',
                'Script' => 'Script call',
            ];
            echo "<select style='width: 200px'  name='oct8ne_script_events'>";
            foreach ($options as $key => $label) {
                $selected = ($key == $value) ? 'selected="selected"' : '';
                echo "<option value='$key' $selected>$label</option>";
            }
            echo "</select>";
            echo "<br/><span style='font-size: 11px'>**If you choose \"Script call\" you must call the function <i>insertOct8ne();</i> whenever you want load Oct8ne's code on the page.**</span>";
        }

        function oct8ne_script_timer_callback()
        {
            $value = get_option('oct8ne_script_timer');
            $options = range(1, 10);
            array_unshift($options, 'Disabled');
            echo "<select style='width: 200px'  name='oct8ne_script_timer'>";
            foreach ($options as $option) {
                $selected = ($option == $value) ? 'selected="selected"' : '';
                echo "<option value='$option' $selected>$option</option>";
            }
            echo "</select>";
        }

        /**
         * Notificaciones
         * @var array
         */
        public $notices = array();

        /**
         * Private clone method to prevent cloning of the instance of the
         * *Singleton* instance.
         *
         * @return void
         */
        private function __clone()
        {
        }

        /**
         * Private unserialize method to prevent unserializing of the *Singleton*
         * instance.
         *
         * @return void
         */
        public function __wakeup()
        {
        }

        /**
         * On plugin activate
         */
        public static function install()
        {
            Oct8neHtaccessHelper::setHtaccessRules();

            //Oct8neDb::createTables();

            if (is_plugin_active("yith-woocommerce-wishlist/init.php")) {

                update_option('oct8ne_wishlist_engine', "yith-woocommerce-wishlist");
            }

            //var_dump(ob_get_contents());

        }

        /**
         * On plugin deactivate
         */
        public static function unistall()
        {
            Oct8neHtaccessHelper::removeHtaccessRules();
        }

        /**
         * On plugin delete
         */
        public static function fullUninstall()
        {
            //Oct8neDb::dropTables();

            delete_option('oct8ne_token');
            delete_option('oct8ne_license');
            delete_option('oct8ne_email');
            delete_option('oct8ne_search_engine');
            delete_option('oct8ne_wishlist_engine');
        }

        /**
         * Init the plugin after plugins_loaded so environment variables are set.
         */
        public function init()
        {
            // Don't hook anything else in the plugin if we're in an incompatible environment
            if (self::get_environment_warning()) {
                return;
            }

            add_submenu_page(
                'woocommerce',
                'Ajustes plugin Oct8ne',
                'Oct8ne',
                'administrator',
                'oct8ne-settings',
                array($this, 'oct8ne_settings_page')
            );
        }


        /**
         * Comprueba si se cumplen los requisitos para instalar oct8ne
         */
        public function check_environment()
        {

            $environment_warning = self::get_environment_warning();

            if ($environment_warning) {
                $this->add_admin_notice('bad_environment', 'error', $environment_warning);
            }

            //desactivar si no se cumplen
            if (count($this->notices) > 0) {

                deactivate_plugins(plugin_basename(__FILE__));
                $this->notices = array();
            }
        }


        /**
         * Comprobar requisitos
         * @return bool|string|void
         */
        static function get_environment_warning()
        {
            if (!defined('WC_VERSION')) {
                return __('Oct8ne requires WooCommerce to be activated to work.', 'Oct8ne');
            }

            return false;
        }

        /**
         * Errores a mostrar
         * @param $slug
         * @param $class
         * @param $message
         */
        public function add_admin_notice($slug, $class, $message)
        {
            $this->notices[$slug] = array(
                'class' => $class,
                'message' => $message,
            );
        }

        /**
         * Mostrando errores
         */
        public function admin_notices()
        {

            foreach ((array)$this->notices as $notice_key => $notice) {
                echo "<div class='" . esc_attr($notice['class']) . "'><p>";
                echo wp_kses($notice['message'], array('a' => array('href' => array())));
                echo '</p></div>';
            }


            if (count($this->notices) > 0) {

                add_filter('gettext', function ($translated_text, $untranslated_text, $domain) {

                    $old = array("Plugin <strong>activated</strong>.");
                    $new = "Oct8ne not installed";

                    if (in_array($untranslated_text, $old, true)) $translated_text = $new;
                    return $translated_text;
                }, 0, 3);
            }
        }

        /**
         * Añade el javascript necesario para que funcione Oct8ne
         */
        public function addOct8neJs()
        {

            if (Oct8neLoginHelper::isLogged()) {
            ?>
                <script type="text/javascript">
                    var oct8ne = document.createElement("script");
                    oct8ne.type = "text/javascript";
                    oct8ne.src = (document.location.protocol == "https:" ? "https://" : "http://") + "<?php echo Oct8neJsInfo::getUrlStatic(); ?>" + 'api/v2/oct8ne.js';
                    oct8ne.server = "<?php echo Oct8neJsInfo::getServer(); ?>";
                    oct8ne.async = true;
                    oct8ne.license = "<?php echo Oct8neJsInfo::getLicense(); ?>";
                    oct8ne.baseUrl = "<?php echo Oct8neJsInfo::getBaseUrl(); ?>";
                    oct8ne.checkoutUrl = "<?php echo Oct8neJsInfo::getCheckoutUrl(); ?>";
                    oct8ne.loginUrl = "<?php echo Oct8neJsInfo::getLoginUrl(); ?>";
                    oct8ne.checkoutSuccessUrl = "<?php echo Oct8neJsInfo::getSuccessUrl(); ?>";
                    oct8ne.locale = "<?php echo Oct8neJsInfo::getLocale(); ?>";
                    oct8ne.currencyCode = "<?php echo Oct8neJsInfo::getCurrency(); ?>";
                    oct8ne.platform = "wordpress_v1";
                    oct8ne.apiVersion = "2.5";
                    oct8ne.onProductAddedToCart = function(productId) {
                        //location.reload();
                    };

                    <?php if (Oct8neJsInfo::getExtraScript()) { ?>

                        <?php echo Oct8neJsInfo::getExtraScript(); ?>
                    <?php } ?>

                    <?php if (Oct8neJsInfo::isProductPage()) { ?>
                        oct8ne.currentProduct = {
                            id: "<?php echo Oct8neJsInfo::getProductId(); ?>",
                            thumbnail: "<?php echo Oct8neJsInfo::getProductThumbnail(); ?>"
                        };

                    <?php } ?>

                    <?php
                    $oct8neEvents = Oct8neJsInfo::getScriptEvents();
                    $oct8neTimer = Oct8neJsInfo::getScriptTimer();
                    ?>

                    <?php if ($oct8neEvents == "Disabled" && $oct8neTimer == "Disabled") { ?>
                        insertOct8ne();
                    <?php } else { ?>

                        if (document.cookie.indexOf("oct8ne-room") == -1) {
                            <?php if ($oct8neTimer != "Disabled") { ?>

                                setTimeout(insertOct8ne, <?php echo $oct8neTimer ?> * 1000);
                            <?php } ?>
                            <?php if ($oct8neEvents != "Disabled" && $oct8neEvents != "SCRIPT") { ?>
                                <?php if ($oct8neEvents == "All") { ?>

                                    window.addEventListener('mousemove', insertOct8ne);
                                    window.addEventListener('scroll', insertOct8ne);
                                    window.addEventListener('click', insertOct8ne);
                                    window.addEventListener('keydown', insertOct8ne);
                                    window.addEventListener('touchstart', insertOct8ne);
                                <?php } else { ?>

                                    window.addEventListener('<?php echo $oct8neEvents ?>', insertOct8ne);
                                <?php } ?>
                            <?php } ?>
                        } else {
                            insertOct8ne();
                        }
                    <?php } ?>

                    function insertOct8ne() {
                        if (!window.oct8neScriptInserted) {
                            var s = document.getElementsByTagName("script")[0];
                            s.parentNode.insertBefore(oct8ne, s);
                            window.oct8neScriptInserted = true;

                            <?php if ($oct8neEvents != "Disabled") { ?>
                                <?php if ($oct8neEvents == "All") { ?>

                                    window.removeEventListener('mousemove', insertOct8ne);
                                    window.removeEventListener('scroll', insertOct8ne);
                                    window.removeEventListener('click', insertOct8ne);
                                    window.removeEventListener('keydown', insertOct8ne);
                                    window.removeEventListener('touchstart', insertOct8ne);
                                <?php } else { ?>
                                    <?php if ($oct8neEvents != "Script") { ?>
                                        window.removeEventListener('<?php echo $oct8neEvents ?>', insertOct8ne);
                                    <?php } ?>
                                <?php } ?>
                            <?php } ?>

                        }
                    }
                </script>


                <?php
                try {
                    if (is_order_received_page()) {
                        $order_id = absint(get_query_var('order-received'));
                        if ($order_id) {
                            $order = wc_get_order($order_id);

                            if ($order) {
                                $total_pedido = $order->get_total();
                                $moneda_pedido = $order->get_currency();
                                $locale_pedido = get_locale();
                                $reference_pedido = $order->get_order_number();
                                $customer_id = $order->get_user_id();

                                echo "<script id='oct8ne-sale-notification' type='text/javascript' src='https://" . Oct8neJsInfo::getUrlStatic() . "api/source/js/ext/sale-notification.js?license=" . Oct8neJsInfo::getLicense() . "&CurrencyCode=" . $moneda_pedido . "&locale=" . $locale_pedido . "&value=" . $total_pedido . "&reference=" . $reference_pedido . "&CustomerId=" . $customer_id . "'></script>";
                            }
                        }
                    }
                } catch (Exception $e) {
                    echo "<!-- Error: Oct8ne pixel not available -->";
                }
                ?>


<?php
            }
        }
    }

    function oct8ne_endopint_register()
    {
        register_rest_route('oct8ne/v1', '/api/', array(
            'methods' => 'GET',
            'callback' => 'oct8ne_callback_function',
            'permission_callback' => '__return_true'  // Asegúrate de gestionar los permisos adecuadamente
        ));
    }

    add_action('rest_api_init', 'oct8ne_endopint_register');

    function oct8ne_callback_function(WP_REST_Request $request)
    {
        include_once plugin_dir_path(__FILE__) . 'actions/oct8neconnector/index.php';

        $result = postProcess();
        return new WP_REST_Response($result, 200);
    }

endif;

//Inicio de todoo
$GLOBALS['wc_soct8ne'] = WC_Oct8ne_Plugin::get_instance();


?>