<?php
/**
 * Oct8ne
 *
 * @author      Oct8ne
 * @version     1.0.0
 */

require_once ("basesearch.php");

class WoocommerceSearchOct8ne extends Oct8neBaseSearch
{

    public function getEngineName()
    {
        return "Woocommerce";
    }

    public function search(){

        $result = array();
        $args = array();

        $filterInfo = array();
        $filterInfo["applied"] = array();
        $filterInfo["available"] = array();

        $search = $_GET["search"];

        $locale = $_GET["locale"];

        if (!isset($search) || empty($search)) return $result;

        //CRITERIO DE ORDENACION
        $orderby = $_GET["orderby"];
        switch ($orderby) {

            case "relevance":
                $args["orderby"] = "relevance";
                break;

            case "name":
                $args["orderby"] = "title";
                break;

            case "price":
                $args["orderby"] = "meta_value_num";
                $args["meta_key"] = "_price";
                break;

            default:
                $args["orderby"] = "relevance";
                break;
        }


        //DIRECCION DE LA BUSQUEDA ASCENDENTE O DESCENTE
        $dir = $search = $_GET["dir"];
        if (!isset($dir) || empty($dir)) $dir = "ASC";

        //NUMERO DE PAGINA
        $page = $search = $_GET["page"];
        if (!isset($page) || empty($page)) $page = 1;

        //NUMERO DE ELEMENTOS POR PAGINA
        $pagesize = $search = $_GET["pageSize"];
        if (!isset($pagesize) || empty($pagesize)) $pagesize = 10;
        $args["posts_per_page"] = $pagesize;
        $args["s"] = $_GET["search"];
        $args["offset"] = ($page - 1) * $pagesize;
        $args["post_type"] = "product";
        $args["post_status"] = "publish";
        $args["order"] = $dir;
        $args['suppress_filters'] = true;
        
        
        $args['meta_query'] = array(
            //'relation' => 'OR',
            array(
                'key' => '_stock_status',
                'value' => 'instock',
                'compare' => '=',
            )
        );

        add_filter('posts_where', array('Oct8neConnector', 'alter_posts_where_clause'));



        //para obtener el total
        $my_query = new WP_Query($args);
        $count = $my_query->found_posts;


        //obtiene los posts
        $myposts = get_posts($args);

        $result["total"] = $count;

        $connector = new Oct8neConnector();

        foreach ($myposts as $post) {

            $result["results"][] = $connector->getProductData($post->ID, $locale);

        }


        $result["filters"] = $filterInfo;

        return $result;
    }
}