<?php

/**
 * Oct8ne
 *
 * @author      Oct8ne
 * @version     1.0.0
 */

class Oct8neHtaccessHelper
{

    /**
     * Regla que permite a Oct8ne Conectar con nuestro controlador
     */
    public static function setHtaccessRules()
    {
        $path = get_home_path() . '/.htaccess';

        $touch = touch($path);

        if ($touch) {
            if (is_writable($path)) {
                $rule = Oct8neHtaccessHelper::getHtaccessRule();
                $rule .= file_get_contents($path);
                file_put_contents($path, $rule, LOCK_EX);
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Eliminar regla Oct8ne
     */
    public static function removeHtaccessRules()
    {
        $path = get_home_path() . '/.htaccess';
        $fp = file_get_contents($path);
        $start = strpos($fp, '#Oct8ne');
        $end = strripos($fp, '#End_Oct8ne');
        if ($start !== false && $end !== false) {
            $to_delete = substr($fp, $start, ($end + strlen('#End_Oct8ne')));
            $fp = trim(str_replace($to_delete, '', $fp));
            file_put_contents($path, $fp, LOCK_EX);
        }
    }


    /**
     * @return string
     * Regla Htaccess para Oct8ne
     */
    private static function getHtaccessRule() {

        return '#Oct8ne 
<IfModule mod_rewrite.c>
RewriteEngine on
RewriteRule ^oct8ne/frame/([a-zA-Z]+)$ ' . plugins_url() . '/oct8ne/actions/oct8neconnector?octmethod=$1&%{QUERY_STRING} [QSA,L]
</IfModule>
#End_Oct8ne
        
';
    }
}